/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.properties;

import com.github.surpassm.security.enums.LoginResponseType;
import com.github.surpassm.security.properties.SessionProperties;
import com.github.surpassm.security.properties.app.Oauth2Properties;
import com.github.surpassm.security.properties.sms.SmsCodeProperties;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="surpassm.security")
public class SecurityProperties {
    Boolean enabled = false;
    private String headerKey = "Authorization";
    private String headerValue = "Bearer ";
    private String headerLogin = "Login";
    private String headerLoginValue = "Basic ";
    private LoginResponseType loginType = LoginResponseType.JSON;
    private String[] noVerify = new String[0];
    private String usernameParameter = "username";
    private String passwordParameter = "password";
    private String defaultUnauthenticatedUrl = "/authentication/require";
    private String defaultLoginProcessingUrlFrom = "/authentication/form";
    private String defaultLoginOutUrl = "/authentication/out";
    private String signUpUrl = "/liaoin-signUp.html";
    private String signOutUrl = "/error/404.html";
    private String loginPage = "/liaoin-signIn.html";
    private int rememberMeSeconds = 3600;
    private int maximumSessions = 1;
    private boolean maxSessionsPreventsLogin = false;
    private String sessionInvalidUrl = "/authentication/require";
    private SessionProperties session = new SessionProperties();
    private Oauth2Properties oauth2 = new Oauth2Properties();
    private SmsCodeProperties sms = new SmsCodeProperties();
    private String encryptKey = "d7b85f6e214abcda";

    public static SecurityPropertiesBuilder builder() {
        return new SecurityPropertiesBuilder();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getHeaderKey() {
        return this.headerKey;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public String getHeaderLogin() {
        return this.headerLogin;
    }

    public String getHeaderLoginValue() {
        return this.headerLoginValue;
    }

    public LoginResponseType getLoginType() {
        return this.loginType;
    }

    public String[] getNoVerify() {
        return this.noVerify;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public String getDefaultUnauthenticatedUrl() {
        return this.defaultUnauthenticatedUrl;
    }

    public String getDefaultLoginProcessingUrlFrom() {
        return this.defaultLoginProcessingUrlFrom;
    }

    public String getDefaultLoginOutUrl() {
        return this.defaultLoginOutUrl;
    }

    public String getSignUpUrl() {
        return this.signUpUrl;
    }

    public String getSignOutUrl() {
        return this.signOutUrl;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public int getRememberMeSeconds() {
        return this.rememberMeSeconds;
    }

    public int getMaximumSessions() {
        return this.maximumSessions;
    }

    public boolean isMaxSessionsPreventsLogin() {
        return this.maxSessionsPreventsLogin;
    }

    public String getSessionInvalidUrl() {
        return this.sessionInvalidUrl;
    }

    public SessionProperties getSession() {
        return this.session;
    }

    public Oauth2Properties getOauth2() {
        return this.oauth2;
    }

    public SmsCodeProperties getSms() {
        return this.sms;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setHeaderKey(String headerKey) {
        this.headerKey = headerKey;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    public void setHeaderLogin(String headerLogin) {
        this.headerLogin = headerLogin;
    }

    public void setHeaderLoginValue(String headerLoginValue) {
        this.headerLoginValue = headerLoginValue;
    }

    public void setLoginType(LoginResponseType loginType) {
        this.loginType = loginType;
    }

    public void setNoVerify(String[] noVerify) {
        this.noVerify = noVerify;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setDefaultUnauthenticatedUrl(String defaultUnauthenticatedUrl) {
        this.defaultUnauthenticatedUrl = defaultUnauthenticatedUrl;
    }

    public void setDefaultLoginProcessingUrlFrom(String defaultLoginProcessingUrlFrom) {
        this.defaultLoginProcessingUrlFrom = defaultLoginProcessingUrlFrom;
    }

    public void setDefaultLoginOutUrl(String defaultLoginOutUrl) {
        this.defaultLoginOutUrl = defaultLoginOutUrl;
    }

    public void setSignUpUrl(String signUpUrl) {
        this.signUpUrl = signUpUrl;
    }

    public void setSignOutUrl(String signOutUrl) {
        this.signOutUrl = signOutUrl;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public void setRememberMeSeconds(int rememberMeSeconds) {
        this.rememberMeSeconds = rememberMeSeconds;
    }

    public void setMaximumSessions(int maximumSessions) {
        this.maximumSessions = maximumSessions;
    }

    public void setMaxSessionsPreventsLogin(boolean maxSessionsPreventsLogin) {
        this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
    }

    public void setSessionInvalidUrl(String sessionInvalidUrl) {
        this.sessionInvalidUrl = sessionInvalidUrl;
    }

    public void setSession(SessionProperties session) {
        this.session = session;
    }

    public void setOauth2(Oauth2Properties oauth2) {
        this.oauth2 = oauth2;
    }

    public void setSms(SmsCodeProperties sms) {
        this.sms = sms;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityProperties)) {
            return false;
        }
        SecurityProperties other = (SecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$headerKey = this.getHeaderKey();
        String other$headerKey = other.getHeaderKey();
        if (this$headerKey == null ? other$headerKey != null : !this$headerKey.equals(other$headerKey)) {
            return false;
        }
        String this$headerValue = this.getHeaderValue();
        String other$headerValue = other.getHeaderValue();
        if (this$headerValue == null ? other$headerValue != null : !this$headerValue.equals(other$headerValue)) {
            return false;
        }
        String this$headerLogin = this.getHeaderLogin();
        String other$headerLogin = other.getHeaderLogin();
        if (this$headerLogin == null ? other$headerLogin != null : !this$headerLogin.equals(other$headerLogin)) {
            return false;
        }
        String this$headerLoginValue = this.getHeaderLoginValue();
        String other$headerLoginValue = other.getHeaderLoginValue();
        if (this$headerLoginValue == null ? other$headerLoginValue != null : !this$headerLoginValue.equals(other$headerLoginValue)) {
            return false;
        }
        LoginResponseType this$loginType = this.getLoginType();
        LoginResponseType other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !((Object)((Object)this$loginType)).equals((Object)other$loginType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNoVerify(), other.getNoVerify())) {
            return false;
        }
        String this$usernameParameter = this.getUsernameParameter();
        String other$usernameParameter = other.getUsernameParameter();
        if (this$usernameParameter == null ? other$usernameParameter != null : !this$usernameParameter.equals(other$usernameParameter)) {
            return false;
        }
        String this$passwordParameter = this.getPasswordParameter();
        String other$passwordParameter = other.getPasswordParameter();
        if (this$passwordParameter == null ? other$passwordParameter != null : !this$passwordParameter.equals(other$passwordParameter)) {
            return false;
        }
        String this$defaultUnauthenticatedUrl = this.getDefaultUnauthenticatedUrl();
        String other$defaultUnauthenticatedUrl = other.getDefaultUnauthenticatedUrl();
        if (this$defaultUnauthenticatedUrl == null ? other$defaultUnauthenticatedUrl != null : !this$defaultUnauthenticatedUrl.equals(other$defaultUnauthenticatedUrl)) {
            return false;
        }
        String this$defaultLoginProcessingUrlFrom = this.getDefaultLoginProcessingUrlFrom();
        String other$defaultLoginProcessingUrlFrom = other.getDefaultLoginProcessingUrlFrom();
        if (this$defaultLoginProcessingUrlFrom == null ? other$defaultLoginProcessingUrlFrom != null : !this$defaultLoginProcessingUrlFrom.equals(other$defaultLoginProcessingUrlFrom)) {
            return false;
        }
        String this$defaultLoginOutUrl = this.getDefaultLoginOutUrl();
        String other$defaultLoginOutUrl = other.getDefaultLoginOutUrl();
        if (this$defaultLoginOutUrl == null ? other$defaultLoginOutUrl != null : !this$defaultLoginOutUrl.equals(other$defaultLoginOutUrl)) {
            return false;
        }
        String this$signUpUrl = this.getSignUpUrl();
        String other$signUpUrl = other.getSignUpUrl();
        if (this$signUpUrl == null ? other$signUpUrl != null : !this$signUpUrl.equals(other$signUpUrl)) {
            return false;
        }
        String this$signOutUrl = this.getSignOutUrl();
        String other$signOutUrl = other.getSignOutUrl();
        if (this$signOutUrl == null ? other$signOutUrl != null : !this$signOutUrl.equals(other$signOutUrl)) {
            return false;
        }
        String this$loginPage = this.getLoginPage();
        String other$loginPage = other.getLoginPage();
        if (this$loginPage == null ? other$loginPage != null : !this$loginPage.equals(other$loginPage)) {
            return false;
        }
        if (this.getRememberMeSeconds() != other.getRememberMeSeconds()) {
            return false;
        }
        if (this.getMaximumSessions() != other.getMaximumSessions()) {
            return false;
        }
        if (this.isMaxSessionsPreventsLogin() != other.isMaxSessionsPreventsLogin()) {
            return false;
        }
        String this$sessionInvalidUrl = this.getSessionInvalidUrl();
        String other$sessionInvalidUrl = other.getSessionInvalidUrl();
        if (this$sessionInvalidUrl == null ? other$sessionInvalidUrl != null : !this$sessionInvalidUrl.equals(other$sessionInvalidUrl)) {
            return false;
        }
        SessionProperties this$session = this.getSession();
        SessionProperties other$session = other.getSession();
        if (this$session == null ? other$session != null : !((Object)this$session).equals(other$session)) {
            return false;
        }
        Oauth2Properties this$oauth2 = this.getOauth2();
        Oauth2Properties other$oauth2 = other.getOauth2();
        if (this$oauth2 == null ? other$oauth2 != null : !((Object)this$oauth2).equals(other$oauth2)) {
            return false;
        }
        SmsCodeProperties this$sms = this.getSms();
        SmsCodeProperties other$sms = other.getSms();
        if (this$sms == null ? other$sms != null : !((Object)this$sms).equals(other$sms)) {
            return false;
        }
        String this$encryptKey = this.getEncryptKey();
        String other$encryptKey = other.getEncryptKey();
        return !(this$encryptKey == null ? other$encryptKey != null : !this$encryptKey.equals(other$encryptKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $headerKey = this.getHeaderKey();
        result = result * 59 + ($headerKey == null ? 43 : $headerKey.hashCode());
        String $headerValue = this.getHeaderValue();
        result = result * 59 + ($headerValue == null ? 43 : $headerValue.hashCode());
        String $headerLogin = this.getHeaderLogin();
        result = result * 59 + ($headerLogin == null ? 43 : $headerLogin.hashCode());
        String $headerLoginValue = this.getHeaderLoginValue();
        result = result * 59 + ($headerLoginValue == null ? 43 : $headerLoginValue.hashCode());
        LoginResponseType $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : ((Object)((Object)$loginType)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNoVerify());
        String $usernameParameter = this.getUsernameParameter();
        result = result * 59 + ($usernameParameter == null ? 43 : $usernameParameter.hashCode());
        String $passwordParameter = this.getPasswordParameter();
        result = result * 59 + ($passwordParameter == null ? 43 : $passwordParameter.hashCode());
        String $defaultUnauthenticatedUrl = this.getDefaultUnauthenticatedUrl();
        result = result * 59 + ($defaultUnauthenticatedUrl == null ? 43 : $defaultUnauthenticatedUrl.hashCode());
        String $defaultLoginProcessingUrlFrom = this.getDefaultLoginProcessingUrlFrom();
        result = result * 59 + ($defaultLoginProcessingUrlFrom == null ? 43 : $defaultLoginProcessingUrlFrom.hashCode());
        String $defaultLoginOutUrl = this.getDefaultLoginOutUrl();
        result = result * 59 + ($defaultLoginOutUrl == null ? 43 : $defaultLoginOutUrl.hashCode());
        String $signUpUrl = this.getSignUpUrl();
        result = result * 59 + ($signUpUrl == null ? 43 : $signUpUrl.hashCode());
        String $signOutUrl = this.getSignOutUrl();
        result = result * 59 + ($signOutUrl == null ? 43 : $signOutUrl.hashCode());
        String $loginPage = this.getLoginPage();
        result = result * 59 + ($loginPage == null ? 43 : $loginPage.hashCode());
        result = result * 59 + this.getRememberMeSeconds();
        result = result * 59 + this.getMaximumSessions();
        result = result * 59 + (this.isMaxSessionsPreventsLogin() ? 79 : 97);
        String $sessionInvalidUrl = this.getSessionInvalidUrl();
        result = result * 59 + ($sessionInvalidUrl == null ? 43 : $sessionInvalidUrl.hashCode());
        SessionProperties $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : ((Object)$session).hashCode());
        Oauth2Properties $oauth2 = this.getOauth2();
        result = result * 59 + ($oauth2 == null ? 43 : ((Object)$oauth2).hashCode());
        SmsCodeProperties $sms = this.getSms();
        result = result * 59 + ($sms == null ? 43 : ((Object)$sms).hashCode());
        String $encryptKey = this.getEncryptKey();
        result = result * 59 + ($encryptKey == null ? 43 : $encryptKey.hashCode());
        return result;
    }

    public String toString() {
        return "SecurityProperties(enabled=" + this.getEnabled() + ", headerKey=" + this.getHeaderKey() + ", headerValue=" + this.getHeaderValue() + ", headerLogin=" + this.getHeaderLogin() + ", headerLoginValue=" + this.getHeaderLoginValue() + ", loginType=" + (Object)((Object)this.getLoginType()) + ", noVerify=" + Arrays.deepToString(this.getNoVerify()) + ", usernameParameter=" + this.getUsernameParameter() + ", passwordParameter=" + this.getPasswordParameter() + ", defaultUnauthenticatedUrl=" + this.getDefaultUnauthenticatedUrl() + ", defaultLoginProcessingUrlFrom=" + this.getDefaultLoginProcessingUrlFrom() + ", defaultLoginOutUrl=" + this.getDefaultLoginOutUrl() + ", signUpUrl=" + this.getSignUpUrl() + ", signOutUrl=" + this.getSignOutUrl() + ", loginPage=" + this.getLoginPage() + ", rememberMeSeconds=" + this.getRememberMeSeconds() + ", maximumSessions=" + this.getMaximumSessions() + ", maxSessionsPreventsLogin=" + this.isMaxSessionsPreventsLogin() + ", sessionInvalidUrl=" + this.getSessionInvalidUrl() + ", session=" + this.getSession() + ", oauth2=" + this.getOauth2() + ", sms=" + this.getSms() + ", encryptKey=" + this.getEncryptKey() + ")";
    }

    public SecurityProperties() {
    }

    public SecurityProperties(Boolean enabled, String headerKey, String headerValue, String headerLogin, String headerLoginValue, LoginResponseType loginType, String[] noVerify, String usernameParameter, String passwordParameter, String defaultUnauthenticatedUrl, String defaultLoginProcessingUrlFrom, String defaultLoginOutUrl, String signUpUrl, String signOutUrl, String loginPage, int rememberMeSeconds, int maximumSessions, boolean maxSessionsPreventsLogin, String sessionInvalidUrl, SessionProperties session, Oauth2Properties oauth2, SmsCodeProperties sms, String encryptKey) {
        this.enabled = enabled;
        this.headerKey = headerKey;
        this.headerValue = headerValue;
        this.headerLogin = headerLogin;
        this.headerLoginValue = headerLoginValue;
        this.loginType = loginType;
        this.noVerify = noVerify;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.defaultUnauthenticatedUrl = defaultUnauthenticatedUrl;
        this.defaultLoginProcessingUrlFrom = defaultLoginProcessingUrlFrom;
        this.defaultLoginOutUrl = defaultLoginOutUrl;
        this.signUpUrl = signUpUrl;
        this.signOutUrl = signOutUrl;
        this.loginPage = loginPage;
        this.rememberMeSeconds = rememberMeSeconds;
        this.maximumSessions = maximumSessions;
        this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
        this.sessionInvalidUrl = sessionInvalidUrl;
        this.session = session;
        this.oauth2 = oauth2;
        this.sms = sms;
        this.encryptKey = encryptKey;
    }

    public static class SecurityPropertiesBuilder {
        private Boolean enabled;
        private String headerKey;
        private String headerValue;
        private String headerLogin;
        private String headerLoginValue;
        private LoginResponseType loginType;
        private String[] noVerify;
        private String usernameParameter;
        private String passwordParameter;
        private String defaultUnauthenticatedUrl;
        private String defaultLoginProcessingUrlFrom;
        private String defaultLoginOutUrl;
        private String signUpUrl;
        private String signOutUrl;
        private String loginPage;
        private int rememberMeSeconds;
        private int maximumSessions;
        private boolean maxSessionsPreventsLogin;
        private String sessionInvalidUrl;
        private SessionProperties session;
        private Oauth2Properties oauth2;
        private SmsCodeProperties sms;
        private String encryptKey;

        SecurityPropertiesBuilder() {
        }

        public SecurityPropertiesBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SecurityPropertiesBuilder headerKey(String headerKey) {
            this.headerKey = headerKey;
            return this;
        }

        public SecurityPropertiesBuilder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public SecurityPropertiesBuilder headerLogin(String headerLogin) {
            this.headerLogin = headerLogin;
            return this;
        }

        public SecurityPropertiesBuilder headerLoginValue(String headerLoginValue) {
            this.headerLoginValue = headerLoginValue;
            return this;
        }

        public SecurityPropertiesBuilder loginType(LoginResponseType loginType) {
            this.loginType = loginType;
            return this;
        }

        public SecurityPropertiesBuilder noVerify(String[] noVerify) {
            this.noVerify = noVerify;
            return this;
        }

        public SecurityPropertiesBuilder usernameParameter(String usernameParameter) {
            this.usernameParameter = usernameParameter;
            return this;
        }

        public SecurityPropertiesBuilder passwordParameter(String passwordParameter) {
            this.passwordParameter = passwordParameter;
            return this;
        }

        public SecurityPropertiesBuilder defaultUnauthenticatedUrl(String defaultUnauthenticatedUrl) {
            this.defaultUnauthenticatedUrl = defaultUnauthenticatedUrl;
            return this;
        }

        public SecurityPropertiesBuilder defaultLoginProcessingUrlFrom(String defaultLoginProcessingUrlFrom) {
            this.defaultLoginProcessingUrlFrom = defaultLoginProcessingUrlFrom;
            return this;
        }

        public SecurityPropertiesBuilder defaultLoginOutUrl(String defaultLoginOutUrl) {
            this.defaultLoginOutUrl = defaultLoginOutUrl;
            return this;
        }

        public SecurityPropertiesBuilder signUpUrl(String signUpUrl) {
            this.signUpUrl = signUpUrl;
            return this;
        }

        public SecurityPropertiesBuilder signOutUrl(String signOutUrl) {
            this.signOutUrl = signOutUrl;
            return this;
        }

        public SecurityPropertiesBuilder loginPage(String loginPage) {
            this.loginPage = loginPage;
            return this;
        }

        public SecurityPropertiesBuilder rememberMeSeconds(int rememberMeSeconds) {
            this.rememberMeSeconds = rememberMeSeconds;
            return this;
        }

        public SecurityPropertiesBuilder maximumSessions(int maximumSessions) {
            this.maximumSessions = maximumSessions;
            return this;
        }

        public SecurityPropertiesBuilder maxSessionsPreventsLogin(boolean maxSessionsPreventsLogin) {
            this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
            return this;
        }

        public SecurityPropertiesBuilder sessionInvalidUrl(String sessionInvalidUrl) {
            this.sessionInvalidUrl = sessionInvalidUrl;
            return this;
        }

        public SecurityPropertiesBuilder session(SessionProperties session) {
            this.session = session;
            return this;
        }

        public SecurityPropertiesBuilder oauth2(Oauth2Properties oauth2) {
            this.oauth2 = oauth2;
            return this;
        }

        public SecurityPropertiesBuilder sms(SmsCodeProperties sms) {
            this.sms = sms;
            return this;
        }

        public SecurityPropertiesBuilder encryptKey(String encryptKey) {
            this.encryptKey = encryptKey;
            return this;
        }

        public SecurityProperties build() {
            return new SecurityProperties(this.enabled, this.headerKey, this.headerValue, this.headerLogin, this.headerLoginValue, this.loginType, this.noVerify, this.usernameParameter, this.passwordParameter, this.defaultUnauthenticatedUrl, this.defaultLoginProcessingUrlFrom, this.defaultLoginOutUrl, this.signUpUrl, this.signOutUrl, this.loginPage, this.rememberMeSeconds, this.maximumSessions, this.maxSessionsPreventsLogin, this.sessionInvalidUrl, this.session, this.oauth2, this.sms, this.encryptKey);
        }

        public String toString() {
            return "SecurityProperties.SecurityPropertiesBuilder(enabled=" + this.enabled + ", headerKey=" + this.headerKey + ", headerValue=" + this.headerValue + ", headerLogin=" + this.headerLogin + ", headerLoginValue=" + this.headerLoginValue + ", loginType=" + (Object)((Object)this.loginType) + ", noVerify=" + Arrays.deepToString(this.noVerify) + ", usernameParameter=" + this.usernameParameter + ", passwordParameter=" + this.passwordParameter + ", defaultUnauthenticatedUrl=" + this.defaultUnauthenticatedUrl + ", defaultLoginProcessingUrlFrom=" + this.defaultLoginProcessingUrlFrom + ", defaultLoginOutUrl=" + this.defaultLoginOutUrl + ", signUpUrl=" + this.signUpUrl + ", signOutUrl=" + this.signOutUrl + ", loginPage=" + this.loginPage + ", rememberMeSeconds=" + this.rememberMeSeconds + ", maximumSessions=" + this.maximumSessions + ", maxSessionsPreventsLogin=" + this.maxSessionsPreventsLogin + ", sessionInvalidUrl=" + this.sessionInvalidUrl + ", session=" + this.session + ", oauth2=" + this.oauth2 + ", sms=" + this.sms + ", encryptKey=" + this.encryptKey + ")";
        }
    }
}

