/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.properties.app;

public class Oauth2ClientProperties {
    private String clientId;
    private String clientIdSecret;
    private int accessTokenValiditySeconds = 86400;
    private int refreshTokenValiditySeconds = 2592000;

    public static Oauth2ClientPropertiesBuilder builder() {
        return new Oauth2ClientPropertiesBuilder();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientIdSecret() {
        return this.clientIdSecret;
    }

    public int getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public int getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientIdSecret(String clientIdSecret) {
        this.clientIdSecret = clientIdSecret;
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Oauth2ClientProperties)) {
            return false;
        }
        Oauth2ClientProperties other = (Oauth2ClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientIdSecret = this.getClientIdSecret();
        String other$clientIdSecret = other.getClientIdSecret();
        if (this$clientIdSecret == null ? other$clientIdSecret != null : !this$clientIdSecret.equals(other$clientIdSecret)) {
            return false;
        }
        if (this.getAccessTokenValiditySeconds() != other.getAccessTokenValiditySeconds()) {
            return false;
        }
        return this.getRefreshTokenValiditySeconds() == other.getRefreshTokenValiditySeconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Oauth2ClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientIdSecret = this.getClientIdSecret();
        result = result * 59 + ($clientIdSecret == null ? 43 : $clientIdSecret.hashCode());
        result = result * 59 + this.getAccessTokenValiditySeconds();
        result = result * 59 + this.getRefreshTokenValiditySeconds();
        return result;
    }

    public String toString() {
        return "Oauth2ClientProperties(clientId=" + this.getClientId() + ", clientIdSecret=" + this.getClientIdSecret() + ", accessTokenValiditySeconds=" + this.getAccessTokenValiditySeconds() + ", refreshTokenValiditySeconds=" + this.getRefreshTokenValiditySeconds() + ")";
    }

    public Oauth2ClientProperties() {
    }

    public Oauth2ClientProperties(String clientId, String clientIdSecret, int accessTokenValiditySeconds, int refreshTokenValiditySeconds) {
        this.clientId = clientId;
        this.clientIdSecret = clientIdSecret;
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public static class Oauth2ClientPropertiesBuilder {
        private String clientId;
        private String clientIdSecret;
        private int accessTokenValiditySeconds;
        private int refreshTokenValiditySeconds;

        Oauth2ClientPropertiesBuilder() {
        }

        public Oauth2ClientPropertiesBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Oauth2ClientPropertiesBuilder clientIdSecret(String clientIdSecret) {
            this.clientIdSecret = clientIdSecret;
            return this;
        }

        public Oauth2ClientPropertiesBuilder accessTokenValiditySeconds(int accessTokenValiditySeconds) {
            this.accessTokenValiditySeconds = accessTokenValiditySeconds;
            return this;
        }

        public Oauth2ClientPropertiesBuilder refreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
            this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
            return this;
        }

        public Oauth2ClientProperties build() {
            return new Oauth2ClientProperties(this.clientId, this.clientIdSecret, this.accessTokenValiditySeconds, this.refreshTokenValiditySeconds);
        }

        public String toString() {
            return "Oauth2ClientProperties.Oauth2ClientPropertiesBuilder(clientId=" + this.clientId + ", clientIdSecret=" + this.clientIdSecret + ", accessTokenValiditySeconds=" + this.accessTokenValiditySeconds + ", refreshTokenValiditySeconds=" + this.refreshTokenValiditySeconds + ")";
        }
    }
}

