/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.surpassm.common.jackson.Result;
import com.github.surpassm.common.jackson.ResultCode;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class AbstractSessionStrategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String destinationUrl;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean createNewSession = true;
    private ObjectMapper objectMapper = new ObjectMapper();

    public AbstractSessionStrategy(String invalidSessionUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)invalidSessionUrl), (String)"url must start with '/' or with 'http(s)'");
        this.destinationUrl = invalidSessionUrl;
    }

    protected void onSessionInvalid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String html;
        String sourceUrl;
        if (this.createNewSession) {
            request.getSession();
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)(sourceUrl = request.getRequestURI()), (CharSequence)(html = ".html"))) {
            String targetUrl = this.destinationUrl + ".html";
            this.logger.info("session\u5931\u6548,\u8df3\u8f6c\u5230" + targetUrl);
            this.redirectStrategy.sendRedirect(request, response, targetUrl);
        } else {
            String message = "\u4f1a\u8bdd\u5df2\u5931\u6548";
            if (this.isConcurrency()) {
                message = message + "\uff0c\u6709\u53ef\u80fd\u662f\u5e76\u53d1\u767b\u5f55\u5bfc\u81f4\u7684";
            }
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(this.objectMapper.writeValueAsString((Object)new Result(HttpStatus.FORBIDDEN.value(), ResultCode.USER_SESSION_ERROR.getMsg())));
        }
    }

    protected boolean isConcurrency() {
        return false;
    }

    public void setCreateNewSession(boolean createNewSession) {
        this.createNewSession = createNewSession;
    }
}

