/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenUtils
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenUtils.class);
    private static final String AUTHORITIES_KEY = "userId";
    private static final String SECRET_KEY = "surpassm";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.HS256;
    private static final long EXPIRATION = 3600L;
    private static final long EXPIRATION_REMEMBER = 604800L;

    public static String createToken(String userId, boolean isRememberMe) {
        long expiration = isRememberMe ? 604800L : 3600L;
        return Jwts.builder().setSubject(userId).claim(AUTHORITIES_KEY, (Object)userId).setExpiration(new Date(System.currentTimeMillis() + expiration * 1000L)).signWith(SignatureAlgorithm.HS512, SECRET_KEY).compact();
    }

    public static String getUsernameFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(SECRET_KEY).parseClaimsJws(token).getBody();
        return claims.get((Object)AUTHORITIES_KEY).toString();
    }

    public static boolean validateToken(String token) {
        try {
            Jwts.parser().setSigningKey(SECRET_KEY).parseClaimsJws(token);
            return true;
        }
        catch (MalformedJwtException e) {
            log.info("Invalid JWT token.");
            log.trace("Invalid JWT token trace: {}", (Throwable)e);
        }
        catch (ExpiredJwtException e) {
            log.info("Expired JWT token.");
            log.trace("Expired JWT token trace: {}", (Throwable)e);
        }
        catch (UnsupportedJwtException e) {
            log.info("Unsupported JWT token.");
            log.trace("Unsupported JWT token trace: {}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.info("JWT token compact of handler are invalid.");
            log.trace("JWT token compact of handler are invalid trace: {}", (Throwable)e);
        }
        return false;
    }

    public static String generateAccessToken(String subject, Map<String, Object> claims, Integer expiration) {
        return JwtTokenUtils.generateToken(subject, claims, expiration.intValue());
    }

    private static String generateToken(String subject, Map<String, Object> claims, long expiration) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setId(UUID.randomUUID().toString()).setIssuedAt(new Date()).setExpiration(JwtTokenUtils.generateExpirationDate(expiration)).signWith(SIGNATURE_ALGORITHM, SECRET_KEY).compact();
    }

    private static Date generateExpirationDate(long expiration) {
        return new Date(System.currentTimeMillis() + expiration);
    }

    public Date getCreatedDateFromToken(String token) {
        Date created;
        try {
            Claims claims = JwtTokenUtils.getClaimsFromToken(token);
            created = claims.getIssuedAt();
        }
        catch (Exception e) {
            created = null;
        }
        return created;
    }

    private Boolean isTokenExpired(String token) {
        Date expiration = this.getExpirationDateFromToken(token);
        return expiration.before(new Date());
    }

    public Date getExpirationDateFromToken(String token) {
        Date expiration;
        try {
            Claims claims = JwtTokenUtils.getClaimsFromToken(token);
            expiration = claims.getExpiration();
        }
        catch (Exception e) {
            expiration = null;
        }
        return expiration;
    }

    public String restTokenExpired(String token, long expiration) {
        Claims claims = JwtTokenUtils.getClaimsFromToken(token);
        Jwts.builder().setClaims(claims).setSubject(claims.getSubject()).setExpiration(new Date(expiration));
        return "";
    }

    public static Claims getClaimsFromToken(String token) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(SECRET_KEY).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
            System.out.println(e);
        }
        return claims;
    }
}

