/*
 * Decompiled with CFR 0.152.
 */
package edu.nju.analyzer;

import edu.nju.util.FileUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;

public class Project {
    static final boolean DEFAULT_RESOLVE_BINDING = true;
    static final boolean DEFAULT_BINDING_RECOVERY = true;
    static final boolean DEFAULT_INCLUDE_VM_BOOT_CLASSPATH = true;
    static final String DEFAUTLT_ENCODING = "UTF-8";
    private List<String> sourcePaths;
    private List<String> encodings;
    private List<String> classPaths;
    private boolean resolveBinding;
    private boolean bindingRecovery;
    private boolean includeVMBootClassPath;
    private Map<String, CompilationUnit> filePath_CompilationUnit_Map = new HashMap<String, CompilationUnit>();
    private Map<String, AbstractTypeDeclaration> qualifiedMame_Type_Map = new HashMap<String, AbstractTypeDeclaration>();
    private List<String> globalIssues = new ArrayList<String>();
    private Map<String, List<Issue>> issuesMap = new HashMap<String, List<Issue>>();

    private ASTParser newASTParser() {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(this.resolveBinding);
        parser.setBindingsRecovery(this.bindingRecovery);
        parser.setEnvironment(this.classPaths.toArray(new String[0]), this.sourcePaths.toArray(new String[0]), this.encodings.toArray(new String[0]), this.includeVMBootClassPath);
        parser.setKind(8);
        parser.setCompilerOptions((Map)JavaCore.getOptions());
        return parser;
    }

    Project(List<String> sourcePaths, List<String> encodings, List<String> classPaths, boolean resolveBinding, boolean bindingRecovery, boolean includeVMBootClassPath) {
        this.sourcePaths = sourcePaths;
        this.encodings = encodings;
        this.classPaths = classPaths;
        this.resolveBinding = resolveBinding;
        this.bindingRecovery = bindingRecovery;
        this.includeVMBootClassPath = includeVMBootClassPath;
        for (String sourcePath : sourcePaths) {
            List<File> javaFiles = FileUtil.findJavaFiles(sourcePath);
            for (File javaFile : javaFiles) {
                ASTParser parser = this.newASTParser();
                String filePath = javaFile.getPath();
                int index = sourcePaths.indexOf(sourcePath);
                String encoding = encodings.get(index);
                String source = FileUtil.read(javaFile, encoding);
                parser.setSource(source.toCharArray());
                parser.setUnitName(filePath);
                CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
                this.filePath_CompilationUnit_Map.put(filePath, compilationUnit);
                compilationUnit.accept(new ASTVisitor(){

                    public boolean visit(EnumDeclaration node) {
                        Project.this.addAnnotationTypeDeclaration((AbstractTypeDeclaration)node);
                        return super.visit(node);
                    }

                    public boolean visit(AnnotationTypeDeclaration node) {
                        Project.this.addAnnotationTypeDeclaration((AbstractTypeDeclaration)node);
                        return super.visit(node);
                    }

                    public boolean visit(TypeDeclaration node) {
                        Project.this.addAnnotationTypeDeclaration((AbstractTypeDeclaration)node);
                        return super.visit(node);
                    }
                });
            }
        }
    }

    private void addAnnotationTypeDeclaration(AbstractTypeDeclaration node) {
        ITypeBinding classTypeBinding = node.resolveBinding();
        String qualifiedName = classTypeBinding.getQualifiedName();
        this.qualifiedMame_Type_Map.put(qualifiedName, node);
    }

    public List<EnumDeclaration> getEnumDeclarations() {
        return this.qualifiedMame_Type_Map.values().stream().filter(type -> type instanceof EnumDeclaration).map(type -> (EnumDeclaration)type).collect(Collectors.toList());
    }

    public List<AnnotationTypeDeclaration> getAnnotationTypeDeclarations() {
        return this.qualifiedMame_Type_Map.values().stream().filter(type -> type instanceof AnnotationTypeDeclaration).map(type -> (AnnotationTypeDeclaration)type).collect(Collectors.toList());
    }

    public List<TypeDeclaration> getClassDeclarations() {
        return this.qualifiedMame_Type_Map.values().stream().filter(type -> type instanceof TypeDeclaration).map(type -> (TypeDeclaration)type).filter(type -> !type.isInterface()).collect(Collectors.toList());
    }

    public List<TypeDeclaration> getInterfaceDeclarations() {
        return this.qualifiedMame_Type_Map.values().stream().filter(type -> type instanceof TypeDeclaration).map(type -> (TypeDeclaration)type).filter(type -> type.isInterface()).collect(Collectors.toList());
    }

    public CompilationUnit findCompilationUnitByFileName(String fileName) {
        Optional<String> path = this.filePath_CompilationUnit_Map.keySet().stream().filter(filePath -> filePath.endsWith(fileName)).findFirst();
        return path.isPresent() ? this.filePath_CompilationUnit_Map.get(path.get()) : null;
    }

    public TypeDeclaration findClassDelarationByQualifiedName(String qualifiedName) {
        return (TypeDeclaration)this.qualifiedMame_Type_Map.get(qualifiedName);
    }

    public TypeDeclaration findInterfaceDelarationByQualifiedName(String qualifiedName) {
        return (TypeDeclaration)this.qualifiedMame_Type_Map.get(qualifiedName);
    }

    public EnumDeclaration findEnumDeclarationByQualifiedName(String qualifiedName) {
        return (EnumDeclaration)this.qualifiedMame_Type_Map.get(qualifiedName);
    }

    public AnnotationTypeDeclaration findAnnotationTypeDeclarationByQualifiedName(String qualifiedName) {
        return (AnnotationTypeDeclaration)this.qualifiedMame_Type_Map.get(qualifiedName);
    }

    public List<VariableDeclaration> getFieldsIn(String typeQualifiedName) {
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.qualifiedMame_Type_Map.get(typeQualifiedName);
        FieldDeclaration[] fieldDeclarations = typeDeclaration.getFields();
        return Arrays.asList(fieldDeclarations).stream().flatMap(fieldDeclaration -> fieldDeclaration.fragments().stream()).collect(Collectors.toList());
    }

    public List<MethodDeclaration> getMethodsIn(String typeQualifiedName) {
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.qualifiedMame_Type_Map.get(typeQualifiedName);
        return Arrays.asList(typeDeclaration.getMethods());
    }

    public VariableDeclaration findFieldByName(String typeQualifiedName, String variableName) {
        Optional<VariableDeclaration> field = this.getFieldsIn(typeQualifiedName).stream().filter(variableDEclaration -> variableDEclaration.getName().toString().equals(variableName)).findFirst();
        return field.isPresent() ? field.get() : null;
    }

    public MethodDeclaration findMethodByName(String typeQualifiedName, String methodName) {
        Optional<MethodDeclaration> method = this.getMethodsIn(typeQualifiedName).stream().filter(methodDeclaration -> methodDeclaration.getName().toString().equals(methodName)).findFirst();
        return method.isPresent() ? method.get() : null;
    }

    public List<MethodDeclaration> findMethodsByName(String typeQualifiedName, String methodName) {
        List<MethodDeclaration> methods = this.getMethodsIn(typeQualifiedName).stream().filter(methodDeclaration -> methodDeclaration.getName().toString().equals(methodName)).collect(Collectors.toList());
        return methods;
    }

    public List<MethodDeclaration> getConstructorsOf(String typeQualifiedName) {
        List<MethodDeclaration> constructors = this.getMethodsIn(typeQualifiedName).stream().filter(methodDeclaration -> methodDeclaration.isConstructor()).collect(Collectors.toList());
        return constructors;
    }

    public void reportGlobalIssue(String message) {
        this.globalIssues.add(message);
    }

    public void reportIssue(String filePath, CompilationUnit compilationUnit, ASTNode node, String message) {
        List<Issue> list = this.issuesMap.get(filePath);
        if (list == null) {
            list = new ArrayList<Issue>();
            this.issuesMap.put(filePath, list);
        }
        node.getStartPosition();
        int lineNumber = compilationUnit.getLineNumber(node.getStartPosition());
        int startPosition = node.getStartPosition();
        int length = node.getLength();
        Issue issue = new Issue(lineNumber, startPosition, length, message);
        list.add(issue);
    }

    public void generateIssueReport(String reportDirPath, String reportFileName) {
        Configuration config = new Configuration(Configuration.VERSION_2_3_23);
        try {
            File file;
            File reportDir;
            InputStream inputStream = Project.class.getClassLoader().getResourceAsStream("template/issue_report.ftl");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String content = "";
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                content = content + line + System.getProperty("line.separator");
            }
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            stringLoader.putTemplate("issue_report.ftl", content);
            config.setTemplateLoader((TemplateLoader)stringLoader);
            config.setDefaultEncoding(DEFAUTLT_ENCODING);
            config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            config.setLogTemplateExceptions(true);
            if (!reportFileName.endsWith(".html") && !reportFileName.endsWith(".htm")) {
                reportFileName = reportFileName + ".html";
            }
            if (!(reportDir = new File(reportDirPath)).exists()) {
                reportDir.mkdirs();
            }
            if ((file = new File(FileUtil.jointPath(reportDirPath, reportFileName))).exists()) {
                file.delete();
            }
            file.createNewFile();
            Template template = config.getTemplate("issue_report.ftl");
            FileWriter out = new FileWriter(file);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("issuesMap", this.issuesMap);
            data.put("globalIssues", this.globalIssues);
            template.process(data, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getSourcePaths() {
        return this.sourcePaths;
    }

    public List<String> getEncodings() {
        return this.encodings;
    }

    public List<String> getClassPaths() {
        return this.classPaths;
    }

    public boolean isResolveBinding() {
        return this.resolveBinding;
    }

    public boolean isBindingRecovery() {
        return this.bindingRecovery;
    }

    public boolean isIncludeVMBootClassPath() {
        return this.includeVMBootClassPath;
    }

    public class Issue {
        private int lineNumber;
        private int startPosition;
        private int length;
        private String message;

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getLength() {
            return this.length;
        }

        public String getMessage() {
            return this.message;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public void setStartPosition(int startPosition) {
            this.startPosition = startPosition;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @ConstructorProperties(value={"lineNumber", "startPosition", "length", "message"})
        public Issue(int lineNumber, int startPosition, int length, String message) {
            this.lineNumber = lineNumber;
            this.startPosition = startPosition;
            this.length = length;
            this.message = message;
        }
    }
}

