/*
 * Decompiled with CFR 0.152.
 */
package edu.nju.analyzer;

import edu.nju.analyzer.Project;
import java.util.ArrayList;
import java.util.List;

public class ProjectBuilder {
    private List<String> sourcePaths = new ArrayList<String>();
    private List<String> encodings = new ArrayList<String>();
    private List<String> classPaths = new ArrayList<String>();
    private boolean resolveBinding = true;
    private boolean bindingRecovery = true;
    private boolean includeVMBootClassPath = true;

    public ProjectBuilder addSourcePath(String sourcePath) {
        return this.addSourcePath(sourcePath, "UTF-8");
    }

    public ProjectBuilder addSourcePath(String sourcePath, String encoding) {
        this.sourcePaths.add(sourcePath);
        this.encodings.add(encoding);
        return this;
    }

    public ProjectBuilder addClassPath(String classPath) {
        this.classPaths.add(classPath);
        return this;
    }

    public ProjectBuilder disableResolveBinding() {
        this.resolveBinding = false;
        return this;
    }

    public ProjectBuilder disableBindingRecovery() {
        this.bindingRecovery = false;
        return this;
    }

    public ProjectBuilder disableIncludeVMBootClassPath() {
        this.includeVMBootClassPath = false;
        return this;
    }

    public Project build() {
        return new Project(this.sourcePaths, this.encodings, this.classPaths, this.resolveBinding, this.bindingRecovery, this.includeVMBootClassPath);
    }
}

