/*
 * Decompiled with CFR 0.152.
 */
package edu.nju.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static String uniformPathSeparator(String path) {
        String[] separators;
        String result = path;
        for (String separator : separators = new String[]{"\\", "//", "/"}) {
            if (File.separator.equals(separator)) continue;
            result = result.replace(separator, File.separator);
        }
        return result;
    }

    public static String jointPath(String ... parts) {
        String path = "";
        for (String part : parts) {
            String toJoint = FileUtil.uniformPathSeparator(part);
            if (toJoint.startsWith(File.separator)) {
                toJoint = toJoint.substring(1, toJoint.length());
            }
            if (!path.endsWith(File.separator) && !path.trim().equals("")) {
                path = path + File.separator;
            }
            path = path + toJoint;
        }
        return path;
    }

    public static String read(String filePath) {
        File file = new File(filePath);
        return FileUtil.read(file);
    }

    public static String read(String filePath, String encoding) {
        File file = new File(filePath);
        return FileUtil.read(file, encoding);
    }

    public static String read(File file) {
        return FileUtil.read(file, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file, String encoding) {
        String content = "";
        BufferedReader bufferedReader = null;
        try {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                content = content + line;
                content = content + System.getProperty("line.separator");
            }
        }
        catch (Exception e) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return content;
    }

    public static List<File> findJavaFiles(String srcDirPath) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.findJavaFilesInDir(srcDirPath, result);
        return result;
    }

    private static void findJavaFilesInDir(String srcDirPath, List<File> result) {
        File file = new File(srcDirPath);
        if (file.exists()) {
            File[] files;
            for (File file2 : files = file.listFiles()) {
                if (file2.isDirectory()) {
                    FileUtil.findJavaFilesInDir(file2.getAbsolutePath(), result);
                    continue;
                }
                String fileName = file2.getName();
                if (!fileName.endsWith(".java")) continue;
                result.add(file2);
            }
        }
    }
}

