
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class BaseFancyList<S extends Object, T extends Object> {
    private final BaseFancyListAcceptor<S, T> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static BaseFancyList BASENIL = new BaseFancyList(new BaseNilCaseBaseFancyListAcceptor());
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static BaseFancyListFactory FACTORY = new BaseFancyListFactory();

    private BaseFancyList(BaseFancyListAcceptor<S, T> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected BaseFancyList(
        @Nonnull
        BaseFancyList<S, T> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.BaseFancyList");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<S extends Object, T extends Object> BaseFancyList<S, T> baseList(
        @Nonnull
        T head,
        @Nonnull
        S tail) {
        if (head == null) {
            throw new NullPointerException("Argument shouldn't be null: 'head' argument in static method invocation: 'baseList' in class com.github.sviperll.adt4j.examples.BaseFancyList");
        }
        if (tail == null) {
            throw new NullPointerException("Argument shouldn't be null: 'tail' argument in static method invocation: 'baseList' in class com.github.sviperll.adt4j.examples.BaseFancyList");
        }
        return new BaseFancyList<S, T>(new BaseListCaseBaseFancyListAcceptor<S, T>(head, tail));
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<S extends Object, T extends Object> BaseFancyList<S, T> baseNil() {
        return BASENIL;
    }

    final<R extends Object> R match(BaseFancyListCases<S, T, R> visitor) {
        return acceptor.match(visitor);
    }

    @Nonnull
    protected final BaseFancyList<S, T> withHead(
        @Nonnull
        T newValue) {
        return this.acceptor.withHead(newValue);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof BaseFancyList)) {
                return false;
            } else {
                BaseFancyList<?, ?> that = ((BaseFancyList<?, ?> ) thatObject);
                return this.acceptor.baseFancyListEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.baseFancyListHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<S extends Object, T extends Object> BaseFancyListCases<S, T, BaseFancyList<S, T>> factory() {
        return FACTORY;
    }

    private interface BaseFancyListAcceptor<S extends Object, T extends Object> {

        public<R extends Object> R match(BaseFancyListCases<S, T, R> visitor);

        @Nonnull
        public BaseFancyList<S, T> withHead(
            @Nonnull
            T newValue);

        public boolean baseFancyListEquals(BaseFancyListAcceptor<?, ?> thatAcceptor);

        public boolean baseFancyListEqualsBaseList(Object head, Object tail);

        public boolean baseFancyListEqualsBaseNil();

        public int baseFancyListHashCode();
    }

    private static class BaseFancyListFactory<S extends Object, T extends Object>
        implements BaseFancyListCases<S, T, BaseFancyList<S, T>>
    {

        @Nonnull
        @Override
        public BaseFancyList<S, T> baseList(T head, S tail) {
            return BaseFancyList.<S, T> baseList(head, tail);
        }

        @Nonnull
        @Override
        public BaseFancyList<S, T> baseNil() {
            return BaseFancyList.<S, T> baseNil();
        }
    }

    private static class BaseListCaseBaseFancyListAcceptor<S extends Object, T extends Object>
        implements BaseFancyListAcceptor<S, T>
    {
        private final T head;
        private final S tail;

        BaseListCaseBaseFancyListAcceptor(T head, S tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public<R extends Object> R match(BaseFancyListCases<S, T, R> visitor) {
            return visitor.baseList(this.head, this.tail);
        }

        @Nonnull
        @Override
        public final BaseFancyList<S, T> withHead(
            @Nonnull
            T newValue) {
            return BaseFancyList.<S, T> baseList(newValue, this.tail);
        }

        @Override
        public final boolean baseFancyListEquals(BaseFancyListAcceptor<?, ?> thatAcceptor) {
            return thatAcceptor.baseFancyListEqualsBaseList(this.head, this.tail);
        }

        @Override
        public boolean baseFancyListEqualsBaseList(Object head, Object tail) {
            if (!head.equals(this.head)) {
                return false;
            }
            return tail.equals(this.tail);
        }

        @Override
        public boolean baseFancyListEqualsBaseNil() {
            return false;
        }

        @Override
        public final int baseFancyListHashCode() {
            int result = 1;
            result = ((result* 37)+ this.head.hashCode());
            result = ((result* 37)+ this.tail.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("BaseFancyList.BaseList{");
            result.append("head = ");
            result.append(this.head);
            result.append(", ");
            result.append("tail = ");
            result.append(this.tail);
            result.append("}");
            return result.toString();
        }
    }

    private static class BaseNilCaseBaseFancyListAcceptor<S extends Object, T extends Object>
        implements BaseFancyListAcceptor<S, T>
    {

        BaseNilCaseBaseFancyListAcceptor() {
        }

        @Override
        public<R extends Object> R match(BaseFancyListCases<S, T, R> visitor) {
            return visitor.baseNil();
        }

        @Nonnull
        @Override
        public final BaseFancyList<S, T> withHead(
            @Nonnull
            T newValue) {
            return BaseFancyList.<S, T> baseNil();
        }

        @Override
        public boolean baseFancyListEqualsBaseList(Object head, Object tail) {
            return false;
        }

        @Override
        public final boolean baseFancyListEquals(BaseFancyListAcceptor<?, ?> thatAcceptor) {
            return thatAcceptor.baseFancyListEqualsBaseNil();
        }

        @Override
        public boolean baseFancyListEqualsBaseNil() {
            return true;
        }

        @Override
        public final int baseFancyListHashCode() {
            int result = 2;
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("BaseFancyList.BaseNil{");
            result.append("}");
            return result.toString();
        }
    }
}
