
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class BaseOptional<T extends Object>
    extends BaseOptionalSupport<T>
{
    private final BaseOptionalAcceptor<T> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static BaseOptional MISSING = new BaseOptional(new MissingCaseBaseOptionalAcceptor());
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static BaseOptionalFactory FACTORY = new BaseOptionalFactory();

    private BaseOptional(BaseOptionalAcceptor<T> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected BaseOptional(
        @Nonnull
        BaseOptional<T> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.BaseOptional");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<T extends Object> BaseOptional<T> missing() {
        return MISSING;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<T extends Object> BaseOptional<T> present(
        @Nonnull
        T value) {
        if (value == null) {
            throw new NullPointerException("Argument shouldn't be null: 'value' argument in static method invocation: 'present' in class com.github.sviperll.adt4j.examples.BaseOptional");
        }
        return new BaseOptional<T>(new PresentCaseBaseOptionalAcceptor<T>(value));
    }

    public final<R extends Object, E extends Exception> R accept(BaseOptionalVisitor<T, R, E> visitor)
        throws E
    {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final T getValue() {
        return this.acceptor.getValue();
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof BaseOptional)) {
                return false;
            } else {
                BaseOptional<?> that = ((BaseOptional<?> ) thatObject);
                return this.acceptor.baseOptionalEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.baseOptionalHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<T extends Object> BaseOptionalVisitor<T, BaseOptional<T> , RuntimeException> factory() {
        return FACTORY;
    }

    private interface BaseOptionalAcceptor<T extends Object> {

        public<R extends Object, E extends Exception> R accept(BaseOptionalVisitor<T, R, E> visitor)
            throws E
        ;

        @Nonnull
        public T getValue();

        public boolean baseOptionalEquals(BaseOptionalAcceptor<?> thatAcceptor);

        public boolean baseOptionalEqualsMissing();

        public boolean baseOptionalEqualsPresent(Object value);

        public int baseOptionalHashCode();
    }

    private static class BaseOptionalFactory<T extends Object>
        implements BaseOptionalVisitor<T, BaseOptional<T> , RuntimeException>
    {

        @Nonnull
        @Override
        public BaseOptional<T> missing() {
            return BaseOptional.<T> missing();
        }

        @Nonnull
        @Override
        public BaseOptional<T> present(T value) {
            return BaseOptional.<T> present(value);
        }
    }

    private static class MissingCaseBaseOptionalAcceptor<T extends Object>
        implements BaseOptionalAcceptor<T>
    {

        MissingCaseBaseOptionalAcceptor() {
        }

        @Override
        public<R extends Object, E extends Exception> R accept(BaseOptionalVisitor<T, R, E> visitor)
            throws E
        {
            return visitor.missing();
        }

        @Override
        @Nonnull
        public final T getValue() {
            throw new IllegalStateException("getValue is not accessible in this case: missing");
        }

        @Override
        public final boolean baseOptionalEquals(BaseOptionalAcceptor<?> thatAcceptor) {
            return thatAcceptor.baseOptionalEqualsMissing();
        }

        @Override
        public boolean baseOptionalEqualsMissing() {
            return true;
        }

        @Override
        public boolean baseOptionalEqualsPresent(Object value) {
            return false;
        }

        @Override
        public final int baseOptionalHashCode() {
            int result = 1;
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("BaseOptional.Missing{");
            result.append("}");
            return result.toString();
        }
    }

    private static class PresentCaseBaseOptionalAcceptor<T extends Object>
        implements BaseOptionalAcceptor<T>
    {
        private final T value;

        PresentCaseBaseOptionalAcceptor(T value) {
            this.value = value;
        }

        @Override
        public<R extends Object, E extends Exception> R accept(BaseOptionalVisitor<T, R, E> visitor)
            throws E
        {
            return visitor.present(this.value);
        }

        @Override
        @Nonnull
        public final T getValue() {
            return value;
        }

        @Override
        public boolean baseOptionalEqualsMissing() {
            return false;
        }

        @Override
        public final boolean baseOptionalEquals(BaseOptionalAcceptor<?> thatAcceptor) {
            return thatAcceptor.baseOptionalEqualsPresent(this.value);
        }

        @Override
        public boolean baseOptionalEqualsPresent(Object value) {
            return value.equals(this.value);
        }

        @Override
        public final int baseOptionalHashCode() {
            int result = 2;
            result = ((result* 37)+ this.value.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("BaseOptional.Present{");
            result.append("value = ");
            result.append(this.value);
            result.append("}");
            return result.toString();
        }
    }
}
