
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
public class ComparableList<T extends Object& Comparable<? super T>>
    implements Comparable<ComparableList<T>>
{
    private final ComparableListAcceptor<T> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static ComparableList EMPTY = new ComparableList(new EmptyCaseComparableListAcceptor());
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static ComparableListFactory FACTORY = new ComparableListFactory();

    private ComparableList(ComparableListAcceptor<T> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected ComparableList(
        @Nonnull
        ComparableList<T> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.ComparableList");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static<T extends Object& Comparable<? super T>> ComparableList<T> empty() {
        return EMPTY;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static<T extends Object& Comparable<? super T>> ComparableList<T> prepend(
        @Nonnull
        T head,
        @Nonnull
        ComparableList<T> tail) {
        if (head == null) {
            throw new NullPointerException("Argument shouldn't be null: 'head' argument in static method invocation: 'prepend' in class com.github.sviperll.adt4j.examples.ComparableList");
        }
        if (tail == null) {
            throw new NullPointerException("Argument shouldn't be null: 'tail' argument in static method invocation: 'prepend' in class com.github.sviperll.adt4j.examples.ComparableList");
        }
        return new ComparableList<T>(new PrependCaseComparableListAcceptor<T>(head, tail));
    }

    public final<R extends Object> R accept(ComparableListVisitor<T, ComparableList<T> , R> visitor) {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final T head() {
        return this.acceptor.head();
    }

    @Nonnull
    public final ComparableList<T> tail() {
        return this.acceptor.tail();
    }

    @Nonnull
    public final ComparableList<T> withHead(
        @Nonnull
        T newValue) {
        return this.acceptor.withHead(newValue);
    }

    public final boolean isEmpty() {
        return this.acceptor.isEmpty();
    }

    @Override
    public final int compareTo(ComparableList<T> that) {
        return this.acceptor.comparableListComapareTo(that.acceptor);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof ComparableList)) {
                return false;
            } else {
                ComparableList<?> that = ((ComparableList<?> ) thatObject);
                return this.acceptor.comparableListEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.comparableListHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static<T extends Object& Comparable<? super T>> ComparableListVisitor<T, ComparableList<T> , ComparableList<T>> factory() {
        return FACTORY;
    }

    private interface ComparableListAcceptor<T extends Object& Comparable<? super T>> {

        public<R extends Object> R accept(ComparableListVisitor<T, ComparableList<T> , R> visitor);

        @Nonnull
        public T head();

        @Nonnull
        public ComparableList<T> tail();

        @Nonnull
        public ComparableList<T> withHead(
            @Nonnull
            T newValue);

        public boolean isEmpty();

        public int comparableListComapareTo(ComparableListAcceptor<T> thatAcceptor);

        public int comparableListComapareToEmpty();

        public int comparableListComapareToPrepend(T head, ComparableList<T> tail);

        public boolean comparableListEquals(ComparableListAcceptor<?> thatAcceptor);

        public boolean comparableListEqualsEmpty();

        public boolean comparableListEqualsPrepend(Object head, ComparableList<?> tail);

        public int comparableListHashCode();
    }

    private static class ComparableListFactory<T extends Object& Comparable<? super T>>
        implements ComparableListVisitor<T, ComparableList<T> , ComparableList<T>>
    {

        @Nonnull
        @Override
        public ComparableList<T> empty() {
            return ComparableList.<T> empty();
        }

        @Nonnull
        @Override
        public ComparableList<T> prepend(T head, ComparableList<T> tail) {
            return ComparableList.<T> prepend(head, tail);
        }
    }

    private static class EmptyCaseComparableListAcceptor<T extends Object& Comparable<? super T>>
        implements ComparableListAcceptor<T>
    {

        EmptyCaseComparableListAcceptor() {
        }

        @Override
        public<R extends Object> R accept(ComparableListVisitor<T, ComparableList<T> , R> visitor) {
            return visitor.empty();
        }

        @Override
        @Nonnull
        public final T head() {
            throw new IllegalStateException("head is not accessible in this case: empty");
        }

        @Override
        @Nonnull
        public final ComparableList<T> tail() {
            throw new IllegalStateException("tail is not accessible in this case: empty");
        }

        @Nonnull
        @Override
        public final ComparableList<T> withHead(
            @Nonnull
            T newValue) {
            return ComparableList.<T> empty();
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final int comparableListComapareTo(ComparableListAcceptor<T> thatAcceptor) {
            return thatAcceptor.comparableListComapareToEmpty();
        }

        @Override
        public int comparableListComapareToEmpty() {
            return  0;
        }

        @Override
        public int comparableListComapareToPrepend(T head, ComparableList<T> tail) {
            return  1;
        }

        @Override
        public final boolean comparableListEquals(ComparableListAcceptor<?> thatAcceptor) {
            return thatAcceptor.comparableListEqualsEmpty();
        }

        @Override
        public boolean comparableListEqualsEmpty() {
            return true;
        }

        @Override
        public boolean comparableListEqualsPrepend(Object head, ComparableList<?> tail) {
            return false;
        }

        @Override
        public final int comparableListHashCode() {
            int result = 1;
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ComparableList.Empty{");
            result.append("}");
            return result.toString();
        }
    }

    private static class PrependCaseComparableListAcceptor<T extends Object& Comparable<? super T>>
        implements ComparableListAcceptor<T>
    {
        private final T head;
        private final ComparableList<T> tail;

        PrependCaseComparableListAcceptor(T head, ComparableList<T> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public<R extends Object> R accept(ComparableListVisitor<T, ComparableList<T> , R> visitor) {
            return visitor.prepend(this.head, this.tail);
        }

        @Override
        @Nonnull
        public final T head() {
            return head;
        }

        @Override
        @Nonnull
        public final ComparableList<T> tail() {
            return tail;
        }

        @Nonnull
        @Override
        public final ComparableList<T> withHead(
            @Nonnull
            T newValue) {
            return ComparableList.<T> prepend(newValue, this.tail);
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public int comparableListComapareToEmpty() {
            return -1;
        }

        @Override
        public final int comparableListComapareTo(ComparableListAcceptor<T> thatAcceptor) {
            return thatAcceptor.comparableListComapareToPrepend(this.head, this.tail);
        }

        @Override
        public int comparableListComapareToPrepend(T head, ComparableList<T> tail) {
            int result;
            result = head.compareTo(this.head);
            if (result!= 0) {
                return result;
            }
            result = tail.compareTo(this.tail);
            if (result!= 0) {
                return result;
            }
            return  0;
        }

        @Override
        public boolean comparableListEqualsEmpty() {
            return false;
        }

        @Override
        public final boolean comparableListEquals(ComparableListAcceptor<?> thatAcceptor) {
            return thatAcceptor.comparableListEqualsPrepend(this.head, this.tail);
        }

        @Override
        public boolean comparableListEqualsPrepend(Object head, ComparableList<?> tail) {
            if (!head.equals(this.head)) {
                return false;
            }
            return tail.equals(this.tail);
        }

        @Override
        public final int comparableListHashCode() {
            int result = 2;
            result = ((result* 37)+ this.head.hashCode());
            result = ((result* 37)+ this.tail.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ComparableList.Prepend{");
            result.append("head = ");
            result.append(this.head);
            result.append(", ");
            result.append("tail = ");
            result.append(this.tail);
            result.append("}");
            return result.toString();
        }
    }
}
