
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class EitherBase<T extends Object, U extends Object> {
    private final EitherBaseAcceptor<T, U> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static EitherBaseFactory FACTORY = new EitherBaseFactory();

    private EitherBase(EitherBaseAcceptor<T, U> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected EitherBase(
        @Nonnull
        EitherBase<T, U> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.EitherBase");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<T extends Object, U extends Object> EitherBase<T, U> left(
        @Nonnull
        T left) {
        if (left == null) {
            throw new NullPointerException("Argument shouldn't be null: 'left' argument in static method invocation: 'left' in class com.github.sviperll.adt4j.examples.EitherBase");
        }
        return new EitherBase<T, U>(new LeftCaseEitherBaseAcceptor<T, U>(left));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<T extends Object, U extends Object> EitherBase<T, U> right(
        @Nonnull
        U right) {
        if (right == null) {
            throw new NullPointerException("Argument shouldn't be null: 'right' argument in static method invocation: 'right' in class com.github.sviperll.adt4j.examples.EitherBase");
        }
        return new EitherBase<T, U>(new RightCaseEitherBaseAcceptor<T, U>(right));
    }

    public final<R extends Object> R accept(Either.Visitor<T, U, R> visitor) {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final T left() {
        return this.acceptor.left();
    }

    @Nonnull
    public final U right() {
        return this.acceptor.right();
    }

    public final boolean isLeft() {
        return this.acceptor.isLeft();
    }

    public final boolean isRight() {
        return this.acceptor.isRight();
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof EitherBase)) {
                return false;
            } else {
                EitherBase<?, ?> that = ((EitherBase<?, ?> ) thatObject);
                return this.acceptor.eitherBaseEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.eitherBaseHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<T extends Object, U extends Object> Either.Visitor<T, U, EitherBase<T, U>> factory() {
        return FACTORY;
    }

    private interface EitherBaseAcceptor<T extends Object, U extends Object> {

        public<R extends Object> R accept(Either.Visitor<T, U, R> visitor);

        @Nonnull
        public T left();

        @Nonnull
        public U right();

        public boolean isLeft();

        public boolean isRight();

        public boolean eitherBaseEquals(EitherBaseAcceptor<?, ?> thatAcceptor);

        public boolean eitherBaseEqualsLeft(Object left);

        public boolean eitherBaseEqualsRight(Object right);

        public int eitherBaseHashCode();
    }

    private static class EitherBaseFactory<T extends Object, U extends Object>
        implements Either.Visitor<T, U, EitherBase<T, U>>
    {

        @Nonnull
        @Override
        public EitherBase<T, U> left(T left) {
            return EitherBase.<T, U> left(left);
        }

        @Nonnull
        @Override
        public EitherBase<T, U> right(U right) {
            return EitherBase.<T, U> right(right);
        }
    }

    private static class LeftCaseEitherBaseAcceptor<T extends Object, U extends Object>
        implements EitherBaseAcceptor<T, U>
    {
        private final T left;

        LeftCaseEitherBaseAcceptor(T left) {
            this.left = left;
        }

        @Override
        public<R extends Object> R accept(Either.Visitor<T, U, R> visitor) {
            return visitor.left(this.left);
        }

        @Override
        @Nonnull
        public final T left() {
            return left;
        }

        @Override
        @Nonnull
        public final U right() {
            throw new IllegalStateException("right is not accessible in this case: left");
        }

        @Override
        public final boolean isLeft() {
            return true;
        }

        @Override
        public final boolean isRight() {
            return false;
        }

        @Override
        public final boolean eitherBaseEquals(EitherBaseAcceptor<?, ?> thatAcceptor) {
            return thatAcceptor.eitherBaseEqualsLeft(this.left);
        }

        @Override
        public boolean eitherBaseEqualsLeft(Object left) {
            return left.equals(this.left);
        }

        @Override
        public boolean eitherBaseEqualsRight(Object right) {
            return false;
        }

        @Override
        public final int eitherBaseHashCode() {
            int result = 1;
            result = ((result* 37)+ this.left.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("EitherBase.Left{");
            result.append("left = ");
            result.append(this.left);
            result.append("}");
            return result.toString();
        }
    }

    private static class RightCaseEitherBaseAcceptor<T extends Object, U extends Object>
        implements EitherBaseAcceptor<T, U>
    {
        private final U right;

        RightCaseEitherBaseAcceptor(U right) {
            this.right = right;
        }

        @Override
        public<R extends Object> R accept(Either.Visitor<T, U, R> visitor) {
            return visitor.right(this.right);
        }

        @Override
        @Nonnull
        public final T left() {
            throw new IllegalStateException("left is not accessible in this case: right");
        }

        @Override
        @Nonnull
        public final U right() {
            return right;
        }

        @Override
        public final boolean isLeft() {
            return false;
        }

        @Override
        public final boolean isRight() {
            return true;
        }

        @Override
        public boolean eitherBaseEqualsLeft(Object left) {
            return false;
        }

        @Override
        public final boolean eitherBaseEquals(EitherBaseAcceptor<?, ?> thatAcceptor) {
            return thatAcceptor.eitherBaseEqualsRight(this.right);
        }

        @Override
        public boolean eitherBaseEqualsRight(Object right) {
            return right.equals(this.right);
        }

        @Override
        public final int eitherBaseHashCode() {
            int result = 2;
            result = ((result* 37)+ this.right.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("EitherBase.Right{");
            result.append("right = ");
            result.append(this.right);
            result.append("}");
            return result.toString();
        }
    }
}
