
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
public class Expression {
    private final ExpressionAcceptor acceptor;
    private int hashCodeCachedValue = 0;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static ExpressionFactory FACTORY = new ExpressionFactory();

    private Expression(ExpressionAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected Expression(
        @Nonnull
        Expression implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.Expression");
        }
        this.hashCodeCachedValue = implementation.hashCodeCachedValue;
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static Expression add(
        @Nonnull
        Expression left,
        @Nonnull
        Expression right) {
        if (left == null) {
            throw new NullPointerException("Argument shouldn't be null: 'left' argument in static method invocation: 'add' in class com.github.sviperll.adt4j.examples.Expression");
        }
        if (right == null) {
            throw new NullPointerException("Argument shouldn't be null: 'right' argument in static method invocation: 'add' in class com.github.sviperll.adt4j.examples.Expression");
        }
        return new Expression(new AddCaseExpressionAcceptor(left, right));
    }

    @Nonnull
    public static Expression lit(int value) {
        return new Expression(new LitCaseExpressionAcceptor(value));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static Expression mul(
        @Nonnull
        Expression left,
        @Nonnull
        Expression right) {
        if (left == null) {
            throw new NullPointerException("Argument shouldn't be null: 'left' argument in static method invocation: 'mul' in class com.github.sviperll.adt4j.examples.Expression");
        }
        if (right == null) {
            throw new NullPointerException("Argument shouldn't be null: 'right' argument in static method invocation: 'mul' in class com.github.sviperll.adt4j.examples.Expression");
        }
        return new Expression(new MulCaseExpressionAcceptor(left, right));
    }

    public final<R extends Object> R accept(ExpressionVisitor<Expression, R> visitor) {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final Expression left() {
        return this.acceptor.left();
    }

    @Nonnull
    public final Expression right() {
        return this.acceptor.right();
    }

    public final boolean isAdd() {
        return this.acceptor.isAdd();
    }

    public final boolean isBinary() {
        return this.acceptor.isBinary();
    }

    public final boolean isLiteral() {
        return this.acceptor.isLiteral();
    }

    public final boolean isMul() {
        return this.acceptor.isMul();
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof Expression)) {
                return false;
            } else {
                Expression that = ((Expression) thatObject);
                return this.acceptor.expressionEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        int code = this.hashCodeCachedValue;
        if (code == 0) {
            code = this.acceptor.expressionHashCode();
            code = ((code!= 0)?code:-2147483648);
            this.hashCodeCachedValue = code;
        }
        return code;
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static ExpressionVisitor<Expression, Expression> factory() {
        return FACTORY;
    }

    private static class AddCaseExpressionAcceptor
        implements ExpressionAcceptor
    {
        private final Expression left;
        private final Expression right;

        AddCaseExpressionAcceptor(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public<R extends Object> R accept(ExpressionVisitor<Expression, R> visitor) {
            return visitor.add(this.left, this.right);
        }

        @Override
        @Nonnull
        public final Expression left() {
            return left;
        }

        @Override
        @Nonnull
        public final Expression right() {
            return right;
        }

        @Override
        public final boolean isAdd() {
            return true;
        }

        @Override
        public final boolean isBinary() {
            return true;
        }

        @Override
        public final boolean isLiteral() {
            return false;
        }

        @Override
        public final boolean isMul() {
            return false;
        }

        @Override
        public final boolean expressionEquals(ExpressionAcceptor thatAcceptor) {
            return thatAcceptor.expressionEqualsAdd(this.left, this.right);
        }

        @Override
        public boolean expressionEqualsAdd(Expression left, Expression right) {
            if (!left.equals(this.left)) {
                return false;
            }
            return right.equals(this.right);
        }

        @Override
        public boolean expressionEqualsLit(int value) {
            return false;
        }

        @Override
        public boolean expressionEqualsMul(Expression left, Expression right) {
            return false;
        }

        @Override
        public final int expressionHashCode() {
            int result = 1;
            result = ((result* 37)+ this.left.hashCode());
            result = ((result* 37)+ this.right.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Expression.Add{");
            result.append("left = ");
            result.append(this.left);
            result.append(", ");
            result.append("right = ");
            result.append(this.right);
            result.append("}");
            return result.toString();
        }
    }

    private interface ExpressionAcceptor {

        public<R extends Object> R accept(ExpressionVisitor<Expression, R> visitor);

        @Nonnull
        public Expression left();

        @Nonnull
        public Expression right();

        public boolean isAdd();

        public boolean isBinary();

        public boolean isLiteral();

        public boolean isMul();

        public boolean expressionEquals(ExpressionAcceptor thatAcceptor);

        public boolean expressionEqualsAdd(Expression left, Expression right);

        public boolean expressionEqualsLit(int value);

        public boolean expressionEqualsMul(Expression left, Expression right);

        public int expressionHashCode();
    }

    private static class ExpressionFactory
        implements ExpressionVisitor<Expression, Expression>
    {

        @Nonnull
        @Override
        public Expression add(Expression left, Expression right) {
            return Expression.add(left, right);
        }

        @Nonnull
        @Override
        public Expression lit(int value) {
            return Expression.lit(value);
        }

        @Nonnull
        @Override
        public Expression mul(Expression left, Expression right) {
            return Expression.mul(left, right);
        }
    }

    private static class LitCaseExpressionAcceptor
        implements ExpressionAcceptor
    {
        private final int value;

        LitCaseExpressionAcceptor(int value) {
            this.value = value;
        }

        @Override
        public<R extends Object> R accept(ExpressionVisitor<Expression, R> visitor) {
            return visitor.lit(this.value);
        }

        @Override
        @Nonnull
        public final Expression left() {
            throw new IllegalStateException("left is not accessible in this case: lit");
        }

        @Override
        @Nonnull
        public final Expression right() {
            throw new IllegalStateException("right is not accessible in this case: lit");
        }

        @Override
        public final boolean isAdd() {
            return false;
        }

        @Override
        public final boolean isBinary() {
            return false;
        }

        @Override
        public final boolean isLiteral() {
            return true;
        }

        @Override
        public final boolean isMul() {
            return false;
        }

        @Override
        public boolean expressionEqualsAdd(Expression left, Expression right) {
            return false;
        }

        @Override
        public final boolean expressionEquals(ExpressionAcceptor thatAcceptor) {
            return thatAcceptor.expressionEqualsLit(this.value);
        }

        @Override
        public boolean expressionEqualsLit(int value) {
            return (value == this.value);
        }

        @Override
        public boolean expressionEqualsMul(Expression left, Expression right) {
            return false;
        }

        @Override
        public final int expressionHashCode() {
            int result = 2;
            result = ((result* 37)+ this.value);
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Expression.Lit{");
            result.append("value = ");
            result.append(this.value);
            result.append("}");
            return result.toString();
        }
    }

    private static class MulCaseExpressionAcceptor
        implements ExpressionAcceptor
    {
        private final Expression left;
        private final Expression right;

        MulCaseExpressionAcceptor(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public<R extends Object> R accept(ExpressionVisitor<Expression, R> visitor) {
            return visitor.mul(this.left, this.right);
        }

        @Override
        @Nonnull
        public final Expression left() {
            return left;
        }

        @Override
        @Nonnull
        public final Expression right() {
            return right;
        }

        @Override
        public final boolean isAdd() {
            return false;
        }

        @Override
        public final boolean isBinary() {
            return true;
        }

        @Override
        public final boolean isLiteral() {
            return false;
        }

        @Override
        public final boolean isMul() {
            return true;
        }

        @Override
        public boolean expressionEqualsAdd(Expression left, Expression right) {
            return false;
        }

        @Override
        public boolean expressionEqualsLit(int value) {
            return false;
        }

        @Override
        public final boolean expressionEquals(ExpressionAcceptor thatAcceptor) {
            return thatAcceptor.expressionEqualsMul(this.left, this.right);
        }

        @Override
        public boolean expressionEqualsMul(Expression left, Expression right) {
            if (!left.equals(this.left)) {
                return false;
            }
            return right.equals(this.right);
        }

        @Override
        public final int expressionHashCode() {
            int result = 3;
            result = ((result* 37)+ this.left.hashCode());
            result = ((result* 37)+ this.right.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Expression.Mul{");
            result.append("left = ");
            result.append(this.left);
            result.append(", ");
            result.append("right = ");
            result.append(this.right);
            result.append("}");
            return result.toString();
        }
    }
}
