
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class GADTBase<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> {
    private final GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static GADTBaseFactory FACTORY = new GADTBaseFactory();

    private GADTBase(GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected GADTBase(
        @Nonnull
        GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.GADTBase");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> apply(
        @Nonnull
        SF function,
        @Nonnull
        SA argument,
        @Nonnull
        CAST_B_TO_T cast) {
        if (function == null) {
            throw new NullPointerException("Argument shouldn't be null: 'function' argument in static method invocation: 'apply' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (argument == null) {
            throw new NullPointerException("Argument shouldn't be null: 'argument' argument in static method invocation: 'apply' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (cast == null) {
            throw new NullPointerException("Argument shouldn't be null: 'cast' argument in static method invocation: 'apply' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        return new GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(new ApplyCaseGADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(function, argument, cast));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> if_(
        @Nonnull
        SBOOL condition,
        @Nonnull
        ST iftrue,
        @Nonnull
        ST iffalse) {
        if (condition == null) {
            throw new NullPointerException("Argument shouldn't be null: 'condition' argument in static method invocation: 'if_' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (iftrue == null) {
            throw new NullPointerException("Argument shouldn't be null: 'iftrue' argument in static method invocation: 'if_' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (iffalse == null) {
            throw new NullPointerException("Argument shouldn't be null: 'iffalse' argument in static method invocation: 'if_' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        return new GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(new If_CaseGADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(condition, iftrue, iffalse));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> isLessOrEqual(
        @Nonnull
        SI a,
        @Nonnull
        SI b,
        @Nonnull
        CAST_BOOL_TO_T cast) {
        if (a == null) {
            throw new NullPointerException("Argument shouldn't be null: 'a' argument in static method invocation: 'isLessOrEqual' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (b == null) {
            throw new NullPointerException("Argument shouldn't be null: 'b' argument in static method invocation: 'isLessOrEqual' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (cast == null) {
            throw new NullPointerException("Argument shouldn't be null: 'cast' argument in static method invocation: 'isLessOrEqual' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        return new GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(new IsLessOrEqualCaseGADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(a, b, cast));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> lambda(
        @Nonnull
        Function<A, SB> function,
        @Nonnull
        CAST_F_TO_T cast) {
        if (function == null) {
            throw new NullPointerException("Argument shouldn't be null: 'function' argument in static method invocation: 'lambda' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (cast == null) {
            throw new NullPointerException("Argument shouldn't be null: 'cast' argument in static method invocation: 'lambda' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        return new GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(new LambdaCaseGADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(function, cast));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> number(int n,
        @Nonnull
        CAST_INT_TO_T cast) {
        if (cast == null) {
            throw new NullPointerException("Argument shouldn't be null: 'cast' argument in static method invocation: 'number' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        return new GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(new NumberCaseGADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(n, cast));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> plus(
        @Nonnull
        SI a,
        @Nonnull
        SI b,
        @Nonnull
        CAST_INT_TO_T cast) {
        if (a == null) {
            throw new NullPointerException("Argument shouldn't be null: 'a' argument in static method invocation: 'plus' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (b == null) {
            throw new NullPointerException("Argument shouldn't be null: 'b' argument in static method invocation: 'plus' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        if (cast == null) {
            throw new NullPointerException("Argument shouldn't be null: 'cast' argument in static method invocation: 'plus' in class com.github.sviperll.adt4j.examples.GADTBase");
        }
        return new GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(new PlusCaseGADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>(a, b, cast));
    }

    public final<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor) {
        return acceptor.accept(visitor);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof GADTBase)) {
                return false;
            } else {
                GADTBase<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> that = ((GADTBase<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> ) thatObject);
                return this.acceptor.gADTBaseEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.gADTBaseHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>> factory() {
        return FACTORY;
    }

    private static class ApplyCaseGADTBaseAcceptor<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object>
        implements GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>
    {
        private final SF function;
        private final SA argument;
        private final CAST_B_TO_T cast;

        ApplyCaseGADTBaseAcceptor(SF function, SA argument, CAST_B_TO_T cast) {
            this.function = function;
            this.argument = argument;
            this.cast = cast;
        }

        @Override
        public<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor) {
            return visitor.apply(this.function, this.argument, this.cast);
        }

        @Override
        public final boolean gADTBaseEquals(GADTBaseAcceptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> thatAcceptor) {
            return thatAcceptor.gADTBaseEqualsApply(this.function, this.argument, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsApply(Object function, Object argument, Object cast) {
            if (!function.equals(this.function)) {
                return false;
            }
            if (!argument.equals(this.argument)) {
                return false;
            }
            return cast.equals(this.cast);
        }

        @Override
        public boolean gADTBaseEqualsIf_(Object condition, Object iftrue, Object iffalse) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIsLessOrEqual(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsLambda(Function<?, ?> function, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsNumber(int n, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsPlus(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public final int gADTBaseHashCode() {
            int result = 1;
            result = ((result* 37)+ this.function.hashCode());
            result = ((result* 37)+ this.argument.hashCode());
            result = ((result* 37)+ this.cast.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GADTBase.Apply{");
            result.append("function = ");
            result.append(this.function);
            result.append(", ");
            result.append("argument = ");
            result.append(this.argument);
            result.append(", ");
            result.append("cast = ");
            result.append(this.cast);
            result.append("}");
            return result.toString();
        }
    }

    private interface GADTBaseAcceptor<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object> {

        public<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor);

        public boolean gADTBaseEquals(GADTBaseAcceptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> thatAcceptor);

        public boolean gADTBaseEqualsApply(Object function, Object argument, Object cast);

        public boolean gADTBaseEqualsIf_(Object condition, Object iftrue, Object iffalse);

        public boolean gADTBaseEqualsIsLessOrEqual(Object a, Object b, Object cast);

        public boolean gADTBaseEqualsLambda(Function<?, ?> function, Object cast);

        public boolean gADTBaseEqualsNumber(int n, Object cast);

        public boolean gADTBaseEqualsPlus(Object a, Object b, Object cast);

        public int gADTBaseHashCode();
    }

    private static class GADTBaseFactory<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object>
        implements GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>>
    {

        @Nonnull
        @Override
        public GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> apply(SF function, SA argument, CAST_B_TO_T cast) {
            return GADTBase.<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> apply(function, argument, cast);
        }

        @Nonnull
        @Override
        public GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> if_(SBOOL condition, ST iftrue, ST iffalse) {
            return GADTBase.<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> if_(condition, iftrue, iffalse);
        }

        @Nonnull
        @Override
        public GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> isLessOrEqual(SI a, SI b, CAST_BOOL_TO_T cast) {
            return GADTBase.<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> isLessOrEqual(a, b, cast);
        }

        @Nonnull
        @Override
        public GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> lambda(Function<A, SB> function, CAST_F_TO_T cast) {
            return GADTBase.<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> lambda(function, cast);
        }

        @Nonnull
        @Override
        public GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> number(int n, CAST_INT_TO_T cast) {
            return GADTBase.<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> number(n, cast);
        }

        @Nonnull
        @Override
        public GADTBase<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> plus(SI a, SI b, CAST_INT_TO_T cast) {
            return GADTBase.<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST> plus(a, b, cast);
        }
    }

    private static class If_CaseGADTBaseAcceptor<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object>
        implements GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>
    {
        private final SBOOL condition;
        private final ST iftrue;
        private final ST iffalse;

        If_CaseGADTBaseAcceptor(SBOOL condition, ST iftrue, ST iffalse) {
            this.condition = condition;
            this.iftrue = iftrue;
            this.iffalse = iffalse;
        }

        @Override
        public<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor) {
            return visitor.if_(this.condition, this.iftrue, this.iffalse);
        }

        @Override
        public boolean gADTBaseEqualsApply(Object function, Object argument, Object cast) {
            return false;
        }

        @Override
        public final boolean gADTBaseEquals(GADTBaseAcceptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> thatAcceptor) {
            return thatAcceptor.gADTBaseEqualsIf_(this.condition, this.iftrue, this.iffalse);
        }

        @Override
        public boolean gADTBaseEqualsIf_(Object condition, Object iftrue, Object iffalse) {
            if (!condition.equals(this.condition)) {
                return false;
            }
            if (!iftrue.equals(this.iftrue)) {
                return false;
            }
            return iffalse.equals(this.iffalse);
        }

        @Override
        public boolean gADTBaseEqualsIsLessOrEqual(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsLambda(Function<?, ?> function, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsNumber(int n, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsPlus(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public final int gADTBaseHashCode() {
            int result = 2;
            result = ((result* 37)+ this.condition.hashCode());
            result = ((result* 37)+ this.iftrue.hashCode());
            result = ((result* 37)+ this.iffalse.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GADTBase.If_{");
            result.append("condition = ");
            result.append(this.condition);
            result.append(", ");
            result.append("iftrue = ");
            result.append(this.iftrue);
            result.append(", ");
            result.append("iffalse = ");
            result.append(this.iffalse);
            result.append("}");
            return result.toString();
        }
    }

    private static class IsLessOrEqualCaseGADTBaseAcceptor<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object>
        implements GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>
    {
        private final SI a;
        private final SI b;
        private final CAST_BOOL_TO_T cast;

        IsLessOrEqualCaseGADTBaseAcceptor(SI a, SI b, CAST_BOOL_TO_T cast) {
            this.a = a;
            this.b = b;
            this.cast = cast;
        }

        @Override
        public<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor) {
            return visitor.isLessOrEqual(this.a, this.b, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsApply(Object function, Object argument, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIf_(Object condition, Object iftrue, Object iffalse) {
            return false;
        }

        @Override
        public final boolean gADTBaseEquals(GADTBaseAcceptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> thatAcceptor) {
            return thatAcceptor.gADTBaseEqualsIsLessOrEqual(this.a, this.b, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsIsLessOrEqual(Object a, Object b, Object cast) {
            if (!a.equals(this.a)) {
                return false;
            }
            if (!b.equals(this.b)) {
                return false;
            }
            return cast.equals(this.cast);
        }

        @Override
        public boolean gADTBaseEqualsLambda(Function<?, ?> function, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsNumber(int n, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsPlus(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public final int gADTBaseHashCode() {
            int result = 3;
            result = ((result* 37)+ this.a.hashCode());
            result = ((result* 37)+ this.b.hashCode());
            result = ((result* 37)+ this.cast.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GADTBase.IsLessOrEqual{");
            result.append("a = ");
            result.append(this.a);
            result.append(", ");
            result.append("b = ");
            result.append(this.b);
            result.append(", ");
            result.append("cast = ");
            result.append(this.cast);
            result.append("}");
            return result.toString();
        }
    }

    private static class LambdaCaseGADTBaseAcceptor<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object>
        implements GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>
    {
        private final Function<A, SB> function;
        private final CAST_F_TO_T cast;

        LambdaCaseGADTBaseAcceptor(Function<A, SB> function, CAST_F_TO_T cast) {
            this.function = function;
            this.cast = cast;
        }

        @Override
        public<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor) {
            return visitor.lambda(this.function, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsApply(Object function, Object argument, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIf_(Object condition, Object iftrue, Object iffalse) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIsLessOrEqual(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public final boolean gADTBaseEquals(GADTBaseAcceptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> thatAcceptor) {
            return thatAcceptor.gADTBaseEqualsLambda(this.function, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsLambda(Function<?, ?> function, Object cast) {
            if (!function.equals(this.function)) {
                return false;
            }
            return cast.equals(this.cast);
        }

        @Override
        public boolean gADTBaseEqualsNumber(int n, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsPlus(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public final int gADTBaseHashCode() {
            int result = 4;
            result = ((result* 37)+ this.function.hashCode());
            result = ((result* 37)+ this.cast.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GADTBase.Lambda{");
            result.append("function = ");
            result.append(this.function);
            result.append(", ");
            result.append("cast = ");
            result.append(this.cast);
            result.append("}");
            return result.toString();
        }
    }

    private static class NumberCaseGADTBaseAcceptor<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object>
        implements GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>
    {
        private final int n;
        private final CAST_INT_TO_T cast;

        NumberCaseGADTBaseAcceptor(int n, CAST_INT_TO_T cast) {
            this.n = n;
            this.cast = cast;
        }

        @Override
        public<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor) {
            return visitor.number(this.n, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsApply(Object function, Object argument, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIf_(Object condition, Object iftrue, Object iffalse) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIsLessOrEqual(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsLambda(Function<?, ?> function, Object cast) {
            return false;
        }

        @Override
        public final boolean gADTBaseEquals(GADTBaseAcceptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> thatAcceptor) {
            return thatAcceptor.gADTBaseEqualsNumber(this.n, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsNumber(int n, Object cast) {
            if (n!= this.n) {
                return false;
            }
            return cast.equals(this.cast);
        }

        @Override
        public boolean gADTBaseEqualsPlus(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public final int gADTBaseHashCode() {
            int result = 5;
            result = ((result* 37)+ this.n);
            result = ((result* 37)+ this.cast.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GADTBase.Number{");
            result.append("n = ");
            result.append(this.n);
            result.append(", ");
            result.append("cast = ");
            result.append(this.cast);
            result.append("}");
            return result.toString();
        }
    }

    private static class PlusCaseGADTBaseAcceptor<A extends Object, SF extends Object, SA extends Object, SB extends Object, SI extends Object, SBOOL extends Object, CAST_F_TO_T extends Object, CAST_B_TO_T extends Object, CAST_INT_TO_T extends Object, CAST_BOOL_TO_T extends Object, ST extends Object>
        implements GADTBaseAcceptor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST>
    {
        private final SI a;
        private final SI b;
        private final CAST_INT_TO_T cast;

        PlusCaseGADTBaseAcceptor(SI a, SI b, CAST_INT_TO_T cast) {
            this.a = a;
            this.b = b;
            this.cast = cast;
        }

        @Override
        public<R extends Object> R accept(GADTBaseVisitor<A, SF, SA, SB, SI, SBOOL, CAST_F_TO_T, CAST_B_TO_T, CAST_INT_TO_T, CAST_BOOL_TO_T, ST, R> visitor) {
            return visitor.plus(this.a, this.b, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsApply(Object function, Object argument, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIf_(Object condition, Object iftrue, Object iffalse) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsIsLessOrEqual(Object a, Object b, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsLambda(Function<?, ?> function, Object cast) {
            return false;
        }

        @Override
        public boolean gADTBaseEqualsNumber(int n, Object cast) {
            return false;
        }

        @Override
        public final boolean gADTBaseEquals(GADTBaseAcceptor<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> thatAcceptor) {
            return thatAcceptor.gADTBaseEqualsPlus(this.a, this.b, this.cast);
        }

        @Override
        public boolean gADTBaseEqualsPlus(Object a, Object b, Object cast) {
            if (!a.equals(this.a)) {
                return false;
            }
            if (!b.equals(this.b)) {
                return false;
            }
            return cast.equals(this.cast);
        }

        @Override
        public final int gADTBaseHashCode() {
            int result = 6;
            result = ((result* 37)+ this.a.hashCode());
            result = ((result* 37)+ this.b.hashCode());
            result = ((result* 37)+ this.cast.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GADTBase.Plus{");
            result.append("a = ");
            result.append(this.a);
            result.append(", ");
            result.append("b = ");
            result.append(this.b);
            result.append(", ");
            result.append("cast = ");
            result.append(this.cast);
            result.append("}");
            return result.toString();
        }
    }
}
