
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
public class GroupName
    implements Comparable<GroupName>
{
    private final GroupNameAcceptor acceptor;
    private final int hashCodeCachedValue;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static GroupNameFactory FACTORY = new GroupNameFactory();

    private GroupName(GroupNameAcceptor acceptor) {
        this.hashCodeCachedValue = acceptor.groupNameHashCode();
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected GroupName(
        @Nonnull
        GroupName implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.GroupName");
        }
        this.hashCodeCachedValue = implementation.hashCodeCachedValue;
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static GroupName valueOf(
        @Nonnull
        String name) {
        if (name == null) {
            throw new NullPointerException("Argument shouldn't be null: 'name' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.GroupName");
        }
        return new GroupName(new ValueOfCaseGroupNameAcceptor(name));
    }

    public final<R extends Object> R accept(GroupNameVisitor<R> visitor) {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final String name() {
        return this.acceptor.name();
    }

    @Override
    public final int compareTo(GroupName that) {
        return this.acceptor.groupNameComapareTo(that.acceptor);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof GroupName)) {
                return false;
            } else {
                GroupName that = ((GroupName) thatObject);
                return ((this.hashCodeCachedValue == that.hashCodeCachedValue)&&this.acceptor.groupNameEquals(that.acceptor));
            }
        }
    }

    @Override
    public final int hashCode() {
        return hashCodeCachedValue;
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static GroupNameVisitor<GroupName> factory() {
        return FACTORY;
    }

    private interface GroupNameAcceptor {

        public<R extends Object> R accept(GroupNameVisitor<R> visitor);

        @Nonnull
        public String name();

        public int groupNameComapareTo(GroupNameAcceptor thatAcceptor);

        public int groupNameComapareToValueOf(String name);

        public boolean groupNameEquals(GroupNameAcceptor thatAcceptor);

        public boolean groupNameEqualsValueOf(String name);

        public int groupNameHashCode();
    }

    private static class GroupNameFactory
        implements GroupNameVisitor<GroupName>
    {

        @Nonnull
        @Override
        public GroupName valueOf(String name) {
            return GroupName.valueOf(name);
        }
    }

    private static class ValueOfCaseGroupNameAcceptor
        implements GroupNameAcceptor
    {
        private final String name;

        ValueOfCaseGroupNameAcceptor(String name) {
            this.name = name;
        }

        @Override
        public<R extends Object> R accept(GroupNameVisitor<R> visitor) {
            return visitor.valueOf(this.name);
        }

        @Override
        @Nonnull
        public final String name() {
            return name;
        }

        @Override
        public final int groupNameComapareTo(GroupNameAcceptor thatAcceptor) {
            return thatAcceptor.groupNameComapareToValueOf(this.name);
        }

        @Override
        public int groupNameComapareToValueOf(String name) {
            int result;
            result = name.compareTo(this.name);
            if (result!= 0) {
                return result;
            }
            return  0;
        }

        @Override
        public final boolean groupNameEquals(GroupNameAcceptor thatAcceptor) {
            return thatAcceptor.groupNameEqualsValueOf(this.name);
        }

        @Override
        public boolean groupNameEqualsValueOf(String name) {
            return name.equals(this.name);
        }

        @Override
        public final int groupNameHashCode() {
            int result = 1;
            result = ((result* 37)+ this.name.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("GroupName.ValueOf{");
            result.append("name = ");
            result.append(this.name);
            result.append("}");
            return result.toString();
        }
    }
}
