
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
public class List<T extends Object> {
    private final ListAcceptor<T> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static List NIL = new List(new NilCaseListAcceptor());
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static ListFactory FACTORY = new ListFactory();

    private List(ListAcceptor<T> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected List(
        @Nonnull
        List<T> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.List");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static<T extends Object> List<T> cons(
        @Nonnull
        T head,
        @Nonnull
        List<T> tail) {
        if (head == null) {
            throw new NullPointerException("Argument shouldn't be null: 'head' argument in static method invocation: 'cons' in class com.github.sviperll.adt4j.examples.List");
        }
        if (tail == null) {
            throw new NullPointerException("Argument shouldn't be null: 'tail' argument in static method invocation: 'cons' in class com.github.sviperll.adt4j.examples.List");
        }
        return new List<T>(new ConsCaseListAcceptor<T>(head, tail));
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static<T extends Object> List<T> nil() {
        return NIL;
    }

    public final<R extends Object> R accept(ListVisitor<T, List<T> , R> visitor) {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final T head() {
        return this.acceptor.head();
    }

    @Nonnull
    public final List<T> tail() {
        return this.acceptor.tail();
    }

    @Nonnull
    public final List<T> withHead(
        @Nonnull
        T newValue) {
        return this.acceptor.withHead(newValue);
    }

    public final boolean isEmpty() {
        return this.acceptor.isEmpty();
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof List)) {
                return false;
            } else {
                List<?> that = ((List<?> ) thatObject);
                return this.acceptor.listEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.listHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static<T extends Object> ListVisitor<T, List<T> , List<T>> factory() {
        return FACTORY;
    }

    private static class ConsCaseListAcceptor<T extends Object>
        implements ListAcceptor<T>
    {
        private final T head;
        private final List<T> tail;

        ConsCaseListAcceptor(T head, List<T> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public<R extends Object> R accept(ListVisitor<T, List<T> , R> visitor) {
            return visitor.cons(this.head, this.tail);
        }

        @Override
        @Nonnull
        public final T head() {
            return head;
        }

        @Override
        @Nonnull
        public final List<T> tail() {
            return tail;
        }

        @Nonnull
        @Override
        public final List<T> withHead(
            @Nonnull
            T newValue) {
            return List.<T> cons(newValue, this.tail);
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final boolean listEquals(ListAcceptor<?> thatAcceptor) {
            return thatAcceptor.listEqualsCons(this.head, this.tail);
        }

        @Override
        public boolean listEqualsCons(Object head, List<?> tail) {
            if (!head.equals(this.head)) {
                return false;
            }
            return tail.equals(this.tail);
        }

        @Override
        public boolean listEqualsNil() {
            return false;
        }

        @Override
        public final int listHashCode() {
            int result = 1;
            result = ((result* 37)+ this.head.hashCode());
            result = ((result* 37)+ this.tail.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("List.Cons{");
            result.append("head = ");
            result.append(this.head);
            result.append(", ");
            result.append("tail = ");
            result.append(this.tail);
            result.append("}");
            return result.toString();
        }
    }

    private interface ListAcceptor<T extends Object> {

        public<R extends Object> R accept(ListVisitor<T, List<T> , R> visitor);

        @Nonnull
        public T head();

        @Nonnull
        public List<T> tail();

        @Nonnull
        public List<T> withHead(
            @Nonnull
            T newValue);

        public boolean isEmpty();

        public boolean listEquals(ListAcceptor<?> thatAcceptor);

        public boolean listEqualsCons(Object head, List<?> tail);

        public boolean listEqualsNil();

        public int listHashCode();
    }

    private static class ListFactory<T extends Object>
        implements ListVisitor<T, List<T> , List<T>>
    {

        @Nonnull
        @Override
        public List<T> cons(T head, List<T> tail) {
            return List.<T> cons(head, tail);
        }

        @Nonnull
        @Override
        public List<T> nil() {
            return List.<T> nil();
        }
    }

    private static class NilCaseListAcceptor<T extends Object>
        implements ListAcceptor<T>
    {

        NilCaseListAcceptor() {
        }

        @Override
        public<R extends Object> R accept(ListVisitor<T, List<T> , R> visitor) {
            return visitor.nil();
        }

        @Override
        @Nonnull
        public final T head() {
            throw new IllegalStateException("head is not accessible in this case: nil");
        }

        @Override
        @Nonnull
        public final List<T> tail() {
            throw new IllegalStateException("tail is not accessible in this case: nil");
        }

        @Nonnull
        @Override
        public final List<T> withHead(
            @Nonnull
            T newValue) {
            return List.<T> nil();
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public boolean listEqualsCons(Object head, List<?> tail) {
            return false;
        }

        @Override
        public final boolean listEquals(ListAcceptor<?> thatAcceptor) {
            return thatAcceptor.listEqualsNil();
        }

        @Override
        public boolean listEqualsNil() {
            return true;
        }

        @Override
        public final int listHashCode() {
            int result = 2;
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("List.Nil{");
            result.append("}");
            return result.toString();
        }
    }
}
