
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class OptionalValue<T extends Object> {
    private final OptionalValueAcceptor<T> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static OptionalValue MISSING = new OptionalValue(new MissingCaseOptionalValueAcceptor());
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static OptionalValueFactory FACTORY = new OptionalValueFactory();

    private OptionalValue(OptionalValueAcceptor<T> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected OptionalValue(
        @Nonnull
        OptionalValue<T> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.OptionalValue");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<T extends Object> OptionalValue<T> missing() {
        return MISSING;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<T extends Object> OptionalValue<T> present(
        @Nonnull
        T value) {
        if (value == null) {
            throw new NullPointerException("Argument shouldn't be null: 'value' argument in static method invocation: 'present' in class com.github.sviperll.adt4j.examples.OptionalValue");
        }
        return new OptionalValue<T>(new PresentCaseOptionalValueAcceptor<T>(value));
    }

    public final<R extends Object, E extends Exception> R accept(OptionalVisitor<T, R, E> visitor)
        throws E
    {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final T getValue() {
        return this.acceptor.getValue();
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof OptionalValue)) {
                return false;
            } else {
                OptionalValue<?> that = ((OptionalValue<?> ) thatObject);
                return this.acceptor.optionalValueEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.optionalValueHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<T extends Object> OptionalVisitor<T, OptionalValue<T> , RuntimeException> factory() {
        return FACTORY;
    }

    private static class MissingCaseOptionalValueAcceptor<T extends Object>
        implements OptionalValueAcceptor<T>
    {

        MissingCaseOptionalValueAcceptor() {
        }

        @Override
        public<R extends Object, E extends Exception> R accept(OptionalVisitor<T, R, E> visitor)
            throws E
        {
            return visitor.missing();
        }

        @Override
        @Nonnull
        public final T getValue() {
            throw new IllegalStateException("getValue is not accessible in this case: missing");
        }

        @Override
        public final boolean optionalValueEquals(OptionalValueAcceptor<?> thatAcceptor) {
            return thatAcceptor.optionalValueEqualsMissing();
        }

        @Override
        public boolean optionalValueEqualsMissing() {
            return true;
        }

        @Override
        public boolean optionalValueEqualsPresent(Object value) {
            return false;
        }

        @Override
        public final int optionalValueHashCode() {
            int result = 1;
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("OptionalValue.Missing{");
            result.append("}");
            return result.toString();
        }
    }

    private interface OptionalValueAcceptor<T extends Object> {

        public<R extends Object, E extends Exception> R accept(OptionalVisitor<T, R, E> visitor)
            throws E
        ;

        @Nonnull
        public T getValue();

        public boolean optionalValueEquals(OptionalValueAcceptor<?> thatAcceptor);

        public boolean optionalValueEqualsMissing();

        public boolean optionalValueEqualsPresent(Object value);

        public int optionalValueHashCode();
    }

    private static class OptionalValueFactory<T extends Object>
        implements OptionalVisitor<T, OptionalValue<T> , RuntimeException>
    {

        @Nonnull
        @Override
        public OptionalValue<T> missing() {
            return OptionalValue.<T> missing();
        }

        @Nonnull
        @Override
        public OptionalValue<T> present(T value) {
            return OptionalValue.<T> present(value);
        }
    }

    private static class PresentCaseOptionalValueAcceptor<T extends Object>
        implements OptionalValueAcceptor<T>
    {
        private final T value;

        PresentCaseOptionalValueAcceptor(T value) {
            this.value = value;
        }

        @Override
        public<R extends Object, E extends Exception> R accept(OptionalVisitor<T, R, E> visitor)
            throws E
        {
            return visitor.present(this.value);
        }

        @Override
        @Nonnull
        public final T getValue() {
            return value;
        }

        @Override
        public boolean optionalValueEqualsMissing() {
            return false;
        }

        @Override
        public final boolean optionalValueEquals(OptionalValueAcceptor<?> thatAcceptor) {
            return thatAcceptor.optionalValueEqualsPresent(this.value);
        }

        @Override
        public boolean optionalValueEqualsPresent(Object value) {
            return value.equals(this.value);
        }

        @Override
        public final int optionalValueHashCode() {
            int result = 2;
            result = ((result* 37)+ this.value.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("OptionalValue.Present{");
            result.append("value = ");
            result.append(this.value);
            result.append("}");
            return result.toString();
        }
    }
}
