
package com.github.sviperll.adt4j.examples;

import java.util.Arrays;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class Record {
    private final RecordAcceptor acceptor;
    private int hashCodeCachedValue = 0;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static RecordFactory FACTORY = new RecordFactory();

    private Record(RecordAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected Record(
        @Nonnull
        Record implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.Record");
        }
        this.hashCodeCachedValue = implementation.hashCodeCachedValue;
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static Record valueOf(boolean bool, byte b, char c, int i, long l, float f, double d,
        @Nonnull
        Object result,
        @Nullable
        boolean[] boola,
        @Nonnull
        byte[][] ba,
        @Nonnull
        char[] ca,
        @Nonnull
        int[] ia,
        @Nonnull
        long[] la,
        @Nonnull
        float[] fa,
        @Nonnull
        double[] da,
        @Nullable
        Object[] newValue) {
        if (result == null) {
            throw new NullPointerException("Argument shouldn't be null: 'result' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.Record");
        }
        if (ba == null) {
            throw new NullPointerException("Argument shouldn't be null: 'ba' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.Record");
        }
        if (ca == null) {
            throw new NullPointerException("Argument shouldn't be null: 'ca' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.Record");
        }
        if (ia == null) {
            throw new NullPointerException("Argument shouldn't be null: 'ia' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.Record");
        }
        if (la == null) {
            throw new NullPointerException("Argument shouldn't be null: 'la' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.Record");
        }
        if (fa == null) {
            throw new NullPointerException("Argument shouldn't be null: 'fa' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.Record");
        }
        if (da == null) {
            throw new NullPointerException("Argument shouldn't be null: 'da' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.Record");
        }
        return new Record(new ValueOfCaseRecordAcceptor(bool, b, c, i, l, f, d, result, boola, ba, ca, ia, la, fa, da, newValue));
    }

    public final<R extends Object> R accept(RecordVisitor<R> visitor) {
        return acceptor.accept(visitor);
    }

    public final byte getB() {
        return this.acceptor.getB();
    }

    @Nonnull
    public final byte[][] getBa() {
        return this.acceptor.getBa();
    }

    public final boolean getBool() {
        return this.acceptor.getBool();
    }

    @Nullable
    public final boolean[] getBoola() {
        return this.acceptor.getBoola();
    }

    public final char getC() {
        return this.acceptor.getC();
    }

    @Nonnull
    public final char[] getCa() {
        return this.acceptor.getCa();
    }

    public final double getD() {
        return this.acceptor.getD();
    }

    @Nonnull
    public final double[] getDa() {
        return this.acceptor.getDa();
    }

    public final float getF() {
        return this.acceptor.getF();
    }

    @Nonnull
    public final float[] getFa() {
        return this.acceptor.getFa();
    }

    public final int getI() {
        return this.acceptor.getI();
    }

    @Nonnull
    public final int[] getIa() {
        return this.acceptor.getIa();
    }

    public final long getL() {
        return this.acceptor.getL();
    }

    @Nonnull
    public final long[] getLa() {
        return this.acceptor.getLa();
    }

    @Nonnull
    public final Object getO() {
        return this.acceptor.getO();
    }

    @Nullable
    public final Object[] getOa() {
        return this.acceptor.getOa();
    }

    @Nonnull
    public final Record withB(byte newValue) {
        return this.acceptor.withB(newValue);
    }

    @Nonnull
    public final Record withBa(
        @Nonnull
        byte[][] newValue) {
        return this.acceptor.withBa(newValue);
    }

    @Nonnull
    public final Record withBool(boolean newValue) {
        return this.acceptor.withBool(newValue);
    }

    @Nonnull
    public final Record withBoola(
        @Nullable
        boolean[] newValue) {
        return this.acceptor.withBoola(newValue);
    }

    @Nonnull
    public final Record withC(char newValue) {
        return this.acceptor.withC(newValue);
    }

    @Nonnull
    public final Record withCa(
        @Nonnull
        char[] newValue) {
        return this.acceptor.withCa(newValue);
    }

    @Nonnull
    public final Record withD(double newValue) {
        return this.acceptor.withD(newValue);
    }

    @Nonnull
    public final Record withDa(
        @Nonnull
        double[] newValue) {
        return this.acceptor.withDa(newValue);
    }

    @Nonnull
    public final Record withF(float newValue) {
        return this.acceptor.withF(newValue);
    }

    @Nonnull
    public final Record withFa(
        @Nonnull
        float[] newValue) {
        return this.acceptor.withFa(newValue);
    }

    @Nonnull
    public final Record withI(int newValue) {
        return this.acceptor.withI(newValue);
    }

    @Nonnull
    public final Record withIa(
        @Nonnull
        int[] newValue) {
        return this.acceptor.withIa(newValue);
    }

    @Nonnull
    public final Record withL(long newValue) {
        return this.acceptor.withL(newValue);
    }

    @Nonnull
    public final Record withLa(
        @Nonnull
        long[] newValue) {
        return this.acceptor.withLa(newValue);
    }

    @Nonnull
    public final Record withO(
        @Nonnull
        Object newValue) {
        return this.acceptor.withO(newValue);
    }

    @Nonnull
    public final Record withOa(
        @Nullable
        Object[] newValue) {
        return this.acceptor.withOa(newValue);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof Record)) {
                return false;
            } else {
                Record that = ((Record) thatObject);
                return this.acceptor.recordEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        int code = this.hashCodeCachedValue;
        if (code == 0) {
            synchronized (this.acceptor) {
                code = this.hashCodeCachedValue;
                if (code == 0) {
                    code = this.acceptor.recordHashCode();
                    code = ((code!= 0)?code:-2147483648);
                    this.hashCodeCachedValue = code;
                }
            }
        }
        return code;
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static RecordVisitor<Record> factory() {
        return FACTORY;
    }

    private interface RecordAcceptor {

        public<R extends Object> R accept(RecordVisitor<R> visitor);

        public byte getB();

        @Nonnull
        public byte[][] getBa();

        public boolean getBool();

        @Nullable
        public boolean[] getBoola();

        public char getC();

        @Nonnull
        public char[] getCa();

        public double getD();

        @Nonnull
        public double[] getDa();

        public float getF();

        @Nonnull
        public float[] getFa();

        public int getI();

        @Nonnull
        public int[] getIa();

        public long getL();

        @Nonnull
        public long[] getLa();

        @Nonnull
        public Object getO();

        @Nullable
        public Object[] getOa();

        @Nonnull
        public Record withB(byte newValue);

        @Nonnull
        public Record withBa(
            @Nonnull
            byte[][] newValue);

        @Nonnull
        public Record withBool(boolean newValue);

        @Nonnull
        public Record withBoola(
            @Nullable
            boolean[] newValue);

        @Nonnull
        public Record withC(char newValue);

        @Nonnull
        public Record withCa(
            @Nonnull
            char[] newValue);

        @Nonnull
        public Record withD(double newValue);

        @Nonnull
        public Record withDa(
            @Nonnull
            double[] newValue);

        @Nonnull
        public Record withF(float newValue);

        @Nonnull
        public Record withFa(
            @Nonnull
            float[] newValue);

        @Nonnull
        public Record withI(int newValue);

        @Nonnull
        public Record withIa(
            @Nonnull
            int[] newValue);

        @Nonnull
        public Record withL(long newValue);

        @Nonnull
        public Record withLa(
            @Nonnull
            long[] newValue);

        @Nonnull
        public Record withO(
            @Nonnull
            Object newValue);

        @Nonnull
        public Record withOa(
            @Nullable
            Object[] newValue);

        public boolean recordEquals(RecordAcceptor thatAcceptor);

        public boolean recordEqualsValueOf(boolean bool, byte b, char c, int i, long l, float f, double d, Object result, boolean[] boola, byte[][] ba, char[] ca, int[] ia, long[] la, float[] fa, double[] da, Object[] newValue);

        public int recordHashCode();
    }

    private static class RecordFactory
        implements RecordVisitor<Record>
    {

        @Nonnull
        @Override
        public Record valueOf(boolean bool, byte b, char c, int i, long l, float f, double d, Object result, boolean[] boola, byte[][] ba, char[] ca, int[] ia, long[] la, float[] fa, double[] da, Object[] newValue) {
            return Record.valueOf(bool, b, c, i, l, f, d, result, boola, ba, ca, ia, la, fa, da, newValue);
        }
    }

    private static class ValueOfCaseRecordAcceptor
        implements RecordAcceptor
    {
        private final boolean bool;
        private final byte b;
        private final char c;
        private final int i;
        private final long l;
        private final float f;
        private final double d;
        private final Object result;
        private final boolean[] boola;
        private final byte[][] ba;
        private final char[] ca;
        private final int[] ia;
        private final long[] la;
        private final float[] fa;
        private final double[] da;
        private final Object[] newValue;

        ValueOfCaseRecordAcceptor(boolean bool, byte b, char c, int i, long l, float f, double d, Object result, boolean[] boola, byte[][] ba, char[] ca, int[] ia, long[] la, float[] fa, double[] da, Object[] newValue) {
            this.bool = bool;
            this.b = b;
            this.c = c;
            this.i = i;
            this.l = l;
            this.f = f;
            this.d = d;
            this.result = result;
            this.boola = boola;
            this.ba = ba;
            this.ca = ca;
            this.ia = ia;
            this.la = la;
            this.fa = fa;
            this.da = da;
            this.newValue = newValue;
        }

        @Override
        public<R extends Object> R accept(RecordVisitor<R> visitor) {
            return visitor.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Override
        public final byte getB() {
            return b;
        }

        @Override
        @Nonnull
        public final byte[][] getBa() {
            return ba;
        }

        @Override
        public final boolean getBool() {
            return bool;
        }

        @Override
        @Nullable
        public final boolean[] getBoola() {
            return boola;
        }

        @Override
        public final char getC() {
            return c;
        }

        @Override
        @Nonnull
        public final char[] getCa() {
            return ca;
        }

        @Override
        public final double getD() {
            return d;
        }

        @Override
        @Nonnull
        public final double[] getDa() {
            return da;
        }

        @Override
        public final float getF() {
            return f;
        }

        @Override
        @Nonnull
        public final float[] getFa() {
            return fa;
        }

        @Override
        public final int getI() {
            return i;
        }

        @Override
        @Nonnull
        public final int[] getIa() {
            return ia;
        }

        @Override
        public final long getL() {
            return l;
        }

        @Override
        @Nonnull
        public final long[] getLa() {
            return la;
        }

        @Override
        @Nonnull
        public final Object getO() {
            return result;
        }

        @Override
        @Nullable
        public final Object[] getOa() {
            return newValue;
        }

        @Nonnull
        @Override
        public final Record withB(byte newValue) {
            return Record.valueOf(this.bool, newValue, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withBa(
            @Nonnull
            byte[][] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, newValue, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withBool(boolean newValue) {
            return Record.valueOf(newValue, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withBoola(
            @Nullable
            boolean[] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, newValue, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withC(char newValue) {
            return Record.valueOf(this.bool, this.b, newValue, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withCa(
            @Nonnull
            char[] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, newValue, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withD(double newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, newValue, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withDa(
            @Nonnull
            double[] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, newValue, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withF(float newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, newValue, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withFa(
            @Nonnull
            float[] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, newValue, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withI(int newValue) {
            return Record.valueOf(this.bool, this.b, this.c, newValue, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withIa(
            @Nonnull
            int[] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, newValue, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withL(long newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, newValue, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withLa(
            @Nonnull
            long[] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, newValue, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withO(
            @Nonnull
            Object newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, newValue, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Nonnull
        @Override
        public final Record withOa(
            @Nullable
            Object[] newValue) {
            return Record.valueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, newValue);
        }

        @Override
        public final boolean recordEquals(RecordAcceptor thatAcceptor) {
            return thatAcceptor.recordEqualsValueOf(this.bool, this.b, this.c, this.i, this.l, this.f, this.d, this.result, this.boola, this.ba, this.ca, this.ia, this.la, this.fa, this.da, this.newValue);
        }

        @Override
        public boolean recordEqualsValueOf(boolean bool, byte b, char c, int i, long l, float f, double d, Object result, boolean[] boola, byte[][] ba, char[] ca, int[] ia, long[] la, float[] fa, double[] da, Object[] newValue) {
            if (bool!= this.bool) {
                return false;
            }
            if (b!= this.b) {
                return false;
            }
            if (c!= this.c) {
                return false;
            }
            if (i!= this.i) {
                return false;
            }
            if (l!= this.l) {
                return false;
            }
            if (Math.abs((f -this.f))> 1.0E-6F) {
                return false;
            }
            if (d!= this.d) {
                return false;
            }
            if (!result.equals(this.result)) {
                return false;
            }
            if (boola == null) {
                if (this.boola!= null) {
                    return false;
                }
            } else {
                if (boola.length!= this.boola.length) {
                    return false;
                }
                for (int i1 = 0; (i1 <boola.length); i1 ++) {
                    if (boola[i1 ]!= this.boola[i1 ]) {
                        return false;
                    }
                }
            }
            if (ba.length!= this.ba.length) {
                return false;
            }
            for (int i1 = 0; (i1 <ba.length); i1 ++) {
                if (ba[i1 ] == null) {
                    if (this.ba[i1 ]!= null) {
                        return false;
                    }
                } else {
                    if (ba[i1 ].length!= this.ba[i1 ].length) {
                        return false;
                    }
                    for (int i2 = 0; (i2 <ba[i1 ].length); i2 ++) {
                        if (ba[i1 ][i2 ]!= this.ba[i1 ][i2 ]) {
                            return false;
                        }
                    }
                }
            }
            if (ca.length!= this.ca.length) {
                return false;
            }
            for (int i1 = 0; (i1 <ca.length); i1 ++) {
                if (ca[i1 ]!= this.ca[i1 ]) {
                    return false;
                }
            }
            if (ia.length!= this.ia.length) {
                return false;
            }
            for (int i1 = 0; (i1 <ia.length); i1 ++) {
                if (ia[i1 ]!= this.ia[i1 ]) {
                    return false;
                }
            }
            if (la.length!= this.la.length) {
                return false;
            }
            for (int i1 = 0; (i1 <la.length); i1 ++) {
                if (la[i1 ]!= this.la[i1 ]) {
                    return false;
                }
            }
            if (fa.length!= this.fa.length) {
                return false;
            }
            for (int i1 = 0; (i1 <fa.length); i1 ++) {
                if (Math.abs((fa[i1 ]-this.fa[i1 ]))> 1.0E-6F) {
                    return false;
                }
            }
            if (da.length!= this.da.length) {
                return false;
            }
            for (int i1 = 0; (i1 <da.length); i1 ++) {
                if (da[i1 ]!= this.da[i1 ]) {
                    return false;
                }
            }
            if (newValue == null) {
                return (this.newValue == null);
            } else {
                if (newValue.length!= this.newValue.length) {
                    return false;
                }
                for (int i1 = 0; (i1 <newValue.length); i1 ++) {
                    if (newValue[i1 ] == null) {
                        if (this.newValue[i1 ]!= null) {
                            return false;
                        }
                    } else {
                        if (!newValue[i1 ].equals(this.newValue[i1 ])) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }

        @Override
        public final int recordHashCode() {
            int result = 1;
            result = ((result* 49)+(this.bool? 0 : 1));
            result = ((result* 49)+ this.b);
            result = ((result* 49)+ this.c);
            result = ((result* 49)+ this.i);
            result = ((result* 49)+((int)(this.l^(this.l >>> 32))));
            result = ((result* 49)+ Float.floatToIntBits(this.f));
            result = ((result* 49)+((int)(Double.doubleToLongBits(this.d)^(Double.doubleToLongBits(this.d)>>> 32))));
            result = ((result* 49)+ this.result.hashCode());
            if (this.boola == null) {
                result = ((result* 49)+ 0);
            } else {
                for (int i = 0; (i<this.boola.length); i ++) {
                    result = ((result* 49)+(this.boola[i]? 0 : 1));
                }
            }
            for (int i = 0; (i<this.ba.length); i ++) {
                if (this.ba[i] == null) {
                    result = ((result* 49)+ 0);
                } else {
                    for (int i1 = 0; (i1 <this.ba[i].length); i1 ++) {
                        result = ((result* 49)+ this.ba[i][i1 ]);
                    }
                }
            }
            for (int i = 0; (i<this.ca.length); i ++) {
                result = ((result* 49)+ this.ca[i]);
            }
            for (int i = 0; (i<this.ia.length); i ++) {
                result = ((result* 49)+ this.ia[i]);
            }
            for (int i = 0; (i<this.la.length); i ++) {
                result = ((result* 49)+((int)(this.la[i]^(this.la[i]>>> 32))));
            }
            for (int i = 0; (i<this.fa.length); i ++) {
                result = ((result* 49)+ Float.floatToIntBits(this.fa[i]));
            }
            for (int i = 0; (i<this.da.length); i ++) {
                result = ((result* 49)+((int)(Double.doubleToLongBits(this.da[i])^(Double.doubleToLongBits(this.da[i])>>> 32))));
            }
            if (this.newValue == null) {
                result = ((result* 49)+ 0);
            } else {
                for (int i = 0; (i<this.newValue.length); i ++) {
                    if (this.newValue[i] == null) {
                        result = ((result* 49)+ 0);
                    } else {
                        result = ((result* 49)+ this.newValue[i].hashCode());
                    }
                }
            }
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Record.ValueOf{");
            result.append("bool = ");
            result.append(this.bool);
            result.append(", ");
            result.append("b = ");
            result.append(this.b);
            result.append(", ");
            result.append("c = ");
            result.append(this.c);
            result.append(", ");
            result.append("i = ");
            result.append(this.i);
            result.append(", ");
            result.append("l = ");
            result.append(this.l);
            result.append(", ");
            result.append("f = ");
            result.append(this.f);
            result.append(", ");
            result.append("d = ");
            result.append(this.d);
            result.append(", ");
            result.append("result = ");
            result.append(this.result);
            result.append(", ");
            result.append("boola = ");
            result.append(Arrays.toString(this.boola));
            result.append(", ");
            result.append("ba = ");
            result.append(Arrays.toString(this.ba));
            result.append(", ");
            result.append("ca = ");
            result.append(Arrays.toString(this.ca));
            result.append(", ");
            result.append("ia = ");
            result.append(Arrays.toString(this.ia));
            result.append(", ");
            result.append("la = ");
            result.append(Arrays.toString(this.la));
            result.append(", ");
            result.append("fa = ");
            result.append(Arrays.toString(this.fa));
            result.append(", ");
            result.append("da = ");
            result.append(Arrays.toString(this.da));
            result.append(", ");
            result.append("newValue = ");
            result.append(Arrays.toString(this.newValue));
            result.append("}");
            return result.toString();
        }
    }
}
