
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class Tree<T extends Object> {
    private final TreeAcceptor<T> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static TreeFactory FACTORY = new TreeFactory();

    private Tree(TreeAcceptor<T> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected Tree(
        @Nonnull
        Tree<T> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.Tree");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<T extends Object> Tree<T> leaf(
        @Nonnull
        T value) {
        if (value == null) {
            throw new NullPointerException("Argument shouldn't be null: 'value' argument in static method invocation: 'leaf' in class com.github.sviperll.adt4j.examples.Tree");
        }
        return new Tree<T>(new LeafCaseTreeAcceptor<T>(value));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static<T extends Object> Tree<T> node(
        @Nonnull
        List<? extends Tree<T>> subtrees) {
        if (subtrees == null) {
            throw new NullPointerException("Argument shouldn't be null: 'subtrees' argument in static method invocation: 'node' in class com.github.sviperll.adt4j.examples.Tree");
        }
        return new Tree<T>(new NodeCaseTreeAcceptor<T>(subtrees));
    }

    public final<R extends Object> R accept(TreeVisitor<T, Tree<T> , R> visitor) {
        return acceptor.accept(visitor);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof Tree)) {
                return false;
            } else {
                Tree<?> that = ((Tree<?> ) thatObject);
                return this.acceptor.treeEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.treeHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static<T extends Object> TreeVisitor<T, Tree<T> , Tree<T>> factory() {
        return FACTORY;
    }

    private static class LeafCaseTreeAcceptor<T extends Object>
        implements TreeAcceptor<T>
    {
        private final T value;

        LeafCaseTreeAcceptor(T value) {
            this.value = value;
        }

        @Override
        public<R extends Object> R accept(TreeVisitor<T, Tree<T> , R> visitor) {
            return visitor.leaf(this.value);
        }

        @Override
        public final boolean treeEquals(TreeAcceptor<?> thatAcceptor) {
            return thatAcceptor.treeEqualsLeaf(this.value);
        }

        @Override
        public boolean treeEqualsLeaf(Object value) {
            return value.equals(this.value);
        }

        @Override
        public boolean treeEqualsNode(List<? extends Tree<?>> subtrees) {
            return false;
        }

        @Override
        public final int treeHashCode() {
            int result = 1;
            result = ((result* 37)+ this.value.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Tree.Leaf{");
            result.append("value = ");
            result.append(this.value);
            result.append("}");
            return result.toString();
        }
    }

    private static class NodeCaseTreeAcceptor<T extends Object>
        implements TreeAcceptor<T>
    {
        private final List<? extends Tree<T>> subtrees;

        NodeCaseTreeAcceptor(List<? extends Tree<T>> subtrees) {
            this.subtrees = subtrees;
        }

        @Override
        public<R extends Object> R accept(TreeVisitor<T, Tree<T> , R> visitor) {
            return visitor.node(this.subtrees);
        }

        @Override
        public boolean treeEqualsLeaf(Object value) {
            return false;
        }

        @Override
        public final boolean treeEquals(TreeAcceptor<?> thatAcceptor) {
            return thatAcceptor.treeEqualsNode(this.subtrees);
        }

        @Override
        public boolean treeEqualsNode(List<? extends Tree<?>> subtrees) {
            return subtrees.equals(this.subtrees);
        }

        @Override
        public final int treeHashCode() {
            int result = 2;
            result = ((result* 37)+ this.subtrees.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Tree.Node{");
            result.append("subtrees = ");
            result.append(this.subtrees);
            result.append("}");
            return result.toString();
        }
    }

    private interface TreeAcceptor<T extends Object> {

        public<R extends Object> R accept(TreeVisitor<T, Tree<T> , R> visitor);

        public boolean treeEquals(TreeAcceptor<?> thatAcceptor);

        public boolean treeEqualsLeaf(Object value);

        public boolean treeEqualsNode(List<? extends Tree<?>> subtrees);

        public int treeHashCode();
    }

    private static class TreeFactory<T extends Object>
        implements TreeVisitor<T, Tree<T> , Tree<T>>
    {

        @Nonnull
        @Override
        public Tree<T> leaf(T value) {
            return Tree.<T> leaf(value);
        }

        @Nonnull
        @Override
        public Tree<T> node(List<? extends Tree<T>> subtrees) {
            return Tree.<T> node(subtrees);
        }
    }
}
