
package com.github.sviperll.adt4j.examples;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
public class User<E extends Object& Comparable<E>>
    implements Comparable<User<E>>
{
    private final UserAcceptor<E> acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static UserFactory FACTORY = new UserFactory();

    private User(UserAcceptor<E> acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected User(
        @Nonnull
        User<E> implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.User");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static<E extends Object& Comparable<E>> User<E> valueOf(
        @Nonnull
        UserKey key,
        @Nonnull
        ComparableList<E> list,
        @Nonnull
        String name,
        @Nonnull
        GroupName groupName) {
        if (key == null) {
            throw new NullPointerException("Argument shouldn't be null: 'key' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.User");
        }
        if (list == null) {
            throw new NullPointerException("Argument shouldn't be null: 'list' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.User");
        }
        if (name == null) {
            throw new NullPointerException("Argument shouldn't be null: 'name' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.User");
        }
        if (groupName == null) {
            throw new NullPointerException("Argument shouldn't be null: 'groupName' argument in static method invocation: 'valueOf' in class com.github.sviperll.adt4j.examples.User");
        }
        return new User<E>(new ValueOfCaseUserAcceptor<E>(key, list, name, groupName));
    }

    public final<R extends Object> R accept(UserVisitor<E, R> visitor) {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final GroupName groupName() {
        return this.acceptor.groupName();
    }

    @Nonnull
    public final UserKey key() {
        return this.acceptor.key();
    }

    @Nonnull
    public final ComparableList<E> list() {
        return this.acceptor.list();
    }

    @Nonnull
    public final String name() {
        return this.acceptor.name();
    }

    @Nonnull
    public final User<E> withGroupName(
        @Nonnull
        GroupName newValue) {
        return this.acceptor.withGroupName(newValue);
    }

    @Nonnull
    public final User<E> withName(
        @Nonnull
        String newValue) {
        return this.acceptor.withName(newValue);
    }

    @Override
    public final int compareTo(User<E> that) {
        return this.acceptor.userComapareTo(that.acceptor);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof User)) {
                return false;
            } else {
                User<?> that = ((User<?> ) thatObject);
                return this.acceptor.userEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.userHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static<E extends Object& Comparable<E>> UserVisitor<E, User<E>> factory() {
        return FACTORY;
    }

    private interface UserAcceptor<E extends Object& Comparable<E>> {

        public<R extends Object> R accept(UserVisitor<E, R> visitor);

        @Nonnull
        public GroupName groupName();

        @Nonnull
        public UserKey key();

        @Nonnull
        public ComparableList<E> list();

        @Nonnull
        public String name();

        @Nonnull
        public User<E> withGroupName(
            @Nonnull
            GroupName newValue);

        @Nonnull
        public User<E> withName(
            @Nonnull
            String newValue);

        public int userComapareTo(UserAcceptor<E> thatAcceptor);

        public int userComapareToValueOf(UserKey key, ComparableList<E> list, String name, GroupName groupName);

        public boolean userEquals(UserAcceptor<?> thatAcceptor);

        public boolean userEqualsValueOf(UserKey key, ComparableList<?> list, String name, GroupName groupName);

        public int userHashCode();
    }

    private static class UserFactory<E extends Object& Comparable<E>>
        implements UserVisitor<E, User<E>>
    {

        @Nonnull
        @Override
        public User<E> valueOf(UserKey key, ComparableList<E> list, String name, GroupName groupName) {
            return User.<E> valueOf(key, list, name, groupName);
        }
    }

    private static class ValueOfCaseUserAcceptor<E extends Object& Comparable<E>>
        implements UserAcceptor<E>
    {
        private final UserKey key;
        private final ComparableList<E> list;
        private final String name;
        private final GroupName groupName;

        ValueOfCaseUserAcceptor(UserKey key, ComparableList<E> list, String name, GroupName groupName) {
            this.key = key;
            this.list = list;
            this.name = name;
            this.groupName = groupName;
        }

        @Override
        public<R extends Object> R accept(UserVisitor<E, R> visitor) {
            return visitor.valueOf(this.key, this.list, this.name, this.groupName);
        }

        @Override
        @Nonnull
        public final GroupName groupName() {
            return groupName;
        }

        @Override
        @Nonnull
        public final UserKey key() {
            return key;
        }

        @Override
        @Nonnull
        public final ComparableList<E> list() {
            return list;
        }

        @Override
        @Nonnull
        public final String name() {
            return name;
        }

        @Nonnull
        @Override
        public final User<E> withGroupName(
            @Nonnull
            GroupName newValue) {
            return User.<E> valueOf(this.key, this.list, this.name, newValue);
        }

        @Nonnull
        @Override
        public final User<E> withName(
            @Nonnull
            String newValue) {
            return User.<E> valueOf(this.key, this.list, newValue, this.groupName);
        }

        @Override
        public final int userComapareTo(UserAcceptor<E> thatAcceptor) {
            return thatAcceptor.userComapareToValueOf(this.key, this.list, this.name, this.groupName);
        }

        @Override
        public int userComapareToValueOf(UserKey key, ComparableList<E> list, String name, GroupName groupName) {
            int result;
            result = key.compareTo(this.key);
            if (result!= 0) {
                return result;
            }
            result = list.compareTo(this.list);
            if (result!= 0) {
                return result;
            }
            result = name.compareTo(this.name);
            if (result!= 0) {
                return result;
            }
            result = groupName.compareTo(this.groupName);
            if (result!= 0) {
                return result;
            }
            return  0;
        }

        @Override
        public final boolean userEquals(UserAcceptor<?> thatAcceptor) {
            return thatAcceptor.userEqualsValueOf(this.key, this.list, this.name, this.groupName);
        }

        @Override
        public boolean userEqualsValueOf(UserKey key, ComparableList<?> list, String name, GroupName groupName) {
            if (!key.equals(this.key)) {
                return false;
            }
            if (!list.equals(this.list)) {
                return false;
            }
            if (!name.equals(this.name)) {
                return false;
            }
            return groupName.equals(this.groupName);
        }

        @Override
        public final int userHashCode() {
            int result = 1;
            result = ((result* 37)+ this.key.hashCode());
            result = ((result* 37)+ this.list.hashCode());
            result = ((result* 37)+ this.name.hashCode());
            result = ((result* 37)+ this.groupName.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("User.ValueOf{");
            result.append("key = ");
            result.append(this.key);
            result.append(", ");
            result.append("list = ");
            result.append(this.list);
            result.append(", ");
            result.append("name = ");
            result.append(this.name);
            result.append(", ");
            result.append("groupName = ");
            result.append(this.groupName);
            result.append("}");
            return result.toString();
        }
    }
}
