
package com.github.sviperll.adt4j.examples;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
public class UserKey
    implements Serializable, Comparable<UserKey>
{
    private final static long serialVersionUID = 1L;
    private final UserKeyAcceptor acceptor;
    private transient int hashCodeCachedValue;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static UserKeyFactory FACTORY = new UserKeyFactory();

    private UserKey(UserKeyAcceptor acceptor) {
        this.hashCodeCachedValue = acceptor.userKeyHashCode();
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected UserKey(
        @Nonnull
        UserKey implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.UserKey");
        }
        this.hashCodeCachedValue = implementation.hashCodeCachedValue;
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    public static UserKey valueOf(int key) {
        return new UserKey(new ValueOfCaseUserKeyAcceptor(key));
    }

    private void readObject(ObjectInputStream input)
        throws IOException, ClassNotFoundException
    {
        input.defaultReadObject();
        this.hashCodeCachedValue = this.acceptor.userKeyHashCode();
    }

    public final<R extends Object> R accept(UserKeyVisitor<R> visitor) {
        return acceptor.accept(visitor);
    }

    @Override
    public final int compareTo(UserKey that) {
        return this.acceptor.userKeyComapareTo(that.acceptor);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof UserKey)) {
                return false;
            } else {
                UserKey that = ((UserKey) thatObject);
                return ((this.hashCodeCachedValue == that.hashCodeCachedValue)&&this.acceptor.userKeyEquals(that.acceptor));
            }
        }
    }

    @Override
    public final int hashCode() {
        return hashCodeCachedValue;
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static UserKeyVisitor<UserKey> factory() {
        return FACTORY;
    }

    private interface UserKeyAcceptor
        extends Serializable
    {

        public<R extends Object> R accept(UserKeyVisitor<R> visitor);

        public int userKeyComapareTo(UserKeyAcceptor thatAcceptor);

        public int userKeyComapareToValueOf(int key);

        public boolean userKeyEquals(UserKeyAcceptor thatAcceptor);

        public boolean userKeyEqualsValueOf(int key);

        public int userKeyHashCode();
    }

    private static class UserKeyFactory
        implements UserKeyVisitor<UserKey>
    {

        @Nonnull
        @Override
        public UserKey valueOf(int key) {
            return UserKey.valueOf(key);
        }
    }

    private static class ValueOfCaseUserKeyAcceptor
        implements Serializable, UserKeyAcceptor
    {
        private final static long serialVersionUID = 1L;
        private final int key;

        ValueOfCaseUserKeyAcceptor(int key) {
            this.key = key;
        }

        @Override
        public<R extends Object> R accept(UserKeyVisitor<R> visitor) {
            return visitor.valueOf(this.key);
        }

        @Override
        public final int userKeyComapareTo(UserKeyAcceptor thatAcceptor) {
            return thatAcceptor.userKeyComapareToValueOf(this.key);
        }

        @Override
        public int userKeyComapareToValueOf(int key) {
            int result;
            result = ((key == this.key)? 0 :((key<this.key)?-1 : 1));
            if (result!= 0) {
                return result;
            }
            return  0;
        }

        @Override
        public final boolean userKeyEquals(UserKeyAcceptor thatAcceptor) {
            return thatAcceptor.userKeyEqualsValueOf(this.key);
        }

        @Override
        public boolean userKeyEqualsValueOf(int key) {
            return (key == this.key);
        }

        @Override
        public final int userKeyHashCode() {
            int result = 1;
            result = ((result* 37)+ this.key);
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("UserKey.ValueOf{");
            result.append("key = ");
            result.append(this.key);
            result.append("}");
            return result.toString();
        }
    }
}
