
package com.github.sviperll.adt4j.examples;

import java.util.Arrays;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
class VarArgContainer {
    private final VarArgContainerAcceptor acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static VarArgContainerFactory FACTORY = new VarArgContainerFactory();

    private VarArgContainer(VarArgContainerAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected VarArgContainer(
        @Nonnull
        VarArgContainer implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.github.sviperll.adt4j.examples.VarArgContainer");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    static VarArgContainer of(int a, @Nonnull
        String... bs) {
        if (bs == null) {
            throw new NullPointerException("Argument shouldn't be null: 'bs' argument in static method invocation: 'of' in class com.github.sviperll.adt4j.examples.VarArgContainer");
        }
        return new VarArgContainer(new OfCaseVarArgContainerAcceptor(a, bs));
    }

    public final<R extends Object> R accept(VarArgContainerVisitor<R> visitor) {
        return acceptor.accept(visitor);
    }

    @Nonnull
    public final String[] bs() {
        return this.acceptor.bs();
    }

    @Nonnull
    public final VarArgContainer bs(@Nonnull
        String... newValue) {
        return this.acceptor.bs(newValue);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof VarArgContainer)) {
                return false;
            } else {
                VarArgContainer that = ((VarArgContainer) thatObject);
                return this.acceptor.varArgContainerEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.varArgContainerHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    static VarArgContainerVisitor<VarArgContainer> factory() {
        return FACTORY;
    }

    private static class OfCaseVarArgContainerAcceptor
        implements VarArgContainerAcceptor
    {
        private final int a;
        private final String[] bs;

        OfCaseVarArgContainerAcceptor(int a, String... bs) {
            this.a = a;
            this.bs = bs;
        }

        @Override
        public<R extends Object> R accept(VarArgContainerVisitor<R> visitor) {
            return visitor.of(this.a, this.bs);
        }

        @Override
        @Nonnull
        public final String[] bs() {
            return bs;
        }

        @Nonnull
        @Override
        public final VarArgContainer bs(@Nonnull
            String... newValue) {
            return VarArgContainer.of(this.a, newValue);
        }

        @Override
        public final boolean varArgContainerEquals(VarArgContainerAcceptor thatAcceptor) {
            return thatAcceptor.varArgContainerEqualsOf(this.a, this.bs);
        }

        @Override
        public boolean varArgContainerEqualsOf(int a, String... bs) {
            if (a!= this.a) {
                return false;
            }
            if (bs.length!= this.bs.length) {
                return false;
            }
            for (int i = 0; (i<bs.length); i ++) {
                if (bs[i] == null) {
                    if (this.bs[i]!= null) {
                        return false;
                    }
                } else {
                    if (!bs[i].equals(this.bs[i])) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public final int varArgContainerHashCode() {
            int result = 1;
            result = ((result* 37)+ this.a);
            for (int i = 0; (i<this.bs.length); i ++) {
                if (this.bs[i] == null) {
                    result = ((result* 37)+ 0);
                } else {
                    result = ((result* 37)+ this.bs[i].hashCode());
                }
            }
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VarArgContainer.Of{");
            result.append("a = ");
            result.append(this.a);
            result.append(", ");
            result.append("bs = ");
            result.append(Arrays.toString(this.bs));
            result.append("}");
            return result.toString();
        }
    }

    private interface VarArgContainerAcceptor {

        public<R extends Object> R accept(VarArgContainerVisitor<R> visitor);

        @Nonnull
        public String[] bs();

        @Nonnull
        public VarArgContainer bs(@Nonnull
            String... newValue);

        public boolean varArgContainerEquals(VarArgContainerAcceptor thatAcceptor);

        public boolean varArgContainerEqualsOf(int a, String... bs);

        public int varArgContainerHashCode();
    }

    private static class VarArgContainerFactory
        implements VarArgContainerVisitor<VarArgContainer>
    {

        @Nonnull
        @Override
        public VarArgContainer of(int a, String... bs) {
            return VarArgContainer.of(a, bs);
        }
    }
}
