/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.annotation.processor;

import com.github.tadukoo.annotation.processor.AnnotationUtil;
import com.github.tadukoo.util.ExceptionUtil;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor {
    protected AnnotationUtil annotationUtil;
    private final Class<? extends Annotation> annotation;

    public AbstractAnnotationProcessor(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    @Override
    public final void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.annotationUtil = new AnnotationUtil(processingEnvironment);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add(this.annotation.getCanonicalName());
        return annotations;
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                try {
                    this.processElements(roundEnv.getElementsAnnotatedWith(typeElement));
                }
                catch (Throwable t) {
                    String error = "Failed to process annotation " + this.annotation.getCanonicalName() + ":\n";
                    error = error + ExceptionUtil.getStackTraceAsString((Throwable)t);
                    this.annotationUtil.displayCompileError(typeElement, error);
                }
            }
        }
        return true;
    }

    protected abstract void processElements(Set<? extends Element> var1) throws Throwable;
}

