/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.annotation.processor;

import com.github.tadukoo.annotation.processor.AbstractAnnotationProcessor;
import com.github.tadukoo.annotation.processor.AnnotationProcessor;
import com.github.tadukoo.util.FileUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.lang.model.element.Element;

public class AnnotationProcessorProcessor
extends AbstractAnnotationProcessor {
    public AnnotationProcessorProcessor() {
        super(AnnotationProcessor.class);
    }

    @Override
    protected void processElements(Set<? extends Element> elements) throws Throwable {
        HashSet<String> processors;
        String filename = "META-INF/services/javax.annotation.processing.Processor";
        try {
            processors = new HashSet(FileUtil.getLinesAsList((Reader)this.annotationUtil.getFileReader(filename)));
        }
        catch (IOException e) {
            processors = new HashSet<String>();
        }
        for (Element element : elements) {
            if (this.annotationUtil.isSubType(element, AbstractProcessor.class)) {
                processors.add(this.annotationUtil.getCanonicalClassName(element));
                continue;
            }
            this.annotationUtil.displayCompileError(element, "This class must be a sub-class of AbstractProcessor!");
        }
        FileUtil.writeFile((Writer)this.annotationUtil.getFileWriter(filename), processors);
    }
}

