/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.annotation.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class AnnotationUtil {
    public static final String ANNOTATION_PROCESSOR_FILE = "META-INF/services/javax.annotation.processing.Processor";
    private final Elements elementUtil;
    private final Types typeUtil;
    private final Messager messager;
    private final Filer filer;

    public AnnotationUtil(ProcessingEnvironment processingEnv) {
        this.elementUtil = processingEnv.getElementUtils();
        this.typeUtil = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    public String getCanonicalClassName(Element element) {
        return this.getTypeElement(element).getQualifiedName().toString();
    }

    public TypeElement getTypeElement(CharSequence canonicalClassName) {
        return this.elementUtil.getTypeElement(canonicalClassName);
    }

    public TypeElement getTypeElement(Element element) {
        if (element instanceof TypeElement) {
            return (TypeElement)element;
        }
        return null;
    }

    public TypeElement getTypeElement(Class<?> clazz) {
        return this.getTypeElement(clazz.getCanonicalName());
    }

    public TypeMirror getType(TypeElement typeElement) {
        if (typeElement == null) {
            return null;
        }
        return typeElement.asType();
    }

    public TypeMirror getType(Element element) {
        return this.getType(this.getTypeElement(element));
    }

    public TypeMirror getType(Class<?> clazz) {
        return this.getType(this.getTypeElement(clazz));
    }

    public boolean isSubType(Element element, Class<?> clazz) {
        TypeMirror elementType = this.getType(element);
        TypeMirror clazzType = this.getType(clazz);
        return this.typeUtil.isSubtype(elementType, clazzType);
    }

    public void displayCompileWarning(Element element, String warning) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, warning, element);
    }

    public void displayCompileError(Element element, String error) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, error, element);
    }

    public FileObject createFile(String filename) throws IOException {
        return this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", filename, new Element[0]);
    }

    public FileObject getExistingFile(String filename) throws IOException {
        return this.filer.getResource(StandardLocation.SOURCE_OUTPUT, "", filename);
    }

    public Reader getFileReader(String filename) throws IOException {
        FileObject file = this.getExistingFile(filename);
        return file.openReader(true);
    }

    public Writer getFileWriter(String filename) throws IOException {
        FileObject file = this.createFile(filename);
        return file.openWriter();
    }
}

