/*
 * Decompiled with CFR 0.152.
 */
package com.github.takezoe.retry;

import com.github.takezoe.retry.CircuitBreakerContext;
import com.github.takezoe.retry.CircuitBreakerPolicy;
import com.github.takezoe.retry.CircuitBreakerPolicy$Open$;
import com.github.takezoe.retry.FailureInfo;
import com.github.takezoe.retry.RetryContext;
import com.github.takezoe.retry.RetryManager;
import com.github.takezoe.retry.RetryPolicy;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public <T> T retry(Function0<T> f, RetryPolicy policy) {
        int count = 0;
        while (true) {
            try {
                return (T)f.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    if (count == policy.maxAttempts()) {
                        policy.onFailure().apply((Object)new RetryContext(count + 1, e));
                        throw e;
                    }
                    policy.onRetry().apply((Object)new RetryContext(count + 1, e));
                    Thread.sleep(policy.backOff().nextDuration(++count, policy.retryDuration().toMillis()) + this.jitter(policy.jitter().toMillis()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
            break;
        }
    }

    public <T> Either<Throwable, T> retryAsEither(Function0<T> f, RetryPolicy policy) {
        Right right;
        try {
            T result = this.retry(f, policy);
            right = scala.package$.MODULE$.Right().apply(result);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = scala.package$.MODULE$.Left().apply((Object)e);
            right = left;
        }
        return right;
    }

    public <T> Try<T> retryBlockingAsTry(Function0<T> f, RetryPolicy policy) {
        Success success;
        try {
            T result = this.retry(f, policy);
            success = new Success(result);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Failure failure = new Failure(e);
            success = failure;
        }
        return success;
    }

    public <T> Future<T> retryFuture(Function0<Future<T>> f, RetryPolicy policy, RetryManager retryManager, ExecutionContext ec) {
        Future future = (Future)f.apply();
        return policy.maxAttempts() > 0 ? future.recoverWith((PartialFunction)new Serializable(retryManager, f, policy, ec){
            public static final long serialVersionUID = 0L;
            private final RetryManager retryManager$1;
            private final Function0 f$1;
            private final RetryPolicy policy$1;
            private final ExecutionContext ec$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Future<T> future = this.retryManager$1.scheduleFuture(this.f$1, this.policy$1, this.ec$1);
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.retryManager$1 = retryManager$1;
                this.f$1 = f$1;
                this.policy$1 = policy$1;
                this.ec$1 = ec$1;
            }
        }, ec) : future;
    }

    public long jitter(long maxMills) {
        return maxMills == 0L ? 0L : (long)(ThreadLocalRandom.current().nextDouble() * (double)maxMills);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> T circuitBreaker(Function0<T> f, CircuitBreakerPolicy policy) {
        Object object;
        CircuitBreakerContext circuitBreakerContext = policy.getContext();
        if (circuitBreakerContext != null) {
            Some some;
            FailureInfo failureInfo;
            CircuitBreakerPolicy.State state = circuitBreakerContext.state();
            Option<FailureInfo> option = circuitBreakerContext.lastFailure();
            if (CircuitBreakerPolicy$Open$.MODULE$.equals(state) && option instanceof Some && (failureInfo = (FailureInfo)(some = (Some)option).value()) != null) {
                long lastFailureTimeMillis = failureInfo.timestampMillis();
                Throwable lastException = failureInfo.exception();
                if (System.currentTimeMillis() - lastFailureTimeMillis < policy.retryDuration().toMillis()) throw lastException;
                object = package$.run$1(f, policy);
                return (T)object;
            }
        }
        object = package$.run$1(f, policy);
        return (T)object;
    }

    public <T> Either<Throwable, T> circuitBreakerAsEither(Function0<T> f, CircuitBreakerPolicy policy) {
        Right right;
        try {
            T result = this.circuitBreaker(f, policy);
            right = scala.package$.MODULE$.Right().apply(result);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = scala.package$.MODULE$.Left().apply((Object)e);
            right = left;
        }
        return right;
    }

    public <T> Try<T> circuitBreakerAsTry(Function0<T> f, CircuitBreakerPolicy policy) {
        Success success;
        try {
            T result = this.circuitBreaker(f, policy);
            success = new Success(result);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Failure failure = new Failure(e);
            success = failure;
        }
        return success;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object run$1(Function0 f$2, CircuitBreakerPolicy policy$2) {
        void v0;
        try {
            void var3_2;
            Object result = f$2.apply();
            policy$2.succeeded();
            v0 = var3_2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                policy$2.failed(e);
                throw e;
            }
            throw throwable;
        }
        return v0;
    }

    private package$() {
        MODULE$ = this;
    }
}

