/*
 * Decompiled with CFR 0.152.
 */
package com.github.takezoe.solr.scala.async;

import com.github.takezoe.solr.scala.async.AbstractAsyncQueryBuilder;
import com.github.takezoe.solr.scala.async.AsyncUtils;
import com.github.takezoe.solr.scala.query.ExpressionParser;
import java.io.IOException;
import java.io.Serializable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.StreamingBinaryResponseParser;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u0006\r\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A!\u0007\u0001BC\u0002\u0013E1\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u0003'\u0011!)\u0004A!A!\u0002\u00171\u0004\"B\u001e\u0001\t\u0003a\u0004\"B\"\u0001\t#!\u0005\"\u00021\u0001\t#\t\u0007\"\u0002\u001a\u0001\t#\u0011\u0007bBA\u0003\u0001\u0011E\u0011q\u0001\u0002\u0012\u0003NLhnY)vKJL()^5mI\u0016\u0014(BA\u0007\u000f\u0003\u0015\t7/\u001f8d\u0015\ty\u0001#A\u0003tG\u0006d\u0017M\u0003\u0002\u0012%\u0005!1o\u001c7s\u0015\t\u0019B#A\u0004uC.,'p\\3\u000b\u0005U1\u0012AB4ji\",(MC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c95\tA\"\u0003\u0002\u001e\u0019\tI\u0012IY:ue\u0006\u001cG/Q:z]\u000e\fV/\u001a:z\u0005VLG\u000eZ3s\u0003)AG\u000f\u001e9DY&,g\u000e\u001e\t\u0003A\rj\u0011!\t\u0006\u0002E\u00059qn\u001b5uiB\u001c\u0014B\u0001\u0013\"\u00051y5\u000e\u0013;ua\u000ec\u0017.\u001a8u\u0003\r)(\u000f\u001c\t\u0003O=r!\u0001K\u0017\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-B\u0012A\u0002\u001fs_>$hHC\u0001\u0010\u0013\tqC&\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018-\u0003\u0015\tX/\u001a:z+\u00051\u0013AB9vKJL\b%\u0001\u0004qCJ\u001cXM\u001d\t\u0003oej\u0011\u0001\u000f\u0006\u0003e9I!A\u000f\u001d\u0003!\u0015C\bO]3tg&|g\u000eU1sg\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003>\u0001\u0006\u0013EC\u0001 @!\tY\u0002\u0001C\u00036\r\u0001\u000fa\u0007C\u0003\u001f\r\u0001\u0007q\u0004C\u0003&\r\u0001\u0007a\u0005C\u00033\r\u0001\u0007a%\u0001\bde\u0016\fG/\u001a$pe6\u0014u\u000eZ=\u0015\u0007\u0015Cu\u000b\u0005\u0002!\r&\u0011q)\t\u0002\t\r>\u0014XNQ8es\")\u0011j\u0002a\u0001\u0015\u0006I1o\u001c7s#V,'/\u001f\t\u0003\u0017Vk\u0011\u0001\u0014\u0006\u0003\u001b:\u000ba\u0001]1sC6\u001c(BA(Q\u0003\u0019\u0019w.\\7p]*\u0011\u0011#\u0015\u0006\u0003%N\u000ba!\u00199bG\",'\"\u0001+\u0002\u0007=\u0014x-\u0003\u0002W\u0019\nQ1k\u001c7s!\u0006\u0014\u0018-\\:\t\u000bU:\u0001\u0019\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016!B:pYJT'BA/Q\u0003\u0019\u0019G.[3oi&\u0011qL\u0017\u0002\u000f%\u0016\u001c\bo\u001c8tKB\u000b'o]3s\u0003)\u0019'/Z1uK\u000e{\u0007/_\u000b\u0002}U\u00111\r\u001c\u000b\u0004IZ<\bcA3iU6\taM\u0003\u0002hY\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005%4'A\u0002$viV\u0014X\r\u0005\u0002lY2\u0001A!B7\n\u0005\u0004q'!\u0001+\u0012\u0005=\u001c\bC\u00019r\u001b\u0005a\u0013B\u0001:-\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u001d;\n\u0005Ud#aA!os\")\u0011*\u0003a\u0001\u0015\")\u00010\u0003a\u0001s\u000691/^2dKN\u001c\b\u0003\u00029{y*L!a\u001f\u0017\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA?\u0002\u00025\taP\u0003\u0002\u00005\u0006A!/Z:q_:\u001cX-C\u0002\u0002\u0004y\u0014Q\"U;fef\u0014Vm\u001d9p]N,\u0017AB:ue\u0016\fW\u000e\u0006\u0004\u0002\n\u0005u\u0011q\u0004\u000b\u0005\u0003\u0017\t\u0019\u0002\u0005\u0003fQ\u00065\u0001c\u00019\u0002\u0010%\u0019\u0011\u0011\u0003\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+Q\u00019AA\f\u0003\t)7\rE\u0002f\u00033I1!a\u0007g\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003J\u0015\u0001\u0007!\nC\u0004\u0002\")\u0001\r!a\t\u0002\u0005\r\u0014\u0007cA-\u0002&%\u0019\u0011q\u0005.\u00033M#(/Z1nS:<'+Z:q_:\u001cXmQ1mY\n\f7m\u001b")
public class AsyncQueryBuilder
extends AbstractAsyncQueryBuilder {
    private final OkHttpClient httpClient;
    private final String url;
    private final String query;
    private final ExpressionParser parser;

    public String query() {
        return this.query;
    }

    public FormBody createFormBody(SolrParams solrQuery, ResponseParser parser) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(solrQuery.getParameterNamesIterator()).asScala()).foreach((Function1 & Serializable)name -> formBuilder.add(name, solrQuery.get(name)));
        formBuilder.add("wt", parser.getWriterType());
        formBuilder.add("version", parser.getVersion());
        return formBuilder.build();
    }

    @Override
    public AsyncQueryBuilder createCopy() {
        return new AsyncQueryBuilder(this.httpClient, this.url, this.query(), this.parser);
    }

    @Override
    public <T> Future<T> query(SolrParams solrQuery, Function1<QueryResponse, T> success) {
        Promise promise = Promise$.MODULE$.apply();
        XMLResponseParser parser = new XMLResponseParser();
        Request.Builder builder = new Request.Builder().url(new StringBuilder(7).append(this.url).append("/select").toString()).post((RequestBody)this.createFormBody(solrQuery, (ResponseParser)parser));
        this.httpClient.newCall(builder.build()).enqueue(new AsyncUtils.CallbackHandler(this.httpClient, promise, (Function1 & Serializable)response -> {
            NamedList namedList = parser.processResponse(response.body().byteStream(), "UTF-8");
            QueryResponse queryResponse = new QueryResponse();
            queryResponse.setResponse(namedList);
            return success.apply((Object)queryResponse);
        }));
        return promise.future();
    }

    @Override
    public Future<BoxedUnit> stream(SolrParams solrQuery, StreamingResponseCallback cb, ExecutionContext ec) {
        Promise promise = Promise$.MODULE$.apply();
        StreamingBinaryResponseParser parser = new StreamingBinaryResponseParser(cb);
        Request.Builder builder = new Request.Builder().url(new StringBuilder(7).append(this.url).append("/select").toString()).post((RequestBody)this.createFormBody(solrQuery, (ResponseParser)parser));
        this.httpClient.newCall(builder.build()).enqueue(new Callback(null, promise, parser){
            private final Promise promise$1;
            private final StreamingBinaryResponseParser parser$2;

            public void onFailure(Call call, IOException e) {
                this.promise$1.failure((Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                try {
                    NamedList namedList = this.parser$2.processResponse(response.body().byteStream(), "UTF-8");
                    QueryResponse queryResponse = new QueryResponse();
                    queryResponse.setResponse(namedList);
                    this.promise$1.success((Object)BoxedUnit.UNIT);
                }
                finally {
                    response.close();
                }
            }
            {
                this.promise$1 = promise$1;
                this.parser$2 = parser$2;
            }
        });
        return promise.future();
    }

    public AsyncQueryBuilder(OkHttpClient httpClient, String url, String query, ExpressionParser parser) {
        this.httpClient = httpClient;
        this.url = url;
        this.query = query;
        this.parser = parser;
        super(query, parser);
    }
}

