/*
 * Decompiled with CFR 0.152.
 */
package com.github.takezoe.solr.scala.query;

import com.github.takezoe.solr.scala.query.AST;
import com.github.takezoe.solr.scala.query.ASTAnd;
import com.github.takezoe.solr.scala.query.ASTNot;
import com.github.takezoe.solr.scala.query.ASTOr;
import com.github.takezoe.solr.scala.query.ASTPhrase;
import com.github.takezoe.solr.scala.query.ASTWord;
import com.github.takezoe.solr.scala.query.ExpressionParseException;
import com.github.takezoe.solr.scala.query.ExpressionParser;
import com.github.takezoe.solr.scala.query.QueryUtils$;
import scala.MatchError;

public final class ExpressionParser$ {
    public static final ExpressionParser$ MODULE$ = new ExpressionParser$();

    public String parse(String str, ExpressionParser parser) {
        String string;
        try {
            string = new StringBuilder(2).append("(").append(this.visit(parser.parse(new StringBuilder(2).append("(").append(this.normalize(str)).append(")").toString()))).append(")").toString();
        }
        catch (Throwable e) {
            throw new ExpressionParseException(e);
        }
        return string;
    }

    private String normalize(String str) {
        return str.replaceAll("\u3000", " ");
    }

    private String visit(AST ast) {
        String string;
        AST aST = ast;
        if (aST instanceof ASTAnd) {
            ASTAnd aSTAnd = (ASTAnd)aST;
            string = new StringBuilder(7).append("(").append(this.visit(aSTAnd.left())).append(" AND ").append(this.visit(aSTAnd.right())).append(")").toString();
        } else if (aST instanceof ASTOr) {
            ASTOr aSTOr = (ASTOr)aST;
            string = new StringBuilder(6).append("(").append(this.visit(aSTOr.left())).append(" OR ").append(this.visit(aSTOr.right())).append(")").toString();
        } else if (aST instanceof ASTNot) {
            ASTNot aSTNot = (ASTNot)aST;
            string = new StringBuilder(6).append("NOT (").append(this.visit(aSTNot.expr())).append(")").toString();
        } else if (aST instanceof ASTPhrase) {
            ASTPhrase aSTPhrase = (ASTPhrase)aST;
            string = new StringBuilder(2).append("\"").append(QueryUtils$.MODULE$.escape(aSTPhrase.value())).append("\"").toString();
        } else if (aST instanceof ASTWord) {
            ASTWord aSTWord = (ASTWord)aST;
            string = QueryUtils$.MODULE$.escape(aSTWord.value());
        } else {
            throw new MatchError((Object)aST);
        }
        return string;
    }

    private ExpressionParser$() {
    }
}

