/*
 * Decompiled with CFR 0.152.
 */
package com.github.taniqng.eventbus;

import com.github.taniqng.eventbus.api.DisEvent;
import com.github.taniqng.eventbus.core.Destinations;
import com.github.taniqng.eventbus.core.JsonUtils;
import com.github.taniqng.eventbus.core.PropertiesLoaderForBus;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DisEventBus {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RabbitTemplate rabbitTemplate;

    protected <T> void publishEvent(Class<? extends DisEvent<T>> eventClass, Object event) {
        try {
            Object evn = event;
            this.publish(eventClass, evn);
        }
        catch (ClassCastException e1) {
            this.logger.error("{}\u7c7b\u578b\u9700\u4f20\u5165\u7684\u6570\u636e\u4e0d\u7b26", (Object)eventClass.getName());
        }
    }

    public <T> void publish(Class<? extends DisEvent<T>> eventClass, T event) {
        try {
            DisEvent<T> ev = eventClass.newInstance();
            ev.setAppId(this.getAppId());
            ev.setEventCode("");
            ev.setSourceIp(this.getIpAddr());
            ev.setEventFlow(UUID.randomUUID().toString());
            ev.setData(event);
            this.rabbitTemplate.convertAndSend(Destinations.DEST_TANIQNG_FANOUT_EVENTBUS.getExchange(), Destinations.DEST_TANIQNG_FANOUT_EVENTBUS.getRoutingKey(), (Object)JsonUtils.writeObject(ev));
        }
        catch (Exception e) {
            this.logger.error("\u4e0d\u80fd\u521b\u5efa\u4e8b\u4ef6\u5b9e\u4f8b\uff0c\u731c\u6d4b{}\u6ca1\u6709\u63d0\u4f9b\u9ed8\u8ba4\u65e0\u53c2\u6784\u9020\u5668.", (Object)eventClass.getSimpleName());
        }
    }

    private String getIpAddr() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getAppId() {
        String appName = PropertiesLoaderForBus.getProperty("spring.application.name");
        if (StringUtils.isEmpty((Object)appName)) {
            throw new RuntimeException("\u672a\u627e\u5230properties \"spring.application.name\"");
        }
        return appName;
    }
}

