/*
 * Decompiled with CFR 0.152.
 */
package com.github.taniqng.eventbus;

import com.github.taniqng.eventbus.DisEventBus;
import com.github.taniqng.eventbus.SendEvent;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EventAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DisEventBus bus;

    @Pointcut(value="@annotation(com.github.taniqng.eventbus.SendEvent)")
    public void eventPointcut() {
    }

    @Around(value="eventPointcut()")
    public Object doArround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object obj = joinPoint.proceed();
        if (obj != null) {
            Method m = ((MethodSignature)joinPoint.getSignature()).getMethod();
            SendEvent eventAnn = (SendEvent)AnnotationUtils.findAnnotation((Method)m, SendEvent.class);
            this.logger.debug("\u53d1\u5e03\u4e8b\u4ef6:{}, ", (Object)eventAnn.value().getSimpleName());
            this.bus.publishEvent(eventAnn.value(), obj);
        }
        return obj;
    }
}

