/*
 * Decompiled with CFR 0.152.
 */
package com.github.taniqng.eventbus.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class EntityUtils {
    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getFirstSuperInterfaceGenricType(Class<?> clazz, int index) {
        Type[] genTypes = clazz.getGenericInterfaces();
        if (genTypes == null || genTypes.length == 0) {
            return Object.class;
        }
        Type genType = genTypes[0];
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getSuperClassGenricType(Type genType, int index) {
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, String fieldName, Class<T> annotation) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            return f.getAnnotation(annotation);
        }
        catch (NoSuchFieldException | SecurityException e) {
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz != null && !superClazz.equals(Object.class)) {
                return EntityUtils.findAnnotation(superClazz, fieldName, annotation);
            }
            return null;
        }
    }

    public static <A extends Annotation> Field findFirstField(Class<?> clazz, Class<A> annotation) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                if (f.getAnnotation(annotation) != null) {
                    return f;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            ++n2;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && !superClazz.equals(Object.class)) {
            return EntityUtils.findFirstField(superClazz, annotation);
        }
        return null;
    }
}

