/*
 * Decompiled with CFR 0.152.
 */
package com.github.taniqng.eventbus.core;

import com.github.taniqng.eventbus.EventCode;
import com.github.taniqng.eventbus.EventHandler;
import com.github.taniqng.eventbus.core.Destinations;
import com.github.taniqng.eventbus.core.EventListener;
import com.github.taniqng.eventbus.core.EventQueueGenerator;
import com.github.taniqng.eventbus.helper.MQResourceRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.springframework.amqp.rabbit.annotation.RabbitListenerConfigurer;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MultiMethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistrar;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Component
public class EventListenerPostProcessor
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
BeanClassLoaderAware,
EnvironmentAware,
SmartInitializingSingleton {
    public static final String DEFAULT_RABBIT_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "rabbitListenerContainerFactory";
    public static final String RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY = "spring.rabbitmq.emptyStringArguments";
    private static final ConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private final Set<String> emptyStringArguments = new HashSet<String>();
    private RabbitListenerEndpointRegistry endpointRegistry;
    private String containerFactoryBeanName = "rabbitListenerContainerFactory";
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;
    private final RabbitHandlerMethodFactoryAdapter messageHandlerMethodFactory = new RabbitHandlerMethodFactoryAdapter();
    private final RabbitListenerEndpointRegistrar registrar = new RabbitListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;
    @Autowired
    private MQResourceRegistry mqRegistry;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public EventListenerPostProcessor() {
        this.emptyStringArguments.add("x-dead-letter-exchange");
    }

    public void setEndpointRegistry(RabbitListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        String property = (String)environment.getProperty(RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY, String.class);
        if (property != null) {
            this.emptyStringArguments.addAll(StringUtils.commaDelimitedListToSet((String)property));
        }
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RabbitListenerConfigurer.class);
            for (RabbitListenerConfigurer configurer : instances.values()) {
                configurer.configureRabbitListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (RabbitListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.amqp.rabbit.config.internalRabbitListenerEndpointRegistry", RabbitListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        List<Method> handlers;
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (bean instanceof EventListener && (handlers = this.retrieveHandlers(targetClass)).size() > 0) {
            this.processMultiMethodListeners(handlers.toArray(new Method[handlers.size()]), bean, beanName);
        }
        return bean;
    }

    private List<Method> retrieveHandlers(Class<?> targetClass) {
        if (!EventListener.class.isAssignableFrom(targetClass)) {
            return Collections.emptyList();
        }
        final ArrayList<Method> multiMethods = new ArrayList<Method>();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                EventHandler taskHandler = (EventHandler)AnnotationUtils.findAnnotation((Method)method, EventHandler.class);
                if (taskHandler != null) {
                    multiMethods.add(method);
                }
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return multiMethods;
    }

    private void processMultiMethodListeners(Method[] multiMethods, Object bean, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        Method[] methodArray = multiMethods;
        int n = multiMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            checkedMethods.add(this.checkProxy(method, bean));
            ++n2;
        }
        MultiMethodRabbitListenerEndpoint endpoint = new MultiMethodRabbitListenerEndpoint(checkedMethods, bean);
        endpoint.setBeanFactory(this.beanFactory);
        this.processListener((MethodRabbitListenerEndpoint)endpoint, bean, bean.getClass(), beanName);
    }

    protected void processAmqpListener(Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodRabbitListenerEndpoint endpoint = new MethodRabbitListenerEndpoint();
        endpoint.setMethod(methodToUse);
        endpoint.setBeanFactory(this.beanFactory);
        this.processListener(endpoint, bean, methodToUse, beanName);
    }

    private Method checkProxy(Method method, Object bean) {
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                Class[] classArray = proxiedInterfaces = ((Advised)bean).getProxiedInterfaces();
                int n = proxiedInterfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class iface = classArray[n2];
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        ++n2;
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@RabbitListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
            }
        }
        return method;
    }

    protected void processListener(MethodRabbitListenerEndpoint endpoint, Object bean, Object adminTarget, String beanName) {
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndPointId());
        endpoint.setQueueNames(this.resolveQueue(bean));
        endpoint.setExclusive(false);
        this.registrar.registerEndpoint((RabbitListenerEndpoint)endpoint, null);
    }

    private String[] resolveQueue(Object bean) {
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        EventCode taskCode = (EventCode)AnnotationUtils.findAnnotation((Class)beanClass, EventCode.class);
        if (taskCode == null || taskCode.value().length < 1) {
            throw new IllegalArgumentException("\u8bf7\u81f3\u5c11\u4e3alistener\u5206\u914d\u4e00\u4e2a\u53ef\u4ee5\u6267\u884c\u7684\u4efb\u52a1\u7c7b\u578b\u3010" + beanClass.getSimpleName() + "\u3011, see @EventCode annotation");
        }
        ArrayList queueNames = new ArrayList();
        String[] taskCodes = taskCode.value();
        Stream.of(taskCodes).forEach(e -> {
            String queueName = EventQueueGenerator.gen(e);
            this.mqRegistry.registQueue(queueName);
            this.mqRegistry.registBindingWithName(queueName, Destinations.DEST_TANIQNG_FANOUT_EVENTBUS.getExchange(), Destinations.DEST_TANIQNG_FANOUT_EVENTBUS.getRoutingKey());
            queueNames.add(queueName);
        });
        return queueNames.toArray(new String[queueNames.size()]);
    }

    public String getEndPointId() {
        return "org.taniqng.eventbus.amqp.rabbit.RabbitListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private class RabbitHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private RabbitHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory rabbitHandlerMethodFactory1) {
            this.messageHandlerMethodFactory = rabbitHandlerMethodFactory1;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(EventListenerPostProcessor.this.beanFactory);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

