/*
 * Decompiled with CFR 0.152.
 */
package com.github.taniqng.eventbus.core;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class PropertiesLoaderForBus
implements BeanFactoryPostProcessor {
    private static PropertiesLoaderForBus loader;
    private ConfigurableListableBeanFactory beanFactory;
    private static final Map<String, String> cache;

    static {
        cache = new ConcurrentHashMap<String, String>(128, 0.8f, 4);
    }

    public PropertiesLoaderForBus() {
        loader = this;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public static String getProperty(String key) {
        return loader._getProperty(key);
    }

    public static String getPropViaExp(String exp) {
        return loader._getPropViaExp(exp);
    }

    public static String getProperty(String key, String valIfNull) {
        return Optional.ofNullable(loader._getProperty(key)).orElse(valIfNull);
    }

    public static Integer getInteger(String key) {
        return loader._getInteger(key);
    }

    private String _getProperty(String key) {
        return this._getPropViaExp("${" + key + "}");
    }

    private String _getPropViaExp(String exp) {
        if (exp == null) {
            return null;
        }
        try {
            String val = Optional.ofNullable(cache.get(exp)).orElseGet(() -> this.beanFactory.resolveEmbeddedValue(exp));
            String oval = cache.putIfAbsent(exp, val);
            return oval != null ? oval : val;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Integer _getInteger(String key) {
        if (key == null) {
            return null;
        }
        return Optional.ofNullable(this._getProperty(key)).map(e -> Integer.parseInt(e)).get();
    }
}

