/*
 * Decompiled with CFR 0.152.
 */
package com.github.teakfly.teafly.common.datatool.interceptor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class SqlPrintInterceptor
implements Serializable,
Interceptor {
    private static final Logger b = LoggerFactory.getLogger(SqlPrintInterceptor.class);
    private static final long serialVersionUID = 1L;

    public Object intercept(Invocation invocation) throws Throwable {
        String string = "";
        try {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object object = null;
            if (invocation.getArgs().length > 1) {
                object = invocation.getArgs()[1];
            }
            String string2 = mappedStatement.getId();
            BoundSql boundSql = mappedStatement.getBoundSql(object);
            Configuration configuration = mappedStatement.getConfiguration();
            string = SqlPrintInterceptor.a(configuration, boundSql, string2, 0L);
            b.info(System.getProperty("line.separator", "\r\n") + ">>>>>\u6267\u884csql:" + string + System.getProperty("line.separator", "\r\n"));
            if (mappedStatement.getSqlCommandType() == SqlCommandType.DELETE || mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
                Executor executor = (Executor)invocation.getTarget();
                Connection connection = executor.getTransaction().getConnection();
            }
        }
        catch (Exception exception) {
            b.error("\u6267\u884csql:" + string + ">" + exception.getMessage());
        }
        return invocation.proceed();
    }

    private static String a(Configuration configuration, BoundSql boundSql, String string, long l) {
        String string2 = SqlPrintInterceptor.a(configuration, boundSql);
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(System.getProperty("line.separator", "\n"));
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static String b(Object object) {
        String string = null;
        if (object instanceof String) {
            string = "'" + object.toString() + "'";
        } else if (object instanceof Date) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            string = "'" + dateFormat.format(object) + "'";
        } else {
            string = object != null ? object.toString() : "NULL";
        }
        return string;
    }

    private static String a(Configuration configuration, BoundSql boundSql) {
        Object object = boundSql.getParameterObject();
        List list = boundSql.getParameterMappings();
        String string = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (CollectionUtils.isNotEmpty((Collection)list) && object != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(object.getClass())) {
                string = string.replaceFirst("\\?", Matcher.quoteReplacement(SqlPrintInterceptor.b(object)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(object);
                for (ParameterMapping parameterMapping : list) {
                    Object object2;
                    String string2 = parameterMapping.getProperty();
                    if (metaObject.hasGetter(string2)) {
                        object2 = metaObject.getValue(string2);
                        string = string.replaceFirst("\\?", Matcher.quoteReplacement(SqlPrintInterceptor.b(object2)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(string2)) {
                        object2 = boundSql.getAdditionalParameter(string2);
                        string = string.replaceFirst("\\?", Matcher.quoteReplacement(SqlPrintInterceptor.b(object2)));
                        continue;
                    }
                    string = string.replaceFirst("\\?", "\u7f3a\u5931");
                }
            }
        }
        return string;
    }

    public Object plugin(Object object) {
        return Plugin.wrap((Object)object, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

