/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public String translateName(Field f) {
            return f.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translateName(Field f) {
            return 2.upperCaseFirstLetter(f.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public String translateName(Field f) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(f.getName(), " "));
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field f) {
            return 4.separateCamelCase(f.getName(), "_").toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public String translateName(Field f) {
            return 5.separateCamelCase(f.getName(), "-").toLowerCase(Locale.ENGLISH);
        }
    };


    static String separateCamelCase(String name, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c2 = name.charAt(i);
            if (Character.isUpperCase(c2) && stringBuilder.length() != 0) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    static String upperCaseFirstLetter(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        char c2 = name.charAt(n);
        int n2 = name.length();
        while (n < n2 - 1 && !Character.isLetter(c2)) {
            stringBuilder.append(c2);
            c2 = name.charAt(++n);
        }
        if (!Character.isUpperCase(c2)) {
            String string = FieldNamingPolicy.modifyString(Character.toUpperCase(c2), name, ++n);
            return stringBuilder.append(string).toString();
        }
        return name;
    }

    private static String modifyString(char firstCharacter, String srcString, int indexOfSubstring) {
        return indexOfSubstring < srcString.length() ? firstCharacter + srcString.substring(indexOfSubstring) : String.valueOf(firstCharacter);
    }
}

