/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            Type type2 = $Gson$Types.getArrayComponentType(type);
            TypeAdapter<?> typeAdapter = gson.getAdapter(TypeToken.get(type2));
            return new ArrayTypeAdapter(gson, typeAdapter, $Gson$Types.getRawType(type2));
        }
    };
    private final Class<E> componentType;
    private final TypeAdapter<E> componentTypeAdapter;

    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, componentTypeAdapter, componentType);
        this.componentType = componentType;
    }

    @Override
    public Object read(JsonReader in) {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        in.beginArray();
        while (in.hasNext()) {
            E e2 = this.componentTypeAdapter.read(in);
            arrayList.add(e2);
        }
        in.endArray();
        int n = arrayList.size();
        Object object = Array.newInstance(this.componentType, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, arrayList.get(i));
        }
        return object;
    }

    @Override
    public void write(JsonWriter out, Object array) {
        if (array == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int n = Array.getLength(array);
        for (int i = 0; i < n; ++i) {
            Object object = Array.get(array, i);
            this.componentTypeAdapter.write(out, object);
        }
        out.endArray();
    }
}

