/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

final class TypeAdapterRuntimeTypeWrapper<T>
extends TypeAdapter<T> {
    private final Gson context;
    private final TypeAdapter<T> delegate;
    private final Type type;

    TypeAdapterRuntimeTypeWrapper(Gson context, TypeAdapter<T> delegate, Type type) {
        this.context = context;
        this.delegate = delegate;
        this.type = type;
    }

    @Override
    public T read(JsonReader in) {
        return this.delegate.read(in);
    }

    @Override
    public void write(JsonWriter out, T value) {
        TypeAdapter<Object> typeAdapter = this.delegate;
        Type type = this.getRuntimeTypeIfMoreSpecific(this.type, value);
        if (type != this.type) {
            TypeAdapter<?> typeAdapter2 = this.context.getAdapter(TypeToken.get(type));
            typeAdapter = !(typeAdapter2 instanceof ReflectiveTypeAdapterFactory.Adapter) ? typeAdapter2 : (!(this.delegate instanceof ReflectiveTypeAdapterFactory.Adapter) ? this.delegate : typeAdapter2);
        }
        typeAdapter.write(out, value);
    }

    private Type getRuntimeTypeIfMoreSpecific(Type type, Object value) {
        if (value != null && (type == Object.class || type instanceof TypeVariable || type instanceof Class)) {
            type = value.getClass();
        }
        return type;
    }
}

