/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final String UTC_ID = "UTC";
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean millis) {
        return ISO8601Utils.format(date, millis, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean millis, TimeZone tz) {
        int n;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(tz, Locale.US);
        gregorianCalendar.setTime(date);
        int n2 = "yyyy-MM-ddThh:mm:ss".length();
        n2 += millis ? ".sss".length() : 0;
        StringBuilder stringBuilder = new StringBuilder(n2 += tz.getRawOffset() == 0 ? "Z".length() : "+hh:mm".length());
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(1), "yyyy".length());
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(2) + 1, "MM".length());
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(5), "dd".length());
        stringBuilder.append('T');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(11), "hh".length());
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(12), "mm".length());
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(13), "ss".length());
        if (millis) {
            stringBuilder.append('.');
            ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(14), "sss".length());
        }
        if ((n = tz.getOffset(gregorianCalendar.getTimeInMillis())) != 0) {
            int n3 = Math.abs(n / 60000 / 60);
            int n4 = Math.abs(n / 60000 % 60);
            stringBuilder.append(n < 0 ? (char)'-' : '+');
            ISO8601Utils.padInt(stringBuilder, n3, "hh".length());
            stringBuilder.append(':');
            ISO8601Utils.padInt(stringBuilder, n4, "mm".length());
        } else {
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    public static Date parse(String date, ParsePosition pos) {
        RuntimeException runtimeException = null;
        try {
            int n;
            int n2 = pos.getIndex();
            int n3 = ISO8601Utils.parseInt(date, n2, n2 += 4);
            if (ISO8601Utils.checkOffset(date, n2, '-')) {
                // empty if block
            }
            int n4 = ISO8601Utils.parseInt(date, ++n2, n2 += 2);
            if (ISO8601Utils.checkOffset(date, n2, '-')) {
                // empty if block
            }
            int n5 = ISO8601Utils.parseInt(date, ++n2, n2 += 2);
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            boolean bl = ISO8601Utils.checkOffset(date, n2, 'T');
            if (!bl && date.length() <= n2) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n4 - 1, n5);
                pos.setIndex(n2);
                return gregorianCalendar.getTime();
            }
            if (bl) {
                char c2;
                n6 = ISO8601Utils.parseInt(date, ++n2, n2 += 2);
                if (ISO8601Utils.checkOffset(date, n2, ':')) {
                    // empty if block
                }
                n7 = ISO8601Utils.parseInt(date, ++n2, n2 += 2);
                if (ISO8601Utils.checkOffset(date, n2, ':')) {
                    ++n2;
                }
                if (date.length() > n2 && (c2 = date.charAt(n2)) != 'Z' && c2 != '+' && c2 != '-') {
                    if ((n8 = ISO8601Utils.parseInt(date, n2, n2 += 2)) > 59 && n8 < 63) {
                        n8 = 59;
                    }
                    if (ISO8601Utils.checkOffset(date, n2, '.')) {
                        n = ISO8601Utils.indexOfNonDigit(date, ++n2 + 1);
                        int n10 = Math.min(n, n2 + 3);
                        int n11 = ISO8601Utils.parseInt(date, n2, n10);
                        switch (n10 - n2) {
                            case 2: {
                                n9 = n11 * 10;
                                break;
                            }
                            case 1: {
                                n9 = n11 * 100;
                                break;
                            }
                            default: {
                                n9 = n11;
                            }
                        }
                        n2 = n;
                    }
                }
            }
            if (date.length() <= n2) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            TimeZone timeZone = null;
            n = date.charAt(n2);
            if (n == 90) {
                timeZone = TIMEZONE_UTC;
                ++n2;
            } else if (n == 43 || n == 45) {
                String string = date.substring(n2);
                string = string.length() >= 5 ? string : string + "00";
                n2 += string.length();
                if ("+0000".equals(string) || "+00:00".equals(string)) {
                    timeZone = TIMEZONE_UTC;
                } else {
                    String string2;
                    String string3 = "GMT" + string;
                    timeZone = TimeZone.getTimeZone(string3);
                    String string4 = timeZone.getID();
                    if (!string4.equals(string3) && !(string2 = string4.replace(":", "")).equals(string3)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + string3 + " given, resolves to " + timeZone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + (char)n + "'");
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setLenient(false);
            gregorianCalendar.set(1, n3);
            gregorianCalendar.set(2, n4 - 1);
            gregorianCalendar.set(5, n5);
            gregorianCalendar.set(11, n6);
            gregorianCalendar.set(12, n7);
            gregorianCalendar.set(13, n8);
            gregorianCalendar.set(14, n9);
            pos.setIndex(n2);
            return gregorianCalendar.getTime();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            runtimeException = indexOutOfBoundsException;
        }
        catch (NumberFormatException numberFormatException) {
            runtimeException = numberFormatException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        String string = date == null ? null : '\"' + date + "'";
        String string5 = runtimeException.getMessage();
        if (string5 == null || string5.isEmpty()) {
            string5 = "(" + runtimeException.getClass().getName() + ")";
        }
        ParseException parseException = new ParseException("Failed to parse date [" + string + "]: " + string5, pos.getIndex());
        parseException.initCause(runtimeException);
        throw parseException;
    }

    private static boolean checkOffset(String value, int offset, char expected) {
        return offset < value.length() && value.charAt(offset) == expected;
    }

    private static int parseInt(String value, int beginIndex, int endIndex) {
        int n;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int n2 = beginIndex;
        int n3 = 0;
        if (n2 < endIndex) {
            if ((n = Character.digit(value.charAt(n2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            n3 = -n;
        }
        while (n2 < endIndex) {
            if ((n = Character.digit(value.charAt(n2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            n3 *= 10;
            n3 -= n;
        }
        return -n3;
    }

    private static void padInt(StringBuilder buffer, int value, int length) {
        String string = Integer.toString(value);
        for (int i = length - string.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(string);
    }

    private static int indexOfNonDigit(String string, int offset) {
        for (int i = offset; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 >= '0' && c2 <= '9') continue;
            return i;
        }
        return string.length();
    }
}

