/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private final Reader in;
    private boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;

    public JsonReader(Reader in) {
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        this.in = in;
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public void beginArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n != 3) {
            throw new IllegalStateException("Expected BEGIN_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.push(1);
        this.pathIndices[this.stackSize - 1] = 0;
        this.peeked = 0;
    }

    public void endArray() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 4) {
            --this.stackSize;
        } else {
            throw new IllegalStateException("Expected END_ARRAY but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        this.peeked = 0;
    }

    public void beginObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n != 1) {
            throw new IllegalStateException("Expected BEGIN_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.push(3);
        this.peeked = 0;
    }

    public void endObject() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 2) {
            --this.stackSize;
        } else {
            throw new IllegalStateException("Expected END_OBJECT but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.pathNames[this.stackSize] = null;
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        this.peeked = 0;
    }

    public boolean hasNext() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        return n != 2 && n != 4;
    }

    public JsonToken peek() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        switch (n) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    int doPeek() {
        int n;
        int n2;
        block45: {
            block47: {
                block46: {
                    block44: {
                        n2 = this.stack[this.stackSize - 1];
                        if (n2 != 1) break block44;
                        this.stack[this.stackSize - 1] = 2;
                        break block45;
                    }
                    if (n2 != 2) break block46;
                    n = this.nextNonWhitespace(true);
                    switch (n) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break;
                        }
                        default: {
                            throw this.syntaxError("Unterminated array");
                        }
                    }
                    break block45;
                }
                if (n2 == 3 || n2 == 5) {
                    int n3;
                    this.stack[this.stackSize - 1] = 4;
                    if (n2 == 5) {
                        n3 = this.nextNonWhitespace(true);
                        switch (n3) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError("Unterminated object");
                            }
                        }
                    }
                    n3 = this.nextNonWhitespace(true);
                    switch (n3) {
                        case 34: {
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (n2 != 5) {
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.syntaxError("Expected name");
                        }
                    }
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)n3)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (n2 != 4) break block47;
                this.stack[this.stackSize - 1] = 5;
                n = this.nextNonWhitespace(true);
                switch (n) {
                    case 58: {
                        break;
                    }
                    case 61: {
                        this.checkLenient();
                        if ((this.pos < this.limit || this.fillBuffer(1)) && this.buffer[this.pos] == '>') {
                            ++this.pos;
                            break;
                        }
                        break block45;
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                }
                break block45;
            }
            if (n2 == 6) {
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = 7;
            } else if (n2 == 7) {
                n = this.nextNonWhitespace(false);
                if (n == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
                --this.pos;
            } else if (n2 == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        n = this.nextNonWhitespace(true);
        switch (n) {
            case 93: {
                if (n2 == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (n2 == 1 || n2 == 2) {
                    this.checkLenient();
                    --this.pos;
                    this.peeked = 7;
                    return 7;
                }
                throw this.syntaxError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        --this.pos;
        int n4 = this.peekKeyword();
        if (n4 != 0) {
            return n4;
        }
        n4 = this.peekNumber();
        if (n4 != 0) {
            return n4;
        }
        if (!this.isLiteral(this.buffer[this.pos])) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() {
        int n;
        String string;
        String string2;
        char c2 = this.buffer[this.pos];
        if (c2 == 't' || c2 == 'T') {
            string2 = "true";
            string = "TRUE";
            n = 5;
        } else if (c2 == 'f' || c2 == 'F') {
            string2 = "false";
            string = "FALSE";
            n = 6;
        } else if (c2 == 'n' || c2 == 'N') {
            string2 = "null";
            string = "NULL";
            n = 7;
        } else {
            return 0;
        }
        int n2 = string2.length();
        for (int i = 1; i < n2; ++i) {
            if (this.pos + i >= this.limit && !this.fillBuffer(i + 1)) {
                return 0;
            }
            c2 = this.buffer[this.pos + i];
            if (c2 == string2.charAt(i) || c2 == string.charAt(i)) continue;
            return 0;
        }
        if ((this.pos + n2 < this.limit || this.fillBuffer(n2 + 1)) && this.isLiteral(this.buffer[this.pos + n2])) {
            return 0;
        }
        this.pos += n2;
        this.peeked = n;
        return this.peeked;
    }

    private int peekNumber() {
        char[] cArray = this.buffer;
        int n = this.pos;
        int n2 = this.limit;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        block6: while (true) {
            if (n + n4 == n2) {
                if (n4 == cArray.length) {
                    return 0;
                }
                if (!this.fillBuffer(n4 + 1)) break;
                n = this.pos;
                n2 = this.limit;
            }
            char c2 = cArray[n + n4];
            switch (c2) {
                case '-': {
                    if (n3 == 0) {
                        bl = true;
                        n3 = 1;
                        break;
                    }
                    if (n3 == 5) {
                        n3 = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (n3 == 5) {
                        n3 = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (n3 == 2 || n3 == 4) {
                        n3 = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (n3 == 2) {
                        n3 = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c2 < '0' || c2 > '9') {
                        if (!this.isLiteral(c2)) break block6;
                        return 0;
                    }
                    if (n3 == 1 || n3 == 0) {
                        l = -(c2 - 48);
                        n3 = 2;
                        break;
                    }
                    if (n3 == 2) {
                        if (l == 0L) {
                            return 0;
                        }
                        long l2 = l * 10L - (long)(c2 - 48);
                        bl2 &= l > -922337203685477580L || l == -922337203685477580L && l2 < l;
                        l = l2;
                        break;
                    }
                    if (n3 == 3) {
                        n3 = 4;
                        break;
                    }
                    if (n3 != 5 && n3 != 6) break;
                    n3 = 7;
                }
            }
            ++n4;
        }
        if (!(n3 != 2 || !bl2 || l == Long.MIN_VALUE && !bl || l == 0L && bl)) {
            this.peekedLong = bl ? l : -l;
            this.pos += n4;
            this.peeked = 15;
            return 15;
        }
        if (n3 == 2 || n3 == 4 || n3 == 7) {
            this.peekedNumberLength = n4;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private boolean isLiteral(char c2) {
        switch (c2) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public String nextName() {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 14) {
            string = this.nextUnquotedValue();
        } else if (n == 12) {
            string = this.nextQuotedValue('\'');
        } else if (n == 13) {
            string = this.nextQuotedValue('\"');
        } else {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = string;
        return string;
    }

    public String nextString() {
        String string;
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 10) {
            string = this.nextUnquotedValue();
        } else if (n == 8) {
            string = this.nextQuotedValue('\'');
        } else if (n == 9) {
            string = this.nextQuotedValue('\"');
        } else if (n == 11) {
            string = this.peekedString;
            this.peekedString = null;
        } else if (n == 15) {
            string = Long.toString(this.peekedLong);
        } else if (n == 16) {
            string = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
        return string;
    }

    public boolean nextBoolean() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 5) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return true;
        }
        if (n == 6) {
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return false;
        }
        throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.peek()) + this.locationString());
    }

    public void nextNull() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n != 7) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 0;
        int n2 = this.stackSize - 1;
        this.pathIndices[n2] = this.pathIndices[n2] + 1;
    }

    public double nextDouble() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return this.peekedLong;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9) {
            this.peekedString = this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
        } else if (n == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (n != 11) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + d2 + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
        return d2;
    }

    public long nextLong() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            this.peeked = 0;
            int n2 = this.stackSize - 1;
            this.pathIndices[n2] = this.pathIndices[n2] + 1;
            return this.peekedLong;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9 || n == 10) {
            this.peekedString = n == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
            try {
                long l = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n3 = this.stackSize - 1;
                this.pathIndices[n3] = this.pathIndices[n3] + 1;
                return l;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        long l = (long)d2;
        if ((double)l != d2) {
            throw new NumberFormatException("Expected a long but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n4 = this.stackSize - 1;
        this.pathIndices[n4] = this.pathIndices[n4] + 1;
        return l;
    }

    private String nextQuotedValue(char quote) {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = null;
        do {
            int n;
            int n2 = this.pos;
            int n3 = this.limit;
            int n4 = n2;
            while (n2 < n3) {
                int n5;
                if ((n = cArray[n2++]) == quote) {
                    this.pos = n2;
                    n5 = n2 - n4 - 1;
                    if (stringBuilder == null) {
                        return new String(cArray, n4, n5);
                    }
                    stringBuilder.append(cArray, n4, n5);
                    return stringBuilder.toString();
                }
                if (n == 92) {
                    this.pos = n2;
                    n5 = n2 - n4 - 1;
                    if (stringBuilder == null) {
                        int n6 = (n5 + 1) * 2;
                        stringBuilder = new StringBuilder(Math.max(n6, 16));
                    }
                    stringBuilder.append(cArray, n4, n5);
                    stringBuilder.append(this.readEscapeCharacter());
                    n2 = this.pos;
                    n3 = this.limit;
                    n4 = n2;
                    continue;
                }
                if (n != 10) continue;
                ++this.lineNumber;
                this.lineStart = n2;
            }
            if (stringBuilder == null) {
                n = (n2 - n4) * 2;
                stringBuilder = new StringBuilder(Math.max(n, 16));
            }
            stringBuilder.append(cArray, n4, n2 - n4);
            this.pos = n2;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private String nextUnquotedValue() {
        StringBuilder stringBuilder = null;
        int n = 0;
        block4: while (true) {
            if (this.pos + n < this.limit) {
                switch (this.buffer[this.pos + n]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++n;
                        break;
                    }
                }
                continue;
            }
            if (n < this.buffer.length) {
                if (!this.fillBuffer(n + 1)) break;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(Math.max(n, 16));
            }
            stringBuilder.append(this.buffer, this.pos, n);
            this.pos += n;
            n = 0;
            if (!this.fillBuffer(1)) break;
        }
        String string = null == stringBuilder ? new String(this.buffer, this.pos, n) : stringBuilder.append(this.buffer, this.pos, n).toString();
        this.pos += n;
        return string;
    }

    private void skipQuotedValue(char quote) {
        char[] cArray = this.buffer;
        do {
            int n = this.pos;
            int n2 = this.limit;
            while (n < n2) {
                char c2;
                if ((c2 = cArray[n++]) == quote) {
                    this.pos = n;
                    return;
                }
                if (c2 == '\\') {
                    this.pos = n;
                    this.readEscapeCharacter();
                    n = this.pos;
                    n2 = this.limit;
                    continue;
                }
                if (c2 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = n;
            }
            this.pos = n;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private void skipUnquotedValue() {
        do {
            int n = 0;
            while (this.pos + n < this.limit) {
                switch (this.buffer[this.pos + n]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.pos += n;
                        return;
                    }
                }
                ++n;
            }
            this.pos += n;
        } while (this.fillBuffer(1));
    }

    public int nextInt() {
        int n = this.peeked;
        if (n == 0) {
            n = this.doPeek();
        }
        if (n == 15) {
            int n2 = (int)this.peekedLong;
            if (this.peekedLong != (long)n2) {
                throw new NumberFormatException("Expected an int but was " + this.peekedLong + this.locationString());
            }
            this.peeked = 0;
            int n3 = this.stackSize - 1;
            this.pathIndices[n3] = this.pathIndices[n3] + 1;
            return n2;
        }
        if (n == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n == 8 || n == 9 || n == 10) {
            this.peekedString = n == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(n == 8 ? (char)'\'' : '\"');
            try {
                int n4 = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n5 = this.stackSize - 1;
                this.pathIndices[n5] = this.pathIndices[n5] + 1;
                return n4;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.peek()) + this.locationString());
        }
        this.peeked = 11;
        double d2 = Double.parseDouble(this.peekedString);
        int n6 = (int)d2;
        if ((double)n6 != d2) {
            throw new NumberFormatException("Expected an int but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n7 = this.stackSize - 1;
        this.pathIndices[n7] = this.pathIndices[n7] + 1;
        return n6;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    public void skipValue() {
        int n = 0;
        do {
            int n2;
            if ((n2 = this.peeked) == 0) {
                n2 = this.doPeek();
            }
            if (n2 == 3) {
                this.push(1);
                ++n;
            } else if (n2 == 1) {
                this.push(3);
                ++n;
            } else if (n2 == 4) {
                --this.stackSize;
                --n;
            } else if (n2 == 2) {
                --this.stackSize;
                --n;
            } else if (n2 == 14 || n2 == 10) {
                this.skipUnquotedValue();
            } else if (n2 == 8 || n2 == 12) {
                this.skipQuotedValue('\'');
            } else if (n2 == 9 || n2 == 13) {
                this.skipQuotedValue('\"');
            } else if (n2 == 16) {
                this.pos += this.peekedNumberLength;
            }
            this.peeked = 0;
        } while (n != 0);
        int n3 = this.stackSize - 1;
        this.pathIndices[n3] = this.pathIndices[n3] + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = new int[this.stackSize * 2];
            int[] nArray2 = new int[this.stackSize * 2];
            String[] stringArray = new String[this.stackSize * 2];
            System.arraycopy(this.stack, 0, nArray, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, nArray2, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, stringArray, 0, this.stackSize);
            this.stack = nArray;
            this.pathIndices = nArray2;
            this.pathNames = stringArray;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private boolean fillBuffer(int minimum) {
        int n;
        char[] cArray = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(cArray, this.pos, cArray, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((n = this.in.read(cArray, this.limit, cArray.length - this.limit)) != -1) {
            this.limit += n;
            if (this.lineNumber == 0 && this.lineStart == 0 && this.limit > 0 && cArray[0] == '\ufeff') {
                ++this.pos;
                ++this.lineStart;
                ++minimum;
            }
            if (this.limit < minimum) continue;
            return true;
        }
        return false;
    }

    private int nextNonWhitespace(boolean throwOnEof) {
        block12: {
            char c2;
            char[] cArray = this.buffer;
            int n = this.pos;
            int n2 = this.limit;
            block4: while (true) {
                if (n == n2) {
                    this.pos = n;
                    if (!this.fillBuffer(1)) break block12;
                    n = this.pos;
                    n2 = this.limit;
                }
                if ((c2 = cArray[n++]) == '\n') {
                    ++this.lineNumber;
                    this.lineStart = n;
                    continue;
                }
                if (c2 == ' ' || c2 == '\r' || c2 == '\t') continue;
                if (c2 == '/') {
                    char c3;
                    this.pos = n;
                    if (n == n2) {
                        --this.pos;
                        c3 = (char)(this.fillBuffer(2) ? 1 : 0);
                        ++this.pos;
                        if (c3 == '\u0000') {
                            return c2;
                        }
                    }
                    this.checkLenient();
                    c3 = cArray[this.pos];
                    switch (c3) {
                        case '*': {
                            ++this.pos;
                            if (!this.skipTo("*/")) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            n = this.pos + 2;
                            n2 = this.limit;
                            continue block4;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            n = this.pos;
                            n2 = this.limit;
                            continue block4;
                        }
                    }
                    return c2;
                }
                if (c2 != '#') break;
                this.pos = n;
                this.checkLenient();
                this.skipToEndOfLine();
                n = this.pos;
                n2 = this.limit;
            }
            this.pos = n;
            return c2;
        }
        if (throwOnEof) {
            throw new EOFException("End of input" + this.locationString());
        }
        return -1;
    }

    private void checkLenient() {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char c2;
            if ((c2 = this.buffer[this.pos++]) == '\n') {
                ++this.lineNumber;
                this.lineStart = this.pos;
                break;
            }
            if (c2 != '\r') continue;
            break;
        }
    }

    private boolean skipTo(String toFind) {
        int n = toFind.length();
        while (this.pos + n <= this.limit || this.fillBuffer(n)) {
            block5: {
                if (this.buffer[this.pos] == '\n') {
                    ++this.lineNumber;
                    this.lineStart = this.pos + 1;
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (this.buffer[this.pos + i] == toFind.charAt(i)) {
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++this.pos;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    String locationString() {
        int n = this.lineNumber + 1;
        int n2 = this.pos - this.lineStart + 1;
        return " at line " + n + " column " + n2 + " path " + this.getPath();
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder().append('$');
        int n = this.stackSize;
        block4: for (int i = 0; i < n; ++i) {
            switch (this.stack[i]) {
                case 1: 
                case 2: {
                    stringBuilder.append('[').append(this.pathIndices[i]).append(']');
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    stringBuilder.append('.');
                    if (this.pathNames[i] == null) continue block4;
                    stringBuilder.append(this.pathNames[i]);
                    continue block4;
                }
            }
        }
        return stringBuilder.toString();
    }

    private char readEscapeCharacter() {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char c2 = this.buffer[this.pos++];
        switch (c2) {
            case 'u': {
                int n;
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                char c3 = '\u0000';
                int n2 = n + 4;
                for (n = this.pos; n < n2; ++n) {
                    char c4 = this.buffer[n];
                    c3 = (char)(c3 << 4);
                    if (c4 >= '0' && c4 <= '9') {
                        c3 = (char)(c3 + (c4 - 48));
                        continue;
                    }
                    if (c4 >= 'a' && c4 <= 'f') {
                        c3 = (char)(c3 + (c4 - 97 + 10));
                        continue;
                    }
                    if (c4 >= 'A' && c4 <= 'F') {
                        c3 = (char)(c3 + (c4 - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + new String(this.buffer, this.pos, 4));
                }
                this.pos += 4;
                return c3;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': {
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                return c2;
            }
        }
        throw this.syntaxError("Invalid escape sequence");
    }

    private IOException syntaxError(String message) {
        throw new MalformedJsonException(message + this.locationString());
    }

    private void consumeNonExecutePrefix() {
        this.nextNonWhitespace(true);
        --this.pos;
        if (this.pos + NON_EXECUTE_PREFIX.length > this.limit && !this.fillBuffer(NON_EXECUTE_PREFIX.length)) {
            return;
        }
        for (int i = 0; i < NON_EXECUTE_PREFIX.length; ++i) {
            if (this.buffer[this.pos + i] == NON_EXECUTE_PREFIX[i]) continue;
            return;
        }
        this.pos += NON_EXECUTE_PREFIX.length;
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public void promoteNameToValue(JsonReader reader) {
                if (reader instanceof JsonTreeReader) {
                    ((JsonTreeReader)reader).promoteNameToValue();
                    return;
                }
                int n = reader.peeked;
                if (n == 0) {
                    n = reader.doPeek();
                }
                if (n == 13) {
                    reader.peeked = 9;
                } else if (n == 12) {
                    reader.peeked = 8;
                } else if (n == 14) {
                    reader.peeked = 10;
                } else {
                    throw new IllegalStateException("Expected a name but was " + (Object)((Object)reader.peek()) + reader.locationString());
                }
            }
        };
    }
}

