/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;

    CertificatePinner(Set<Pin> pins, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = pins;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof CertificatePinner && Util.equal(this.certificateChainCleaner, ((CertificatePinner)other).certificateChainCleaner) && this.pins.equals(((CertificatePinner)other).pins);
    }

    public int hashCode() {
        int n = this.certificateChainCleaner != null ? this.certificateChainCleaner.hashCode() : 0;
        n = 31 * n + this.pins.hashCode();
        return n;
    }

    public void check(String hostname, List<Certificate> peerCertificates) {
        Object object;
        List<Pin> list = this.findMatchingPins(hostname);
        if (list.isEmpty()) {
            return;
        }
        if (this.certificateChainCleaner != null) {
            peerCertificates = this.certificateChainCleaner.clean(peerCertificates, hostname);
        }
        int n = peerCertificates.size();
        for (int i = 0; i < n; ++i) {
            X509Certificate x509Certificate = (X509Certificate)peerCertificates.get(i);
            object = null;
            ByteString byteString = null;
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                Pin pin = list.get(j);
                if (pin.hashAlgorithm.equals("sha256/")) {
                    if (byteString == null) {
                        byteString = CertificatePinner.sha256(x509Certificate);
                    }
                    if (!pin.hash.equals(byteString)) continue;
                    return;
                }
                if (pin.hashAlgorithm.equals("sha1/")) {
                    if (object == null) {
                        object = CertificatePinner.sha1(x509Certificate);
                    }
                    if (!pin.hash.equals(object)) continue;
                    return;
                }
                throw new AssertionError((Object)("unsupported hashAlgorithm: " + pin.hashAlgorithm));
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int n3 = peerCertificates.size();
        for (n = 0; n < n3; ++n) {
            object = (X509Certificate)peerCertificates.get(n);
            stringBuilder.append("\n    ").append(CertificatePinner.pin((Certificate)object)).append(": ").append(((X509Certificate)object).getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(hostname).append(":");
        n3 = list.size();
        for (n = 0; n < n3; ++n) {
            object = list.get(n);
            stringBuilder.append("\n    ").append(object);
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public void check(String hostname, Certificate ... peerCertificates) {
        this.check(hostname, Arrays.asList(peerCertificates));
    }

    List<Pin> findMatchingPins(String hostname) {
        List<Pin> list = Collections.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(hostname)) continue;
            if (list.isEmpty()) {
                list = new ArrayList<Pin>();
            }
            list.add(pin);
        }
        return list;
    }

    CertificatePinner withCertificateChainCleaner(@Nullable CertificateChainCleaner certificateChainCleaner) {
        return Util.equal(this.certificateChainCleaner, certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha256/" + CertificatePinner.sha256((X509Certificate)certificate).base64();
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    public static final class Builder {
        private final List<Pin> pins = new ArrayList<Pin>();

        public Builder add(String pattern, String ... pins) {
            if (pattern == null) {
                throw new NullPointerException("pattern == null");
            }
            for (String string : pins) {
                this.pins.add(new Pin(pattern, string));
            }
            return this;
        }

        public CertificatePinner build() {
            return new CertificatePinner(new LinkedHashSet<Pin>(this.pins), null);
        }
    }

    static final class Pin {
        private static final String WILDCARD = "*.";
        final String pattern;
        final String canonicalHostname;
        final String hashAlgorithm;
        final ByteString hash;

        Pin(String pattern, String pin) {
            this.pattern = pattern;
            String string = this.canonicalHostname = pattern.startsWith(WILDCARD) ? HttpUrl.parse("http://" + pattern.substring(WILDCARD.length())).host() : HttpUrl.parse("http://" + pattern).host();
            if (pin.startsWith("sha1/")) {
                this.hashAlgorithm = "sha1/";
                this.hash = ByteString.decodeBase64(pin.substring("sha1/".length()));
            } else if (pin.startsWith("sha256/")) {
                this.hashAlgorithm = "sha256/";
                this.hash = ByteString.decodeBase64(pin.substring("sha256/".length()));
            } else {
                throw new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + pin);
            }
            if (this.hash == null) {
                throw new IllegalArgumentException("pins must be base64: " + pin);
            }
        }

        boolean matches(String hostname) {
            if (this.pattern.startsWith(WILDCARD)) {
                int n = hostname.indexOf(46);
                return hostname.length() - n - 1 == this.canonicalHostname.length() && hostname.regionMatches(false, n + 1, this.canonicalHostname, 0, this.canonicalHostname.length());
            }
            return hostname.equals(this.canonicalHostname);
        }

        public boolean equals(Object other) {
            return other instanceof Pin && this.pattern.equals(((Pin)other).pattern) && this.hashAlgorithm.equals(((Pin)other).hashAlgorithm) && this.hash.equals(((Pin)other).hash);
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.pattern.hashCode();
            n = 31 * n + this.hashAlgorithm.hashCode();
            n = 31 * n + this.hash.hashCode();
            return n;
        }

        public String toString() {
            return this.hashAlgorithm + this.hash.base64();
        }
    }
}

