/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;

public final class Cookie {
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean hostOnly, boolean persistent) {
        this.name = name;
        this.value = value;
        this.expiresAt = expiresAt;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.hostOnly = hostOnly;
        this.persistent = persistent;
    }

    Cookie(Builder builder) {
        if (builder.name == null) {
            throw new NullPointerException("builder.name == null");
        }
        if (builder.value == null) {
            throw new NullPointerException("builder.value == null");
        }
        if (builder.domain == null) {
            throw new NullPointerException("builder.domain == null");
        }
        this.name = builder.name;
        this.value = builder.value;
        this.expiresAt = builder.expiresAt;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
        this.persistent = builder.persistent;
        this.hostOnly = builder.hostOnly;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public long expiresAt() {
        return this.expiresAt;
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public String domain() {
        return this.domain;
    }

    public String path() {
        return this.path;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean matches(HttpUrl url) {
        boolean bl;
        boolean bl2 = bl = this.hostOnly ? url.host().equals(this.domain) : Cookie.domainMatch(url.host(), this.domain);
        if (!bl) {
            return false;
        }
        if (!Cookie.pathMatch(url, this.path)) {
            return false;
        }
        return !this.secure || url.isHttps();
    }

    private static boolean domainMatch(String urlHost, String domain) {
        if (urlHost.equals(domain)) {
            return true;
        }
        return urlHost.endsWith(domain) && urlHost.charAt(urlHost.length() - domain.length() - 1) == '.' && !Util.verifyAsIpAddress(urlHost);
    }

    private static boolean pathMatch(HttpUrl url, String path) {
        String string = url.encodedPath();
        if (string.equals(path)) {
            return true;
        }
        if (string.startsWith(path)) {
            if (path.endsWith("/")) {
                return true;
            }
            if (string.charAt(path.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Cookie parse(HttpUrl url, String setCookie) {
        return Cookie.parse(System.currentTimeMillis(), url, setCookie);
    }

    @Nullable
    static Cookie parse(long currentTimeMillis, HttpUrl url, String setCookie) {
        long l;
        int n = 0;
        int n2 = setCookie.length();
        int n3 = Util.delimiterOffset(setCookie, n, n2, ';');
        int n4 = Util.delimiterOffset(setCookie, n, n3, '=');
        if (n4 == n3) {
            return null;
        }
        String string = Util.trimSubstring(setCookie, n, n4);
        if (string.isEmpty() || Util.indexOfControlOrNonAscii(string) != -1) {
            return null;
        }
        String string2 = Util.trimSubstring(setCookie, n4 + 1, n3);
        if (Util.indexOfControlOrNonAscii(string2) != -1) {
            return null;
        }
        long l2 = 253402300799999L;
        long l3 = -1L;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        n = n3 + 1;
        while (n < n2) {
            String string5;
            int n5 = Util.delimiterOffset(setCookie, n, n2, ';');
            int n6 = Util.delimiterOffset(setCookie, n, n5, '=');
            String string6 = Util.trimSubstring(setCookie, n, n6);
            String string7 = string5 = n6 < n5 ? Util.trimSubstring(setCookie, n6 + 1, n5) : "";
            if (string6.equalsIgnoreCase("expires")) {
                try {
                    l2 = Cookie.parseExpires(string5, 0, string5.length());
                    bl4 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string6.equalsIgnoreCase("max-age")) {
                try {
                    l3 = Cookie.parseMaxAge(string5);
                    bl4 = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string6.equalsIgnoreCase("domain")) {
                try {
                    string3 = Cookie.parseDomain(string5);
                    bl3 = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string6.equalsIgnoreCase("path")) {
                string4 = string5;
            } else if (string6.equalsIgnoreCase("secure")) {
                bl = true;
            } else if (string6.equalsIgnoreCase("httponly")) {
                bl2 = true;
            }
            n = n5 + 1;
        }
        if (l3 == Long.MIN_VALUE) {
            l2 = Long.MIN_VALUE;
        } else if (l3 != -1L && ((l2 = currentTimeMillis + (l = l3 <= 9223372036854775L ? l3 * 1000L : Long.MAX_VALUE)) < currentTimeMillis || l2 > 253402300799999L)) {
            l2 = 253402300799999L;
        }
        String string8 = url.host();
        if (string3 == null) {
            string3 = string8;
        } else if (!Cookie.domainMatch(string8, string3)) {
            return null;
        }
        if (string8.length() != string3.length() && PublicSuffixDatabase.get().getEffectiveTldPlusOne(string3) == null) {
            return null;
        }
        if (string4 == null || !string4.startsWith("/")) {
            String string9 = url.encodedPath();
            int n7 = string9.lastIndexOf(47);
            string4 = n7 != 0 ? string9.substring(0, n7) : "/";
        }
        return new Cookie(string, string2, l2, string3, string4, bl, bl2, bl3, bl4);
    }

    private static long parseExpires(String s, int pos, int limit) {
        pos = Cookie.dateCharacterOffset(s, pos, limit, false);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        Matcher matcher = TIME_PATTERN.matcher(s);
        while (pos < limit) {
            int n7 = Cookie.dateCharacterOffset(s, pos + 1, limit, true);
            matcher.region(pos, n7);
            if (n == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                n = Integer.parseInt(matcher.group(1));
                n2 = Integer.parseInt(matcher.group(2));
                n3 = Integer.parseInt(matcher.group(3));
            } else if (n4 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n4 = Integer.parseInt(matcher.group(1));
            } else if (n5 == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                String string = matcher.group(1).toLowerCase(Locale.US);
                n5 = MONTH_PATTERN.pattern().indexOf(string) / 4;
            } else if (n6 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                n6 = Integer.parseInt(matcher.group(1));
            }
            pos = Cookie.dateCharacterOffset(s, n7 + 1, limit, false);
        }
        if (n6 >= 70 && n6 <= 99) {
            n6 += 1900;
        }
        if (n6 >= 0 && n6 <= 69) {
            n6 += 2000;
        }
        if (n6 < 1601) {
            throw new IllegalArgumentException();
        }
        if (n5 == -1) {
            throw new IllegalArgumentException();
        }
        if (n4 < 1 || n4 > 31) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
        gregorianCalendar.setLenient(false);
        gregorianCalendar.set(1, n6);
        gregorianCalendar.set(2, n5 - 1);
        gregorianCalendar.set(5, n4);
        gregorianCalendar.set(11, n);
        gregorianCalendar.set(12, n2);
        gregorianCalendar.set(13, n3);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    private static int dateCharacterOffset(String input, int pos, int limit, boolean invert) {
        for (int i = pos; i < limit; ++i) {
            char c2 = input.charAt(i);
            boolean bl = c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':';
            if (bl != !invert) continue;
            return i;
        }
        return limit;
    }

    private static long parseMaxAge(String s) {
        try {
            long l = Long.parseLong(s);
            return l <= 0L ? Long.MIN_VALUE : l;
        }
        catch (NumberFormatException numberFormatException) {
            if (s.matches("-?\\d+")) {
                return s.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private static String parseDomain(String s) {
        String string;
        if (s.endsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (s.startsWith(".")) {
            s = s.substring(1);
        }
        if ((string = Util.canonicalizeHost(s)) == null) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public static List<Cookie> parseAll(HttpUrl url, Headers headers) {
        List<String> list = headers.values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Cookie cookie = Cookie.parse(url, list.get(i));
            if (cookie == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean forObsoleteRfc2965) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                stringBuilder.append("; expires=").append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder.append("; domain=");
            if (forObsoleteRfc2965) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.domain);
        }
        stringBuilder.append("; path=").append(this.path);
        if (this.secure) {
            stringBuilder.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder.append("; httponly");
        }
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)other;
        return cookie.name.equals(this.name) && cookie.value.equals(this.value) && cookie.domain.equals(this.domain) && cookie.path.equals(this.path) && cookie.expiresAt == this.expiresAt && cookie.secure == this.secure && cookie.httpOnly == this.httpOnly && cookie.persistent == this.persistent && cookie.hostOnly == this.hostOnly;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.value.hashCode();
        n = 31 * n + this.domain.hashCode();
        n = 31 * n + this.path.hashCode();
        n = 31 * n + (int)(this.expiresAt ^ this.expiresAt >>> 32);
        n = 31 * n + (this.secure ? 0 : 1);
        n = 31 * n + (this.httpOnly ? 0 : 1);
        n = 31 * n + (this.persistent ? 0 : 1);
        n = 31 * n + (this.hostOnly ? 0 : 1);
        return n;
    }

    public static final class Builder {
        String name;
        String value;
        long expiresAt = 253402300799999L;
        String domain;
        String path = "/";
        boolean secure;
        boolean httpOnly;
        boolean persistent;
        boolean hostOnly;

        public Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (!name.trim().equals(name)) {
                throw new IllegalArgumentException("name is not trimmed");
            }
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            if (value == null) {
                throw new NullPointerException("value == null");
            }
            if (!value.trim().equals(value)) {
                throw new IllegalArgumentException("value is not trimmed");
            }
            this.value = value;
            return this;
        }

        public Builder expiresAt(long expiresAt) {
            if (expiresAt <= 0L) {
                expiresAt = Long.MIN_VALUE;
            }
            if (expiresAt > 253402300799999L) {
                expiresAt = 253402300799999L;
            }
            this.expiresAt = expiresAt;
            this.persistent = true;
            return this;
        }

        public Builder domain(String domain) {
            return this.domain(domain, false);
        }

        public Builder hostOnlyDomain(String domain) {
            return this.domain(domain, true);
        }

        private Builder domain(String domain, boolean hostOnly) {
            if (domain == null) {
                throw new NullPointerException("domain == null");
            }
            String string = Util.canonicalizeHost(domain);
            if (string == null) {
                throw new IllegalArgumentException("unexpected domain: " + domain);
            }
            this.domain = string;
            this.hostOnly = hostOnly;
            return this;
        }

        public Builder path(String path) {
            if (!path.startsWith("/")) {
                throw new IllegalArgumentException("path must start with '/'");
            }
            this.path = path;
            return this;
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Cookie build() {
            return new Cookie(this);
        }
    }
}

