/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    @Nullable
    public String get(String name) {
        return Headers.get(this.namesAndValues, name);
    }

    @Nullable
    public Date getDate(String name) {
        String string = this.get(name);
        return string != null ? HttpDate.parse(string) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int index) {
        return this.namesAndValues[index * 2];
    }

    public String value(int index) {
        return this.namesAndValues[index * 2 + 1];
    }

    public Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            treeSet.add(this.name(i));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public List<String> values(String name) {
        ArrayList<String> arrayList = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!name.equalsIgnoreCase(this.name(i))) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
            }
            arrayList.add(this.value(i));
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public long byteCount() {
        long l = this.namesAndValues.length * 2;
        int n = this.namesAndValues.length;
        for (int i = 0; i < n; ++i) {
            l += (long)this.namesAndValues[i].length();
        }
        return l;
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Headers && Arrays.equals(((Headers)other).namesAndValues, this.namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.name(i)).append(": ").append(this.value(i)).append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String string = this.name(i).toLowerCase(Locale.US);
            ArrayList<String> arrayList = (ArrayList<String>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
                treeMap.put(string, arrayList);
            }
            arrayList.add(this.value(i));
        }
        return treeMap;
    }

    private static String get(String[] namesAndValues, String name) {
        for (int i = namesAndValues.length - 2; i >= 0; i -= 2) {
            if (!name.equalsIgnoreCase(namesAndValues[i])) continue;
            return namesAndValues[i + 1];
        }
        return null;
    }

    public static Headers of(String ... namesAndValues) {
        int n;
        if (namesAndValues == null) {
            throw new NullPointerException("namesAndValues == null");
        }
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        namesAndValues = (String[])namesAndValues.clone();
        for (n = 0; n < namesAndValues.length; ++n) {
            if (namesAndValues[n] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            namesAndValues[n] = namesAndValues[n].trim();
        }
        for (n = 0; n < namesAndValues.length; n += 2) {
            String string = namesAndValues[n];
            String string2 = namesAndValues[n + 1];
            if (string.length() != 0 && string.indexOf(0) == -1 && string2.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + string + ": " + string2);
        }
        return new Headers(namesAndValues);
    }

    public static Headers of(Map<String, String> headers) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        String[] stringArray = new String[headers.size() * 2];
        int n = 0;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String string = entry.getKey().trim();
            String string2 = entry.getValue().trim();
            if (string.length() == 0 || string.indexOf(0) != -1 || string2.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + string + ": " + string2);
            }
            stringArray[n] = string;
            stringArray[n + 1] = string2;
            n += 2;
        }
        return new Headers(stringArray);
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String line) {
            int n = line.indexOf(":", 1);
            if (n != -1) {
                return this.addLenient(line.substring(0, n), line.substring(n + 1));
            }
            if (line.startsWith(":")) {
                return this.addLenient("", line.substring(1));
            }
            return this.addLenient("", line);
        }

        public Builder add(String line) {
            int n = line.indexOf(":");
            if (n == -1) {
                throw new IllegalArgumentException("Unexpected header: " + line);
            }
            return this.add(line.substring(0, n).trim(), line.substring(n + 1));
        }

        public Builder add(String name, String value) {
            this.checkNameAndValue(name, value);
            return this.addLenient(name, value);
        }

        Builder addLenient(String name, String value) {
            this.namesAndValues.add(name);
            this.namesAndValues.add(value.trim());
            return this;
        }

        public Builder removeAll(String name) {
            for (int i = 0; i < this.namesAndValues.size(); i += 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                this.namesAndValues.remove(i);
                this.namesAndValues.remove(i);
                i -= 2;
            }
            return this;
        }

        public Builder set(String name, String value) {
            this.checkNameAndValue(name, value);
            this.removeAll(name);
            this.addLenient(name, value);
            return this;
        }

        private void checkNameAndValue(String name, String value) {
            char c2;
            int n;
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int n2 = name.length();
            for (n = 0; n < n2; ++n) {
                c2 = name.charAt(n);
                if (c2 > ' ' && c2 < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", c2, n, name));
            }
            if (value == null) {
                throw new NullPointerException("value for name " + name + " == null");
            }
            n2 = value.length();
            for (n = 0; n < n2; ++n) {
                c2 = value.charAt(n);
                if ((c2 > '\u001f' || c2 == '\t') && c2 < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", c2, n, name, value));
            }
        }

        public String get(String name) {
            for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                return this.namesAndValues.get(i + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

