/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.Buffer;

public final class HttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String QUERY_COMPONENT_ENCODE_SET = " \"'<>#&=";
    static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    final String scheme;
    private final String username;
    private final String password;
    final String host;
    final int port;
    private final List<String> pathSegments;
    @Nullable
    private final List<String> queryNamesAndValues;
    @Nullable
    private final String fragment;
    private final String url;

    HttpUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.username = HttpUrl.percentDecode(builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        this.queryNamesAndValues = builder.encodedQueryNamesAndValues != null ? this.percentDecode(builder.encodedQueryNamesAndValues, true) : null;
        this.fragment = builder.encodedFragment != null ? HttpUrl.percentDecode(builder.encodedFragment, false) : null;
        this.url = builder.toString();
    }

    public URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public URI uri() {
        String string = this.newBuilder().reencodeForUri().toString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                String string2 = string.replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", FRAGMENT_ENCODE_SET);
                return URI.create(string2);
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n = this.scheme.length() + 3;
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), ":@");
        return this.url.substring(n, n2);
    }

    public String username() {
        return this.username;
    }

    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n = this.url.indexOf(58, this.scheme.length() + 3) + 1;
        int n2 = this.url.indexOf(64);
        return this.url.substring(n, n2);
    }

    public String password() {
        return this.password;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public static int defaultPort(String scheme) {
        if (scheme.equals("http")) {
            return 80;
        }
        if (scheme.equals("https")) {
            return 443;
        }
        return -1;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public String encodedPath() {
        int n = this.url.indexOf(47, this.scheme.length() + 3);
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), "?#");
        return this.url.substring(n, n2);
    }

    static void pathSegmentsToString(StringBuilder out, List<String> pathSegments) {
        int n = pathSegments.size();
        for (int i = 0; i < n; ++i) {
            out.append('/');
            out.append(pathSegments.get(i));
        }
    }

    public List<String> encodedPathSegments() {
        int n = this.url.indexOf(47, this.scheme.length() + 3);
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), "?#");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n;
        while (n3 < n2) {
            int n4 = Util.delimiterOffset(this.url, ++n3, n2, '/');
            arrayList.add(this.url.substring(n3, n4));
            n3 = n4;
        }
        return arrayList;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    @Nullable
    public String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n = this.url.indexOf(63) + 1;
        int n2 = Util.delimiterOffset(this.url, n, this.url.length(), '#');
        return this.url.substring(n, n2);
    }

    static void namesAndValuesToQueryString(StringBuilder out, List<String> namesAndValues) {
        int n = namesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            String string = namesAndValues.get(i);
            String string2 = namesAndValues.get(i + 1);
            if (i > 0) {
                out.append('&');
            }
            out.append(string);
            if (string2 == null) continue;
            out.append('=');
            out.append(string2);
        }
    }

    static List<String> queryStringToNamesAndValues(String encodedQuery) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n <= encodedQuery.length()) {
            int n2;
            int n3 = encodedQuery.indexOf(38, n);
            if (n3 == -1) {
                n3 = encodedQuery.length();
            }
            if ((n2 = encodedQuery.indexOf(61, n)) == -1 || n2 > n3) {
                arrayList.add(encodedQuery.substring(n, n3));
                arrayList.add(null);
            } else {
                arrayList.add(encodedQuery.substring(n, n2));
                arrayList.add(encodedQuery.substring(n2 + 1, n3));
            }
            n = n3 + 1;
        }
        return arrayList;
    }

    @Nullable
    public String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    public int querySize() {
        return this.queryNamesAndValues != null ? this.queryNamesAndValues.size() / 2 : 0;
    }

    @Nullable
    public String queryParameter(String name) {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            if (!name.equals(this.queryNamesAndValues.get(i))) continue;
            return this.queryNamesAndValues.get(i + 1);
        }
        return null;
    }

    public Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            linkedHashSet.add(this.queryNamesAndValues.get(i));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public List<String> queryParameterValues(String name) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            if (!name.equals(this.queryNamesAndValues.get(i))) continue;
            arrayList.add(this.queryNamesAndValues.get(i + 1));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String queryParameterName(int index) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(index * 2);
    }

    public String queryParameterValue(int index) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(index * 2 + 1);
    }

    @Nullable
    public String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int n = this.url.indexOf(35) + 1;
        return this.url.substring(n);
    }

    @Nullable
    public String fragment() {
        return this.fragment;
    }

    public String redact() {
        return this.newBuilder("/...").username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public HttpUrl resolve(String link) {
        Builder builder = this.newBuilder(link);
        return builder != null ? builder.build() : null;
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.scheme = this.scheme;
        builder.encodedUsername = this.encodedUsername();
        builder.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        builder.port = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        builder.encodedPathSegments.clear();
        builder.encodedPathSegments.addAll(this.encodedPathSegments());
        builder.encodedQuery(this.encodedQuery());
        builder.encodedFragment = this.encodedFragment();
        return builder;
    }

    @Nullable
    public Builder newBuilder(String link) {
        Builder builder = new Builder();
        Builder.ParseResult parseResult = builder.parse(this, link);
        return parseResult == Builder.ParseResult.SUCCESS ? builder : null;
    }

    @Nullable
    public static HttpUrl parse(String url) {
        Builder builder = new Builder();
        Builder.ParseResult parseResult = builder.parse(null, url);
        return parseResult == Builder.ParseResult.SUCCESS ? builder.build() : null;
    }

    @Nullable
    public static HttpUrl get(URL url) {
        return HttpUrl.parse(url.toString());
    }

    static HttpUrl getChecked(String url) {
        Builder builder = new Builder();
        Builder.ParseResult parseResult = builder.parse(null, url);
        switch (parseResult) {
            case SUCCESS: {
                return builder.build();
            }
            case INVALID_HOST: {
                throw new UnknownHostException("Invalid host: " + url);
            }
        }
        throw new MalformedURLException("Invalid URL: " + (Object)((Object)parseResult) + " for " + url);
    }

    @Nullable
    public static HttpUrl get(URI uri) {
        return HttpUrl.parse(uri.toString());
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof HttpUrl && ((HttpUrl)other).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    @Nullable
    public String topPrivateDomain() {
        if (Util.verifyAsIpAddress(this.host)) {
            return null;
        }
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    static String percentDecode(String encoded, boolean plusIsSpace) {
        return HttpUrl.percentDecode(encoded, 0, encoded.length(), plusIsSpace);
    }

    private List<String> percentDecode(List<String> list, boolean plusIsSpace) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            arrayList.add(string != null ? HttpUrl.percentDecode(string, plusIsSpace) : null);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String percentDecode(String encoded, int pos, int limit, boolean plusIsSpace) {
        for (int i = pos; i < limit; ++i) {
            char c2 = encoded.charAt(i);
            if (c2 != '%' && (c2 != '+' || !plusIsSpace)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(encoded, pos, i);
            HttpUrl.percentDecode(buffer, encoded, i, limit, plusIsSpace);
            return buffer.readUtf8();
        }
        return encoded.substring(pos, limit);
    }

    static void percentDecode(Buffer out, String encoded, int pos, int limit, boolean plusIsSpace) {
        int n;
        for (int i = pos; i < limit; i += Character.charCount(n)) {
            n = encoded.codePointAt(i);
            if (n == 37 && i + 2 < limit) {
                int n2 = Util.decodeHexDigit(encoded.charAt(i + 1));
                int n3 = Util.decodeHexDigit(encoded.charAt(i + 2));
                if (n2 != -1 && n3 != -1) {
                    out.writeByte((n2 << 4) + n3);
                    i += 2;
                    continue;
                }
            } else if (n == 43 && plusIsSpace) {
                out.writeByte(32);
                continue;
            }
            out.writeUtf8CodePoint(n);
        }
    }

    static boolean percentEncoded(String encoded, int pos, int limit) {
        return pos + 2 < limit && encoded.charAt(pos) == '%' && Util.decodeHexDigit(encoded.charAt(pos + 1)) != -1 && Util.decodeHexDigit(encoded.charAt(pos + 2)) != -1;
    }

    static String canonicalize(String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        int n;
        for (int i = pos; i < limit; i += Character.charCount(n)) {
            n = input.codePointAt(i);
            if (!(n < 32 || n == 127 || n >= 128 && asciiOnly || encodeSet.indexOf(n) != -1 || n == 37 && (!alreadyEncoded || strict && !HttpUrl.percentEncoded(input, i, limit))) && (n != 43 || !plusIsSpace)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(input, pos, i);
            HttpUrl.canonicalize(buffer, input, i, limit, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
            return buffer.readUtf8();
        }
        return input.substring(pos, limit);
    }

    static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        int n;
        Buffer buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(n)) {
            n = input.codePointAt(i);
            if (alreadyEncoded && (n == 9 || n == 10 || n == 12 || n == 13)) continue;
            if (n == 43 && plusIsSpace) {
                out.writeUtf8(alreadyEncoded ? "+" : "%2B");
                continue;
            }
            if (n < 32 || n == 127 || n >= 128 && asciiOnly || encodeSet.indexOf(n) != -1 || n == 37 && (!alreadyEncoded || strict && !HttpUrl.percentEncoded(input, i, limit))) {
                if (buffer == null) {
                    buffer = new Buffer();
                }
                if (charset == null || charset.equals(Util.UTF_8)) {
                    buffer.writeUtf8CodePoint(n);
                } else {
                    buffer.writeString(input, i, i + Character.charCount(n), charset);
                }
                while (!buffer.exhausted()) {
                    int n2 = buffer.readByte() & 0xFF;
                    out.writeByte(37);
                    out.writeByte(HEX_DIGITS[n2 >> 4 & 0xF]);
                    out.writeByte(HEX_DIGITS[n2 & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(n);
        }
    }

    static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        return HttpUrl.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
    }

    static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly) {
        return HttpUrl.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, null);
    }

    public static final class Builder {
        @Nullable
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        @Nullable
        String host;
        int port = -1;
        final List<String> encodedPathSegments = new ArrayList<String>();
        @Nullable
        List<String> encodedQueryNamesAndValues;
        @Nullable
        String encodedFragment;

        public Builder() {
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        public Builder scheme(String scheme) {
            if (scheme == null) {
                throw new NullPointerException("scheme == null");
            }
            if (scheme.equalsIgnoreCase("http")) {
                this.scheme = "http";
            } else if (scheme.equalsIgnoreCase("https")) {
                this.scheme = "https";
            } else {
                throw new IllegalArgumentException("unexpected scheme: " + scheme);
            }
            return this;
        }

        public Builder username(String username) {
            if (username == null) {
                throw new NullPointerException("username == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(username, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedUsername(String encodedUsername) {
            if (encodedUsername == null) {
                throw new NullPointerException("encodedUsername == null");
            }
            this.encodedUsername = HttpUrl.canonicalize(encodedUsername, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder password(String password) {
            if (password == null) {
                throw new NullPointerException("password == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(password, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedPassword(String encodedPassword) {
            if (encodedPassword == null) {
                throw new NullPointerException("encodedPassword == null");
            }
            this.encodedPassword = HttpUrl.canonicalize(encodedPassword, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder host(String host) {
            if (host == null) {
                throw new NullPointerException("host == null");
            }
            String string = Builder.canonicalizeHost(host, 0, host.length());
            if (string == null) {
                throw new IllegalArgumentException("unexpected host: " + host);
            }
            this.host = string;
            return this;
        }

        public Builder port(int port) {
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("unexpected port: " + port);
            }
            this.port = port;
            return this;
        }

        int effectivePort() {
            return this.port != -1 ? this.port : HttpUrl.defaultPort(this.scheme);
        }

        public Builder addPathSegment(String pathSegment) {
            if (pathSegment == null) {
                throw new NullPointerException("pathSegment == null");
            }
            this.push(pathSegment, 0, pathSegment.length(), false, false);
            return this;
        }

        public Builder addPathSegments(String pathSegments) {
            if (pathSegments == null) {
                throw new NullPointerException("pathSegments == null");
            }
            return this.addPathSegments(pathSegments, false);
        }

        public Builder addEncodedPathSegment(String encodedPathSegment) {
            if (encodedPathSegment == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            this.push(encodedPathSegment, 0, encodedPathSegment.length(), false, true);
            return this;
        }

        public Builder addEncodedPathSegments(String encodedPathSegments) {
            if (encodedPathSegments == null) {
                throw new NullPointerException("encodedPathSegments == null");
            }
            return this.addPathSegments(encodedPathSegments, true);
        }

        private Builder addPathSegments(String pathSegments, boolean alreadyEncoded) {
            int n;
            int n2 = 0;
            do {
                boolean bl = (n = Util.delimiterOffset(pathSegments, n2, pathSegments.length(), "/\\")) < pathSegments.length();
                this.push(pathSegments, n2, n, bl, alreadyEncoded);
            } while ((n2 = n + 1) <= pathSegments.length());
            return this;
        }

        public Builder setPathSegment(int index, String pathSegment) {
            if (pathSegment == null) {
                throw new NullPointerException("pathSegment == null");
            }
            String string = HttpUrl.canonicalize(pathSegment, 0, pathSegment.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, false, false, false, true, null);
            if (this.isDot(string) || this.isDotDot(string)) {
                throw new IllegalArgumentException("unexpected path segment: " + pathSegment);
            }
            this.encodedPathSegments.set(index, string);
            return this;
        }

        public Builder setEncodedPathSegment(int index, String encodedPathSegment) {
            if (encodedPathSegment == null) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            String string = HttpUrl.canonicalize(encodedPathSegment, 0, encodedPathSegment.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, true, false, false, true, null);
            this.encodedPathSegments.set(index, string);
            if (this.isDot(string) || this.isDotDot(string)) {
                throw new IllegalArgumentException("unexpected path segment: " + encodedPathSegment);
            }
            return this;
        }

        public Builder removePathSegment(int index) {
            this.encodedPathSegments.remove(index);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        public Builder encodedPath(String encodedPath) {
            if (encodedPath == null) {
                throw new NullPointerException("encodedPath == null");
            }
            if (!encodedPath.startsWith("/")) {
                throw new IllegalArgumentException("unexpected encodedPath: " + encodedPath);
            }
            this.resolvePath(encodedPath, 0, encodedPath.length());
            return this;
        }

        public Builder query(@Nullable String query) {
            this.encodedQueryNamesAndValues = query != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(query, HttpUrl.QUERY_ENCODE_SET, false, false, true, true)) : null;
            return this;
        }

        public Builder encodedQuery(@Nullable String encodedQuery) {
            this.encodedQueryNamesAndValues = encodedQuery != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(encodedQuery, HttpUrl.QUERY_ENCODE_SET, true, false, true, true)) : null;
            return this;
        }

        public Builder addQueryParameter(String name, @Nullable String value) {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(name, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
            this.encodedQueryNamesAndValues.add(value != null ? HttpUrl.canonicalize(value, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null);
            return this;
        }

        public Builder addEncodedQueryParameter(String encodedName, @Nullable String encodedValue) {
            if (encodedName == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(encodedName, HttpUrl.QUERY_COMPONENT_ENCODE_SET, true, false, true, true));
            this.encodedQueryNamesAndValues.add(encodedValue != null ? HttpUrl.canonicalize(encodedValue, HttpUrl.QUERY_COMPONENT_ENCODE_SET, true, false, true, true) : null);
            return this;
        }

        public Builder setQueryParameter(String name, @Nullable String value) {
            this.removeAllQueryParameters(name);
            this.addQueryParameter(name, value);
            return this;
        }

        public Builder setEncodedQueryParameter(String encodedName, @Nullable String encodedValue) {
            this.removeAllEncodedQueryParameters(encodedName);
            this.addEncodedQueryParameter(encodedName, encodedValue);
            return this;
        }

        public Builder removeAllQueryParameters(String name) {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            String string = HttpUrl.canonicalize(name, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
            this.removeAllCanonicalQueryParameters(string);
            return this;
        }

        public Builder removeAllEncodedQueryParameters(String encodedName) {
            if (encodedName == null) {
                throw new NullPointerException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(encodedName, HttpUrl.QUERY_COMPONENT_ENCODE_SET, true, false, true, true));
            return this;
        }

        private void removeAllCanonicalQueryParameters(String canonicalName) {
            for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!canonicalName.equals(this.encodedQueryNamesAndValues.get(i))) continue;
                this.encodedQueryNamesAndValues.remove(i + 1);
                this.encodedQueryNamesAndValues.remove(i);
                if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        public Builder fragment(@Nullable String fragment) {
            this.encodedFragment = fragment != null ? HttpUrl.canonicalize(fragment, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            return this;
        }

        public Builder encodedFragment(@Nullable String encodedFragment) {
            this.encodedFragment = encodedFragment != null ? HttpUrl.canonicalize(encodedFragment, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            return this;
        }

        Builder reencodeForUri() {
            String string;
            int n;
            int n2 = this.encodedPathSegments.size();
            for (n = 0; n < n2; ++n) {
                string = this.encodedPathSegments.get(n);
                this.encodedPathSegments.set(n, HttpUrl.canonicalize(string, HttpUrl.PATH_SEGMENT_ENCODE_SET_URI, true, true, false, true));
            }
            if (this.encodedQueryNamesAndValues != null) {
                n2 = this.encodedQueryNamesAndValues.size();
                for (n = 0; n < n2; ++n) {
                    string = this.encodedQueryNamesAndValues.get(n);
                    if (string == null) continue;
                    this.encodedQueryNamesAndValues.set(n, HttpUrl.canonicalize(string, HttpUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true, true));
                }
            }
            if (this.encodedFragment != null) {
                this.encodedFragment = HttpUrl.canonicalize(this.encodedFragment, HttpUrl.FRAGMENT_ENCODE_SET_URI, true, true, false, false);
            }
            return this;
        }

        public HttpUrl build() {
            if (this.scheme == null) {
                throw new IllegalStateException("scheme == null");
            }
            if (this.host == null) {
                throw new IllegalStateException("host == null");
            }
            return new HttpUrl(this);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme);
            stringBuilder.append("://");
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.encodedPassword);
                }
                stringBuilder.append('@');
            }
            if (this.host.indexOf(58) != -1) {
                stringBuilder.append('[');
                stringBuilder.append(this.host);
                stringBuilder.append(']');
            } else {
                stringBuilder.append(this.host);
            }
            int n = this.effectivePort();
            if (n != HttpUrl.defaultPort(this.scheme)) {
                stringBuilder.append(':');
                stringBuilder.append(n);
            }
            HttpUrl.pathSegmentsToString(stringBuilder, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder.append('?');
                HttpUrl.namesAndValuesToQueryString(stringBuilder, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.encodedFragment);
            }
            return stringBuilder.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ParseResult parse(@Nullable HttpUrl base, String input) {
            int n;
            int n2;
            int n3;
            int n4;
            block19: {
                n4 = Util.skipLeadingAsciiWhitespace(input, 0, input.length());
                int n5 = Builder.schemeDelimiterOffset(input, n4, n3 = Util.skipTrailingAsciiWhitespace(input, n4, input.length()));
                if (n5 != -1) {
                    if (input.regionMatches(true, n4, "https:", 0, 6)) {
                        this.scheme = "https";
                        n4 += "https:".length();
                    } else {
                        if (!input.regionMatches(true, n4, "http:", 0, 5)) return ParseResult.UNSUPPORTED_SCHEME;
                        this.scheme = "http";
                        n4 += "http:".length();
                    }
                } else {
                    if (base == null) return ParseResult.MISSING_SCHEME;
                    this.scheme = base.scheme;
                }
                boolean bl = false;
                boolean bl2 = false;
                int n6 = Builder.slashCount(input, n4, n3);
                if (n6 >= 2 || base == null || !base.scheme.equals(this.scheme)) {
                    n4 += n6;
                    while (true) {
                        n = (n2 = Util.delimiterOffset(input, n4, n3, "@/\\?#")) != n3 ? (int)input.charAt(n2) : -1;
                        switch (n) {
                            case 64: {
                                int n7;
                                if (!bl2) {
                                    n7 = Util.delimiterOffset(input, n4, n2, ':');
                                    String string = HttpUrl.canonicalize(input, n4, n7, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    String string2 = this.encodedUsername = bl ? this.encodedUsername + "%40" + string : string;
                                    if (n7 != n2) {
                                        bl2 = true;
                                        this.encodedPassword = HttpUrl.canonicalize(input, n7 + 1, n2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    }
                                    bl = true;
                                } else {
                                    this.encodedPassword = this.encodedPassword + "%40" + HttpUrl.canonicalize(input, n4, n2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                n4 = n2 + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                int n7 = Builder.portColonOffset(input, n4, n2);
                                if (n7 + 1 < n2) {
                                    this.host = Builder.canonicalizeHost(input, n4, n7);
                                    this.port = Builder.parsePort(input, n7 + 1, n2);
                                    if (this.port == -1) {
                                        return ParseResult.INVALID_PORT;
                                    }
                                } else {
                                    this.host = Builder.canonicalizeHost(input, n4, n7);
                                    this.port = HttpUrl.defaultPort(this.scheme);
                                }
                                if (this.host == null) {
                                    return ParseResult.INVALID_HOST;
                                }
                                n4 = n2;
                                break block19;
                            }
                        }
                    }
                }
                this.encodedUsername = base.encodedUsername();
                this.encodedPassword = base.encodedPassword();
                this.host = base.host;
                this.port = base.port;
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll(base.encodedPathSegments());
                if (n4 == n3 || input.charAt(n4) == '#') {
                    this.encodedQuery(base.encodedQuery());
                }
            }
            n2 = Util.delimiterOffset(input, n4, n3, "?#");
            this.resolvePath(input, n4, n2);
            n4 = n2;
            if (n4 < n3 && input.charAt(n4) == '?') {
                n = Util.delimiterOffset(input, n4, n3, '#');
                this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(input, n4 + 1, n, HttpUrl.QUERY_ENCODE_SET, true, false, true, true, null));
                n4 = n;
            }
            if (n4 >= n3 || input.charAt(n4) != '#') return ParseResult.SUCCESS;
            this.encodedFragment = HttpUrl.canonicalize(input, n4 + 1, n3, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
            return ParseResult.SUCCESS;
        }

        private void resolvePath(String input, int pos, int limit) {
            if (pos == limit) {
                return;
            }
            char c2 = input.charAt(pos);
            if (c2 == '/' || c2 == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
                ++pos;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            }
            int n = pos;
            while (n < limit) {
                int n2 = Util.delimiterOffset(input, n, limit, "/\\");
                boolean bl = n2 < limit;
                this.push(input, n, n2, bl, true);
                n = n2;
                if (!bl) continue;
                ++n;
            }
        }

        private void push(String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
            String string = HttpUrl.canonicalize(input, pos, limit, HttpUrl.PATH_SEGMENT_ENCODE_SET, alreadyEncoded, false, false, true, null);
            if (this.isDot(string)) {
                return;
            }
            if (this.isDotDot(string)) {
                this.pop();
                return;
            }
            if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, string);
            } else {
                this.encodedPathSegments.add(string);
            }
            if (addTrailingSlash) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private boolean isDot(String input) {
            return input.equals(".") || input.equalsIgnoreCase("%2e");
        }

        private boolean isDotDot(String input) {
            return input.equals("..") || input.equalsIgnoreCase("%2e.") || input.equalsIgnoreCase(".%2e") || input.equalsIgnoreCase("%2e%2e");
        }

        private void pop() {
            String string = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            if (string.isEmpty() && !this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            } else {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private static int schemeDelimiterOffset(String input, int pos, int limit) {
            if (limit - pos < 2) {
                return -1;
            }
            char c2 = input.charAt(pos);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                return -1;
            }
            for (int i = pos + 1; i < limit; ++i) {
                char c3 = input.charAt(i);
                if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || c3 == '+' || c3 == '-' || c3 == '.') continue;
                if (c3 == ':') {
                    return i;
                }
                return -1;
            }
            return -1;
        }

        private static int slashCount(String input, int pos, int limit) {
            char c2;
            int n = 0;
            while (pos < limit && ((c2 = input.charAt(pos)) == '\\' || c2 == '/')) {
                ++n;
                ++pos;
            }
            return n;
        }

        private static int portColonOffset(String input, int pos, int limit) {
            block4: for (int i = pos; i < limit; ++i) {
                switch (input.charAt(i)) {
                    case '[': {
                        while (++i < limit && input.charAt(i) != ']') {
                        }
                        continue block4;
                    }
                    case ':': {
                        return i;
                    }
                }
            }
            return limit;
        }

        private static String canonicalizeHost(String input, int pos, int limit) {
            String string = HttpUrl.percentDecode(input, pos, limit, false);
            return Util.canonicalizeHost(string);
        }

        private static int parsePort(String input, int pos, int limit) {
            try {
                String string = HttpUrl.canonicalize(input, pos, limit, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null);
                int n = Integer.parseInt(string);
                if (n > 0 && n <= 65535) {
                    return n;
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        static enum ParseResult {
            SUCCESS,
            MISSING_SCHEME,
            UNSUPPORTED_SCHEME,
            INVALID_PORT,
            INVALID_HOST;

        }
    }
}

