/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.create(null, EMPTY_BYTE_ARRAY);
    public static final RequestBody EMPTY_REQUEST = RequestBody.create(null, EMPTY_BYTE_ARRAY);
    private static final ByteString UTF_8_BOM = ByteString.decodeHex("efbbbf");
    private static final ByteString UTF_16_BE_BOM = ByteString.decodeHex("feff");
    private static final ByteString UTF_16_LE_BOM = ByteString.decodeHex("fffe");
    private static final ByteString UTF_32_BE_BOM = ByteString.decodeHex("0000ffff");
    private static final ByteString UTF_32_LE_BOM = ByteString.decodeHex("ffff0000");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final Charset UTF_16_BE = Charset.forName("UTF-16BE");
    private static final Charset UTF_16_LE = Charset.forName("UTF-16LE");
    private static final Charset UTF_32_BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32_LE = Charset.forName("UTF-32LE");
    public static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    public static final Comparator<String> NATURAL_ORDER = new Comparator<String>(){

        @Override
        public int compare(String a2, String b2) {
            return a2.compareTo(b2);
        }
    };
    private static final Pattern VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    private Util() {
    }

    public static void checkOffsetAndCount(long arrayLength, long offset, long count) {
        if ((offset | count) < 0L || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (AssertionError assertionError) {
                if (!Util.isAndroidGetsocknameError(assertionError)) {
                    throw assertionError;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean discard(Source source, int timeout, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, timeout, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean skipAll(Source source, int duration, TimeUnit timeUnit) {
        long l = System.nanoTime();
        long l2 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(l + Math.min(l2, timeUnit.toNanos(duration)));
        try {
            Buffer buffer = new Buffer();
            while (source.read(buffer, 8192L) != -1L) {
                buffer.clear();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedIOException interruptedIOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (l2 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l + l2);
            }
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> immutableList(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList((Object[])elements.clone()));
    }

    public static ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, name);
                thread.setDaemon(daemon);
                return thread;
            }
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] first, String[] second) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string : first) {
            for (String string2 : second) {
                if (comparator.compare(string, string2) != 0) continue;
                arrayList.add(string);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] first, String[] second) {
        if (first == null || second == null || first.length == 0 || second.length == 0) {
            return false;
        }
        for (String string : first) {
            for (String string2 : second) {
                if (comparator.compare(string, string2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String hostHeader(HttpUrl url, boolean includeDefaultPort) {
        String string = url.host().contains(":") ? "[" + url.host() + "]" : url.host();
        return includeDefaultPort || url.port() != HttpUrl.defaultPort(url.scheme()) ? string + ":" + url.port() : string;
    }

    public static String toHumanReadableAscii(String s) {
        int n;
        int n2 = s.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = s.codePointAt(i);
            if (n > 31 && n < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(s, 0, i);
            for (int j = i; j < n2; j += Character.charCount(n)) {
                n = s.codePointAt(j);
                buffer.writeUtf8CodePoint(n > 31 && n < 127 ? n : 63);
            }
            return buffer.readUtf8();
        }
        return s;
    }

    public static boolean isAndroidGetsocknameError(AssertionError e2) {
        return ((Throwable)((Object)e2)).getCause() != null && ((Throwable)((Object)e2)).getMessage() != null && ((Throwable)((Object)e2)).getMessage().contains("getsockname failed");
    }

    public static int indexOf(Comparator<String> comparator, String[] array, String value) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (comparator.compare(array[i], value) != 0) continue;
            return i;
        }
        return -1;
    }

    public static String[] concat(String[] array, String value) {
        String[] stringArray = new String[array.length + 1];
        System.arraycopy(array, 0, stringArray, 0, array.length);
        stringArray[stringArray.length - 1] = value;
        return stringArray;
    }

    public static int skipLeadingAsciiWhitespace(String input, int pos, int limit) {
        block3: for (int i = pos; i < limit; ++i) {
            switch (input.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return limit;
    }

    public static int skipTrailingAsciiWhitespace(String input, int pos, int limit) {
        block3: for (int i = limit - 1; i >= pos; --i) {
            switch (input.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i + 1;
                }
            }
        }
        return pos;
    }

    public static String trimSubstring(String string, int pos, int limit) {
        int n = Util.skipLeadingAsciiWhitespace(string, pos, limit);
        int n2 = Util.skipTrailingAsciiWhitespace(string, n, limit);
        return string.substring(n, n2);
    }

    public static int delimiterOffset(String input, int pos, int limit, String delimiters) {
        for (int i = pos; i < limit; ++i) {
            if (delimiters.indexOf(input.charAt(i)) == -1) continue;
            return i;
        }
        return limit;
    }

    public static int delimiterOffset(String input, int pos, int limit, char delimiter) {
        for (int i = pos; i < limit; ++i) {
            if (input.charAt(i) != delimiter) continue;
            return i;
        }
        return limit;
    }

    public static String canonicalizeHost(String host) {
        if (host.contains(":")) {
            InetAddress inetAddress;
            InetAddress inetAddress2 = inetAddress = host.startsWith("[") && host.endsWith("]") ? Util.decodeIpv6(host, 1, host.length() - 1) : Util.decodeIpv6(host, 0, host.length());
            if (inetAddress == null) {
                return null;
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length == 16) {
                return Util.inet6AddressToAscii(byArray);
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + "'"));
        }
        try {
            String string = IDN.toASCII(host).toLowerCase(Locale.US);
            if (string.isEmpty()) {
                return null;
            }
            if (Util.containsInvalidHostnameAsciiCodes(string)) {
                return null;
            }
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean containsInvalidHostnameAsciiCodes(String hostnameAscii) {
        for (int i = 0; i < hostnameAscii.length(); ++i) {
            char c2 = hostnameAscii.charAt(i);
            if (c2 <= '\u001f' || c2 >= '\u007f') {
                return true;
            }
            if (" #%/:?@[\\]".indexOf(c2) == -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String input) {
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c2 = input.charAt(i);
            if (c2 > '\u001f' && c2 < '\u007f') continue;
            return i;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String host) {
        return VERIFY_AS_IP_ADDRESS.matcher(host).matches();
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public static Charset bomAwareCharset(BufferedSource source, Charset charset) {
        if (source.rangeEquals(0L, UTF_8_BOM)) {
            source.skip(UTF_8_BOM.size());
            return UTF_8;
        }
        if (source.rangeEquals(0L, UTF_16_BE_BOM)) {
            source.skip(UTF_16_BE_BOM.size());
            return UTF_16_BE;
        }
        if (source.rangeEquals(0L, UTF_16_LE_BOM)) {
            source.skip(UTF_16_LE_BOM.size());
            return UTF_16_LE;
        }
        if (source.rangeEquals(0L, UTF_32_BE_BOM)) {
            source.skip(UTF_32_BE_BOM.size());
            return UTF_32_BE;
        }
        if (source.rangeEquals(0L, UTF_32_LE_BOM)) {
            source.skip(UTF_32_LE_BOM.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static int checkDuration(String name, long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException(name + " < 0");
        }
        if (unit == null) {
            throw new NullPointerException("unit == null");
        }
        long l = unit.toMillis(duration);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(name + " too large.");
        }
        if (l == 0L && duration > 0L) {
            throw new IllegalArgumentException(name + " too small.");
        }
        return (int)l;
    }

    public static AssertionError assertionError(String message, Exception e2) {
        return (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)message))).initCause(e2));
    }

    public static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    @Nullable
    private static InetAddress decodeIpv6(String input, int pos, int limit) {
        byte[] byArray = new byte[16];
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = pos;
        while (n4 < limit) {
            char c2;
            int n5;
            if (n == byArray.length) {
                return null;
            }
            if (n4 + 2 <= limit && input.regionMatches(n4, "::", 0, 2)) {
                if (n2 != -1) {
                    return null;
                }
                n2 = n += 2;
                if ((n4 += 2) == limit) {
                    break;
                }
            } else if (n != 0 && !input.regionMatches(n4, ":", 0, 1)) {
                if (input.regionMatches(n4, ".", 0, 1)) {
                    if (!Util.decodeIpv4Suffix(input, n3, limit, byArray, n - 2)) {
                        return null;
                    }
                    n += 2;
                    break;
                }
                return null;
            }
            int n6 = 0;
            n3 = ++n4;
            while (n4 < limit && (n5 = Util.decodeHexDigit(c2 = input.charAt(n4))) != -1) {
                n6 = (n6 << 4) + n5;
                ++n4;
            }
            c2 = n4 - n3;
            if (c2 == '\u0000' || c2 > '\u0004') {
                return null;
            }
            byArray[n++] = (byte)(n6 >>> 8 & 0xFF);
            byArray[n++] = (byte)(n6 & 0xFF);
        }
        if (n != byArray.length) {
            if (n2 == -1) {
                return null;
            }
            System.arraycopy(byArray, n2, byArray, byArray.length - (n - n2), n - n2);
            Arrays.fill(byArray, n2, n2 + (byArray.length - n), (byte)0);
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    private static boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
        int n = addressOffset;
        int n2 = pos;
        while (n2 < limit) {
            int n3;
            if (n == address.length) {
                return false;
            }
            if (n != addressOffset && input.charAt(n2) != '.') {
                return false;
            }
            int n4 = 0;
            int n5 = ++n2;
            while (n2 < limit && (n3 = input.charAt(n2)) >= 48 && n3 <= 57) {
                if (n4 == 0 && n5 != n2) {
                    return false;
                }
                if ((n4 = n4 * 10 + n3 - 48) > 255) {
                    return false;
                }
                ++n2;
            }
            n3 = n2 - n5;
            if (n3 == 0) {
                return false;
            }
            address[n++] = (byte)n4;
        }
        return n == addressOffset + 4;
    }

    private static String inet6AddressToAscii(byte[] address) {
        int n;
        int n2;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < address.length; i += 2) {
            n2 = i;
            while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                i += 2;
            }
            n = i - n2;
            if (n <= n4 || n < 4) continue;
            n3 = n2;
            n4 = n;
        }
        Buffer buffer = new Buffer();
        n2 = 0;
        while (n2 < address.length) {
            if (n2 == n3) {
                buffer.writeByte(58);
                if ((n2 += n4) != 16) continue;
                buffer.writeByte(58);
                continue;
            }
            if (n2 > 0) {
                buffer.writeByte(58);
            }
            n = (address[n2] & 0xFF) << 8 | address[n2 + 1] & 0xFF;
            buffer.writeHexadecimalUnsignedLong(n);
            n2 += 2;
        }
        return buffer.readUtf8();
    }
}

