/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.http.HttpDate;
import okhttp3.internal.http.HttpHeaders;

public final class CacheStrategy {
    @Nullable
    public final Request networkRequest;
    @Nullable
    public final Response cacheResponse;

    CacheStrategy(Request networkRequest, Response cacheResponse) {
        this.networkRequest = networkRequest;
        this.cacheResponse = cacheResponse;
    }

    public static boolean isCacheable(Response response, Request request) {
        switch (response.code()) {
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 308: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: {
                break;
            }
            case 302: 
            case 307: {
                if (response.header("Expires") != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic() || response.cacheControl().isPrivate()) break;
            }
            default: {
                return false;
            }
        }
        return !response.cacheControl().noStore() && !request.cacheControl().noStore();
    }

    public static class Factory {
        final long nowMillis;
        final Request request;
        final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds = -1;

        public Factory(long nowMillis, Request request, Response cacheResponse) {
            this.nowMillis = nowMillis;
            this.request = request;
            this.cacheResponse = cacheResponse;
            if (cacheResponse != null) {
                this.sentRequestMillis = cacheResponse.sentRequestAtMillis();
                this.receivedResponseMillis = cacheResponse.receivedResponseAtMillis();
                Headers headers = cacheResponse.headers();
                int n = headers.size();
                for (int i = 0; i < n; ++i) {
                    String string = headers.name(i);
                    String string2 = headers.value(i);
                    if ("Date".equalsIgnoreCase(string)) {
                        this.servedDate = HttpDate.parse(string2);
                        this.servedDateString = string2;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(string)) {
                        this.expires = HttpDate.parse(string2);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase(string)) {
                        this.lastModified = HttpDate.parse(string2);
                        this.lastModifiedString = string2;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase(string)) {
                        this.etag = string2;
                        continue;
                    }
                    if (!"Age".equalsIgnoreCase(string)) continue;
                    this.ageSeconds = HttpHeaders.parseSeconds(string2, -1);
                }
            }
        }

        public CacheStrategy get() {
            CacheStrategy cacheStrategy = this.getCandidate();
            if (cacheStrategy.networkRequest != null && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return cacheStrategy;
        }

        private CacheStrategy getCandidate() {
            String string;
            String string2;
            if (this.cacheResponse == null) {
                return new CacheStrategy(this.request, null);
            }
            if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                return new CacheStrategy(this.request, null);
            }
            if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                return new CacheStrategy(this.request, null);
            }
            CacheControl cacheControl = this.request.cacheControl();
            if (cacheControl.noCache() || Factory.hasConditions(this.request)) {
                return new CacheStrategy(this.request, null);
            }
            CacheControl cacheControl2 = this.cacheResponse.cacheControl();
            if (cacheControl2.immutable()) {
                return new CacheStrategy(null, this.cacheResponse);
            }
            long l = this.cacheResponseAge();
            long l2 = this.computeFreshnessLifetime();
            if (cacheControl.maxAgeSeconds() != -1) {
                l2 = Math.min(l2, TimeUnit.SECONDS.toMillis(cacheControl.maxAgeSeconds()));
            }
            long l3 = 0L;
            if (cacheControl.minFreshSeconds() != -1) {
                l3 = TimeUnit.SECONDS.toMillis(cacheControl.minFreshSeconds());
            }
            long l4 = 0L;
            if (!cacheControl2.mustRevalidate() && cacheControl.maxStaleSeconds() != -1) {
                l4 = TimeUnit.SECONDS.toMillis(cacheControl.maxStaleSeconds());
            }
            if (!cacheControl2.noCache() && l + l3 < l2 + l4) {
                long l5;
                Response.Builder builder = this.cacheResponse.newBuilder();
                if (l + l3 >= l2) {
                    builder.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                }
                if (l > (l5 = 86400000L) && this.isFreshnessLifetimeHeuristic()) {
                    builder.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                }
                return new CacheStrategy(null, builder.build());
            }
            if (this.etag != null) {
                string2 = "If-None-Match";
                string = this.etag;
            } else if (this.lastModified != null) {
                string2 = "If-Modified-Since";
                string = this.lastModifiedString;
            } else if (this.servedDate != null) {
                string2 = "If-Modified-Since";
                string = this.servedDateString;
            } else {
                return new CacheStrategy(this.request, null);
            }
            Headers.Builder builder = this.request.headers().newBuilder();
            Internal.instance.addLenient(builder, string2, string);
            Request request = this.request.newBuilder().headers(builder.build()).build();
            return new CacheStrategy(request, this.cacheResponse);
        }

        private long computeFreshnessLifetime() {
            CacheControl cacheControl = this.cacheResponse.cacheControl();
            if (cacheControl.maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(cacheControl.maxAgeSeconds());
            }
            if (this.expires != null) {
                long l = this.servedDate != null ? this.servedDate.getTime() : this.receivedResponseMillis;
                long l2 = this.expires.getTime() - l;
                return l2 > 0L ? l2 : 0L;
            }
            if (this.lastModified != null && this.cacheResponse.request().url().query() == null) {
                long l = this.servedDate != null ? this.servedDate.getTime() : this.sentRequestMillis;
                long l3 = l - this.lastModified.getTime();
                return l3 > 0L ? l3 / 10L : 0L;
            }
            return 0L;
        }

        private long cacheResponseAge() {
            long l = this.servedDate != null ? Math.max(0L, this.receivedResponseMillis - this.servedDate.getTime()) : 0L;
            long l2 = this.ageSeconds != -1 ? Math.max(l, TimeUnit.SECONDS.toMillis(this.ageSeconds)) : l;
            long l3 = this.receivedResponseMillis - this.sentRequestMillis;
            long l4 = this.nowMillis - this.receivedResponseMillis;
            return l2 + l3 + l4;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            return this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
        }

        private static boolean hasConditions(Request request) {
            return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
        }
    }
}

