/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import okio.Buffer;

final class FileOperator {
    private static final int BUFFER_SIZE = 8192;
    private final byte[] byteArray = new byte[8192];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);
    private final FileChannel fileChannel;

    FileOperator(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long pos, Buffer source, long byteCount) {
        if (byteCount < 0L || byteCount > source.size()) {
            throw new IndexOutOfBoundsException();
        }
        while (byteCount > 0L) {
            try {
                int n = (int)Math.min(8192L, byteCount);
                source.read(this.byteArray, 0, n);
                this.byteBuffer.limit(n);
                do {
                    int n2 = this.fileChannel.write(this.byteBuffer, pos);
                    pos += (long)n2;
                } while (this.byteBuffer.hasRemaining());
                byteCount -= (long)n;
            }
            finally {
                this.byteBuffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(long pos, Buffer sink, long byteCount) {
        if (byteCount < 0L) {
            throw new IndexOutOfBoundsException();
        }
        while (byteCount > 0L) {
            try {
                this.byteBuffer.limit((int)Math.min(8192L, byteCount));
                if (this.fileChannel.read(this.byteBuffer, pos) == -1) {
                    throw new EOFException();
                }
                int n = this.byteBuffer.position();
                sink.write(this.byteArray, 0, n);
                pos += (long)n;
                byteCount -= (long)n;
            }
            finally {
                this.byteBuffer.clear();
            }
        }
    }
}

