/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.internal.Util;
import okhttp3.internal.cache2.FileOperator;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

final class Relay {
    private static final int SOURCE_UPSTREAM = 1;
    private static final int SOURCE_FILE = 2;
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8("OkHttp cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8("OkHttp DIRTY :(\n");
    private static final long FILE_HEADER_SIZE = 32L;
    RandomAccessFile file;
    Thread upstreamReader;
    Source upstream;
    final Buffer upstreamBuffer = new Buffer();
    long upstreamPos;
    boolean complete;
    private final ByteString metadata;
    final Buffer buffer = new Buffer();
    final long bufferMaxSize;
    int sourceCount;

    private Relay(RandomAccessFile file, Source upstream, long upstreamPos, ByteString metadata, long bufferMaxSize) {
        this.file = file;
        this.upstream = upstream;
        this.complete = upstream == null;
        this.upstreamPos = upstreamPos;
        this.metadata = metadata;
        this.bufferMaxSize = bufferMaxSize;
    }

    public static Relay edit(File file, Source upstream, ByteString metadata, long bufferMaxSize) {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        Relay relay = new Relay(randomAccessFile, upstream, 0L, metadata, bufferMaxSize);
        randomAccessFile.setLength(0L);
        relay.writeHeader(PREFIX_DIRTY, -1L, -1L);
        return relay;
    }

    public static Relay read(File file) {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileOperator fileOperator = new FileOperator(randomAccessFile.getChannel());
        Buffer buffer = new Buffer();
        fileOperator.read(0L, buffer, 32L);
        ByteString byteString = buffer.readByteString(PREFIX_CLEAN.size());
        if (!byteString.equals(PREFIX_CLEAN)) {
            throw new IOException("unreadable cache file");
        }
        long l = buffer.readLong();
        long l2 = buffer.readLong();
        Buffer buffer2 = new Buffer();
        fileOperator.read(32L + l, buffer2, l2);
        ByteString byteString2 = buffer2.readByteString();
        return new Relay(randomAccessFile, null, l, byteString2, 0L);
    }

    private void writeHeader(ByteString prefix, long upstreamSize, long metadataSize) {
        Buffer buffer = new Buffer();
        buffer.write(prefix);
        buffer.writeLong(upstreamSize);
        buffer.writeLong(metadataSize);
        if (buffer.size() != 32L) {
            throw new IllegalArgumentException();
        }
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(0L, buffer, 32L);
    }

    private void writeMetadata(long upstreamSize) {
        Buffer buffer = new Buffer();
        buffer.write(this.metadata);
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(32L + upstreamSize, buffer, this.metadata.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(long upstreamSize) {
        this.writeMetadata(upstreamSize);
        this.file.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, upstreamSize, this.metadata.size());
        this.file.getChannel().force(false);
        Relay relay = this;
        synchronized (relay) {
            this.complete = true;
        }
        Util.closeQuietly(this.upstream);
        this.upstream = null;
    }

    boolean isClosed() {
        return this.file == null;
    }

    public ByteString metadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source newSource() {
        Relay relay = this;
        synchronized (relay) {
            if (this.file == null) {
                return null;
            }
            ++this.sourceCount;
        }
        return new RelaySource();
    }

    class RelaySource
    implements Source {
        private final Timeout timeout = new Timeout();
        private FileOperator fileOperator;
        private long sourcePos;

        RelaySource() {
            this.fileOperator = new FileOperator(Relay.this.file.getChannel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer sink, long byteCount) {
            int n;
            long l;
            block27: {
                if (this.fileOperator == null) {
                    throw new IllegalStateException("closed");
                }
                Relay relay = Relay.this;
                synchronized (relay) {
                    while (this.sourcePos == (l = Relay.this.upstreamPos)) {
                        if (Relay.this.complete) {
                            return -1L;
                        }
                        if (Relay.this.upstreamReader != null) {
                            this.timeout.waitUntilNotified(Relay.this);
                            continue;
                        }
                        Relay.this.upstreamReader = Thread.currentThread();
                        n = 1;
                        break block27;
                    }
                    long l2 = l - Relay.this.buffer.size();
                    if (this.sourcePos < l2) {
                        n = 2;
                        break block27;
                    }
                    long l3 = Math.min(byteCount, l - this.sourcePos);
                    Relay.this.buffer.copyTo(sink, this.sourcePos - l2, l3);
                    this.sourcePos += l3;
                    return l3;
                }
            }
            if (n == 2) {
                long l4 = Math.min(byteCount, l - this.sourcePos);
                this.fileOperator.read(32L + this.sourcePos, sink, l4);
                this.sourcePos += l4;
                return l4;
            }
            try {
                long l5 = Relay.this.upstream.read(Relay.this.upstreamBuffer, Relay.this.bufferMaxSize);
                if (l5 == -1L) {
                    Relay.this.commit(l);
                    long l6 = -1L;
                    return l6;
                }
                long l7 = Math.min(l5, byteCount);
                Relay.this.upstreamBuffer.copyTo(sink, 0L, l7);
                this.sourcePos += l7;
                this.fileOperator.write(32L + l, Relay.this.upstreamBuffer.clone(), l5);
                Relay relay = Relay.this;
                synchronized (relay) {
                    Relay.this.buffer.write(Relay.this.upstreamBuffer, l5);
                    if (Relay.this.buffer.size() > Relay.this.bufferMaxSize) {
                        Relay.this.buffer.skip(Relay.this.buffer.size() - Relay.this.bufferMaxSize);
                    }
                    Relay.this.upstreamPos += l5;
                }
                long l8 = l7;
                return l8;
            }
            finally {
                Relay relay = Relay.this;
                synchronized (relay) {
                    Relay.this.upstreamReader = null;
                    Relay.this.notifyAll();
                }
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.fileOperator == null) {
                return;
            }
            this.fileOperator = null;
            RandomAccessFile randomAccessFile = null;
            Relay relay = Relay.this;
            synchronized (relay) {
                --Relay.this.sourceCount;
                if (Relay.this.sourceCount == 0) {
                    randomAccessFile = Relay.this.file;
                    Relay.this.file = null;
                }
            }
            if (randomAccessFile != null) {
                Util.closeQuietly(randomAccessFile);
            }
        }
    }
}

