/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.http.HttpCodec;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;

public final class StreamAllocation {
    public final Address address;
    private RouteSelector.Selection routeSelection;
    private Route route;
    private final ConnectionPool connectionPool;
    public final Call call;
    public final EventListener eventListener;
    private final Object callStackTrace;
    private final RouteSelector routeSelector;
    private int refusedStreamCount;
    private RealConnection connection;
    private boolean reportedAcquired;
    private boolean released;
    private boolean canceled;
    private HttpCodec codec;

    public StreamAllocation(ConnectionPool connectionPool, Address address, Call call, EventListener eventListener, Object callStackTrace) {
        this.connectionPool = connectionPool;
        this.address = address;
        this.call = call;
        this.eventListener = eventListener;
        this.routeSelector = new RouteSelector(address, this.routeDatabase(), call, eventListener);
        this.callStackTrace = callStackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCodec newStream(OkHttpClient client, Interceptor.Chain chain, boolean doExtensiveHealthChecks) {
        int n = chain.connectTimeoutMillis();
        int n2 = chain.readTimeoutMillis();
        int n3 = chain.writeTimeoutMillis();
        boolean bl = client.retryOnConnectionFailure();
        try {
            RealConnection realConnection = this.findHealthyConnection(n, n2, n3, bl, doExtensiveHealthChecks);
            HttpCodec httpCodec = realConnection.newCodec(client, chain, this);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                this.codec = httpCodec;
                return httpCodec;
            }
        }
        catch (IOException iOException) {
            throw new RouteException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) {
        RealConnection realConnection;
        while (true) {
            realConnection = this.findConnection(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (realConnection.successCount == 0) {
                    return realConnection;
                }
            }
            if (realConnection.isHealthy(doExtensiveHealthChecks)) break;
            this.noNewStreams();
        }
        return realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled) {
        Object object;
        Socket socket;
        RealConnection realConnection;
        boolean bl = false;
        RealConnection realConnection2 = null;
        Route route = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.released) {
                throw new IllegalStateException("released");
            }
            if (this.codec != null) {
                throw new IllegalStateException("codec != null");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            realConnection = this.connection;
            socket = this.releaseIfNoNewStreams();
            if (this.connection != null) {
                realConnection2 = this.connection;
                realConnection = null;
            }
            if (!this.reportedAcquired) {
                realConnection = null;
            }
            if (realConnection2 == null) {
                Internal.instance.get(this.connectionPool, this.address, this, null);
                if (this.connection != null) {
                    bl = true;
                    realConnection2 = this.connection;
                } else {
                    route = this.route;
                }
            }
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
        if (bl) {
            this.eventListener.connectionAcquired(this.call, realConnection2);
        }
        if (realConnection2 != null) {
            return realConnection2;
        }
        boolean bl2 = false;
        if (!(route != null || this.routeSelection != null && this.routeSelection.hasNext())) {
            bl2 = true;
            this.routeSelection = this.routeSelector.next();
        }
        Object object2 = this.connectionPool;
        synchronized (object2) {
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            if (bl2) {
                object = this.routeSelection.getAll();
                int n = object.size();
                for (int i = 0; i < n; ++i) {
                    Route route2 = object.get(i);
                    Internal.instance.get(this.connectionPool, this.address, this, route2);
                    if (this.connection == null) continue;
                    bl = true;
                    realConnection2 = this.connection;
                    this.route = route2;
                    break;
                }
            }
            if (!bl) {
                if (route == null) {
                    route = this.routeSelection.next();
                }
                this.route = route;
                this.refusedStreamCount = 0;
                realConnection2 = new RealConnection(this.connectionPool, route);
                this.acquire(realConnection2, false);
            }
        }
        if (bl) {
            this.eventListener.connectionAcquired(this.call, realConnection2);
            return realConnection2;
        }
        realConnection2.connect(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled, this.call, this.eventListener);
        this.routeDatabase().connected(realConnection2.route());
        object2 = null;
        object = this.connectionPool;
        synchronized (object) {
            this.reportedAcquired = true;
            Internal.instance.put(this.connectionPool, realConnection2);
            if (realConnection2.isMultiplexed()) {
                object2 = Internal.instance.deduplicate(this.connectionPool, this.address, this);
                realConnection2 = this.connection;
            }
        }
        Util.closeQuietly((Socket)object2);
        this.eventListener.connectionAcquired(this.call, realConnection2);
        return realConnection2;
    }

    private Socket releaseIfNoNewStreams() {
        assert (Thread.holdsLock(this.connectionPool));
        RealConnection realConnection = this.connection;
        if (realConnection != null && realConnection.noNewStreams) {
            return this.deallocate(false, false, true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFinished(boolean noNewStreams, HttpCodec codec, long bytesRead, IOException e2) {
        boolean bl;
        Socket socket;
        RealConnection realConnection;
        this.eventListener.responseBodyEnd(this.call, bytesRead);
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (codec == null || codec != this.codec) {
                throw new IllegalStateException("expected " + this.codec + " but was " + codec);
            }
            if (!noNewStreams) {
                ++this.connection.successCount;
            }
            realConnection = this.connection;
            socket = this.deallocate(noNewStreams, false, true);
            if (this.connection != null) {
                realConnection = null;
            }
            bl = this.released;
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
        if (e2 != null) {
            this.eventListener.callFailed(this.call, e2);
        } else if (bl) {
            this.eventListener.callEnd(this.call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCodec codec() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.codec;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public synchronized RealConnection connection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Socket socket;
        RealConnection realConnection;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            realConnection = this.connection;
            socket = this.deallocate(false, true, false);
            if (this.connection != null) {
                realConnection = null;
            }
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noNewStreams() {
        Socket socket;
        RealConnection realConnection;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            realConnection = this.connection;
            socket = this.deallocate(true, false, false);
            if (this.connection != null) {
                realConnection = null;
            }
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
    }

    private Socket deallocate(boolean noNewStreams, boolean released, boolean streamFinished) {
        assert (Thread.holdsLock(this.connectionPool));
        if (streamFinished) {
            this.codec = null;
        }
        if (released) {
            this.released = true;
        }
        Socket socket = null;
        if (this.connection != null) {
            if (noNewStreams) {
                this.connection.noNewStreams = true;
            }
            if (this.codec == null && (this.released || this.connection.noNewStreams)) {
                this.release(this.connection);
                if (this.connection.allocations.isEmpty()) {
                    this.connection.idleAtNanos = System.nanoTime();
                    if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                        socket = this.connection.socket();
                    }
                }
                this.connection = null;
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RealConnection realConnection;
        HttpCodec httpCodec;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            httpCodec = this.codec;
            realConnection = this.connection;
        }
        if (httpCodec != null) {
            httpCodec.cancel();
        } else if (realConnection != null) {
            realConnection.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFailed(IOException e2) {
        Socket socket;
        RealConnection realConnection;
        boolean bl = false;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (e2 instanceof StreamResetException) {
                StreamResetException streamResetException = (StreamResetException)e2;
                if (streamResetException.errorCode == ErrorCode.REFUSED_STREAM) {
                    ++this.refusedStreamCount;
                }
                if (streamResetException.errorCode != ErrorCode.REFUSED_STREAM || this.refusedStreamCount > 1) {
                    bl = true;
                    this.route = null;
                }
            } else if (this.connection != null && (!this.connection.isMultiplexed() || e2 instanceof ConnectionShutdownException)) {
                bl = true;
                if (this.connection.successCount == 0) {
                    if (this.route != null && e2 != null) {
                        this.routeSelector.connectFailed(this.route, e2);
                    }
                    this.route = null;
                }
            }
            realConnection = this.connection;
            socket = this.deallocate(bl, false, true);
            if (this.connection != null || !this.reportedAcquired) {
                realConnection = null;
            }
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
    }

    public void acquire(RealConnection connection, boolean reportedAcquired) {
        assert (Thread.holdsLock(this.connectionPool));
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        this.connection = connection;
        this.reportedAcquired = reportedAcquired;
        connection.allocations.add(new StreamAllocationReference(this, this.callStackTrace));
    }

    private void release(RealConnection connection) {
        int n = connection.allocations.size();
        for (int i = 0; i < n; ++i) {
            Reference<StreamAllocation> reference = connection.allocations.get(i);
            if (reference.get() != this) continue;
            connection.allocations.remove(i);
            return;
        }
        throw new IllegalStateException();
    }

    public Socket releaseAndAcquire(RealConnection newConnection) {
        assert (Thread.holdsLock(this.connectionPool));
        if (this.codec != null || this.connection.allocations.size() != 1) {
            throw new IllegalStateException();
        }
        Reference<StreamAllocation> reference = this.connection.allocations.get(0);
        Socket socket = this.deallocate(true, false, false);
        this.connection = newConnection;
        newConnection.allocations.add(reference);
        return socket;
    }

    public boolean hasMoreRoutes() {
        return this.route != null || this.routeSelection != null && this.routeSelection.hasNext() || this.routeSelector.hasNext();
    }

    public String toString() {
        RealConnection realConnection = this.connection();
        return realConnection != null ? realConnection.toString() : this.address.toString();
    }

    public static final class StreamAllocationReference
    extends WeakReference<StreamAllocation> {
        public final Object callStackTrace;

        StreamAllocationReference(StreamAllocation referent, Object callStackTrace) {
            super(referent);
            this.callStackTrace = callStackTrace;
        }
    }
}

