/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.Version;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealResponseBody;
import okio.GzipSource;
import okio.Okio;

public final class BridgeInterceptor
implements Interceptor {
    private final CookieJar cookieJar;

    public BridgeInterceptor(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) {
        List<Cookie> list;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            long l;
            MediaType mediaType = requestBody.contentType();
            if (mediaType != null) {
                builder.header("Content-Type", mediaType.toString());
            }
            if ((l = requestBody.contentLength()) != -1L) {
                builder.header("Content-Length", Long.toString(l));
                builder.removeHeader("Transfer-Encoding");
            } else {
                builder.header("Transfer-Encoding", "chunked");
                builder.removeHeader("Content-Length");
            }
        }
        if (request.header("Host") == null) {
            builder.header("Host", Util.hostHeader(request.url(), false));
        }
        if (request.header("Connection") == null) {
            builder.header("Connection", "Keep-Alive");
        }
        boolean bl = false;
        if (request.header("Accept-Encoding") == null && request.header("Range") == null) {
            bl = true;
            builder.header("Accept-Encoding", "gzip");
        }
        if (!(list = this.cookieJar.loadForRequest(request.url())).isEmpty()) {
            builder.header("Cookie", this.cookieHeader(list));
        }
        if (request.header("User-Agent") == null) {
            builder.header("User-Agent", Version.userAgent());
        }
        Response response = chain.proceed(builder.build());
        HttpHeaders.receiveHeaders(this.cookieJar, request.url(), response.headers());
        Response.Builder builder2 = response.newBuilder().request(request);
        if (bl && "gzip".equalsIgnoreCase(response.header("Content-Encoding")) && HttpHeaders.hasBody(response)) {
            GzipSource gzipSource = new GzipSource(response.body().source());
            Headers headers = response.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            builder2.headers(headers);
            String string = response.header("Content-Type");
            builder2.body(new RealResponseBody(string, -1L, Okio.buffer(gzipSource)));
        }
        return builder2.build();
    }

    private String cookieHeader(List<Cookie> cookies) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = cookies.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append("; ");
            }
            Cookie cookie = cookies.get(i);
            stringBuilder.append(cookie.name()).append('=').append(cookie.value());
        }
        return stringBuilder.toString();
    }
}

