/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;

public final class HttpHeaders {
    private static final String TOKEN = "([^ \"=]*)";
    private static final String QUOTED_STRING = "\"([^\"]*)\"";
    private static final Pattern PARAMETER = Pattern.compile(" +([^ \"=]*)=(:?\"([^\"]*)\"|([^ \"=]*)) *(:?,|$)");

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response cachedResponse, Headers cachedRequest, Request newRequest) {
        for (String string : HttpHeaders.varyFields(cachedResponse)) {
            if (Util.equal(cachedRequest.values(string), newRequest.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers responseHeaders) {
        return HttpHeaders.varyFields(responseHeaders).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers responseHeaders) {
        Set<String> set = Collections.emptySet();
        int n = responseHeaders.size();
        for (int i = 0; i < n; ++i) {
            if (!"Vary".equalsIgnoreCase(responseHeaders.name(i))) continue;
            String string = responseHeaders.value(i);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string2 : string.split(",")) {
                set.add(string2.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response response) {
        Headers headers = response.networkResponse().request().headers();
        Headers headers2 = response.headers();
        return HttpHeaders.varyHeaders(headers, headers2);
    }

    public static Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
        Set<String> set = HttpHeaders.varyFields(responseHeaders);
        if (set.isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder builder = new Headers.Builder();
        int n = requestHeaders.size();
        for (int i = 0; i < n; ++i) {
            String string = requestHeaders.name(i);
            if (!set.contains(string)) continue;
            builder.add(string, requestHeaders.value(i));
        }
        return builder.build();
    }

    public static List<Challenge> parseChallenges(Headers responseHeaders, String challengeHeader) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        List<String> list = responseHeaders.values(challengeHeader);
        for (String string : list) {
            int n = string.indexOf(32);
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            String string3 = null;
            String string4 = null;
            Matcher matcher = PARAMETER.matcher(string);
            int n2 = n;
            while (matcher.find(n2)) {
                if (string.regionMatches(true, matcher.start(1), "realm", 0, 5)) {
                    string3 = matcher.group(3);
                } else if (string.regionMatches(true, matcher.start(1), "charset", 0, 7)) {
                    string4 = matcher.group(3);
                }
                if (string3 != null && string4 != null) break;
                n2 = matcher.end();
            }
            if (string3 == null) continue;
            Challenge challenge = new Challenge(string2, string3);
            if (string4 != null) {
                if (!string4.equalsIgnoreCase("UTF-8")) continue;
                challenge = challenge.withCharset(Util.UTF_8);
            }
            arrayList.add(challenge);
        }
        return arrayList;
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl url, Headers headers) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        List<Cookie> list = Cookie.parseAll(url, headers);
        if (list.isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(url, list);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n = response.code();
        if ((n < 100 || n >= 200) && n != 204 && n != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    public static int skipUntil(String input, int pos, String characters) {
        while (pos < input.length() && characters.indexOf(input.charAt(pos)) == -1) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespace(String input, int pos) {
        char c2;
        while (pos < input.length() && ((c2 = input.charAt(pos)) == ' ' || c2 == '\t')) {
            ++pos;
        }
        return pos;
    }

    public static int parseSeconds(String value, int defaultValue) {
        try {
            long l = Long.parseLong(value);
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (l < 0L) {
                return 0;
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

