/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.UnrepeatableRequestBody;
import okhttp3.internal.http2.ConnectionShutdownException;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private final OkHttpClient client;
    private final boolean forWebSocket;
    private StreamAllocation streamAllocation;
    private Object callStackTrace;
    private volatile boolean canceled;

    public RetryAndFollowUpInterceptor(OkHttpClient client, boolean forWebSocket) {
        this.client = client;
        this.forWebSocket = forWebSocket;
    }

    public void cancel() {
        this.canceled = true;
        StreamAllocation streamAllocation = this.streamAllocation;
        if (streamAllocation != null) {
            streamAllocation.cancel();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCallStackTrace(Object callStackTrace) {
        this.callStackTrace = callStackTrace;
    }

    public StreamAllocation streamAllocation() {
        return this.streamAllocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response intercept(Interceptor.Chain chain) {
        Request request = chain.request();
        RealInterceptorChain realInterceptorChain = (RealInterceptorChain)chain;
        Call call = realInterceptorChain.call();
        EventListener eventListener = realInterceptorChain.eventListener();
        this.streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(request.url()), call, eventListener, this.callStackTrace);
        int n = 0;
        Response response = null;
        while (true) {
            Request request2;
            Response response2;
            if (this.canceled) {
                this.streamAllocation.release();
                throw new IOException("Canceled");
            }
            boolean bl = true;
            try {
                response2 = realInterceptorChain.proceed(request, this.streamAllocation, null, null);
                bl = false;
            }
            catch (RouteException routeException) {
                if (!this.recover(routeException.getLastConnectException(), false, request)) {
                    throw routeException.getLastConnectException();
                }
                bl = false;
                continue;
            }
            catch (IOException iOException) {
                boolean bl2;
                boolean bl3 = bl2 = !(iOException instanceof ConnectionShutdownException);
                if (!this.recover(iOException, bl2, request)) {
                    throw iOException;
                }
                bl = false;
                continue;
            }
            finally {
                if (!bl) continue;
                this.streamAllocation.streamFailed(null);
                this.streamAllocation.release();
                continue;
            }
            if (response != null) {
                response2 = response2.newBuilder().priorResponse(response.newBuilder().body(null).build()).build();
            }
            if ((request2 = this.followUpRequest(response2)) == null) {
                if (!this.forWebSocket) {
                    this.streamAllocation.release();
                }
                return response2;
            }
            Util.closeQuietly(response2.body());
            if (++n > 20) {
                this.streamAllocation.release();
                throw new ProtocolException("Too many follow-up requests: " + n);
            }
            if (request2.body() instanceof UnrepeatableRequestBody) {
                this.streamAllocation.release();
                throw new HttpRetryException("Cannot retry streamed HTTP body", response2.code());
            }
            if (!this.sameConnection(response2, request2.url())) {
                this.streamAllocation.release();
                this.streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(request2.url()), call, eventListener, this.callStackTrace);
            } else if (this.streamAllocation.codec() != null) {
                throw new IllegalStateException("Closing the body of " + response2 + " didn't close its backing stream. Bad interceptor?");
            }
            request = request2;
            response = response2;
        }
    }

    private Address createAddress(HttpUrl url) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (url.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(url.host(), url.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    private boolean recover(IOException e2, boolean requestSendStarted, Request userRequest) {
        this.streamAllocation.streamFailed(e2);
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (requestSendStarted && userRequest.body() instanceof UnrepeatableRequestBody) {
            return false;
        }
        if (!this.isRecoverable(e2, requestSendStarted)) {
            return false;
        }
        return this.streamAllocation.hasMoreRoutes();
    }

    private boolean isRecoverable(IOException e2, boolean requestSendStarted) {
        if (e2 instanceof ProtocolException) {
            return false;
        }
        if (e2 instanceof InterruptedIOException) {
            return e2 instanceof SocketTimeoutException && !requestSendStarted;
        }
        if (e2 instanceof SSLHandshakeException && e2.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e2 instanceof SSLPeerUnverifiedException);
    }

    private Request followUpRequest(Response userResponse) {
        if (userResponse == null) {
            throw new IllegalStateException();
        }
        RealConnection realConnection = this.streamAllocation.connection();
        Route route = realConnection != null ? realConnection.route() : null;
        int n = userResponse.code();
        String string = userResponse.request().method();
        switch (n) {
            case 407: {
                Proxy proxy;
                Proxy proxy2 = proxy = route != null ? route.proxy() : this.client.proxy();
                if (proxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, userResponse);
            }
            case 401: {
                return this.client.authenticator().authenticate(route, userResponse);
            }
            case 307: 
            case 308: {
                if (!string.equals("GET") && !string.equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.client.followRedirects()) {
                    return null;
                }
                String string2 = userResponse.header("Location");
                if (string2 == null) {
                    return null;
                }
                HttpUrl httpUrl = userResponse.request().url().resolve(string2);
                if (httpUrl == null) {
                    return null;
                }
                boolean bl = httpUrl.scheme().equals(userResponse.request().url().scheme());
                if (!bl && !this.client.followSslRedirects()) {
                    return null;
                }
                Request.Builder builder = userResponse.request().newBuilder();
                if (HttpMethod.permitsRequestBody(string)) {
                    boolean bl2 = HttpMethod.redirectsWithBody(string);
                    if (HttpMethod.redirectsToGet(string)) {
                        builder.method("GET", null);
                    } else {
                        RequestBody requestBody = bl2 ? userResponse.request().body() : null;
                        builder.method(string, requestBody);
                    }
                    if (!bl2) {
                        builder.removeHeader("Transfer-Encoding");
                        builder.removeHeader("Content-Length");
                        builder.removeHeader("Content-Type");
                    }
                }
                if (!this.sameConnection(userResponse, httpUrl)) {
                    builder.removeHeader("Authorization");
                }
                return builder.url(httpUrl).build();
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                if (userResponse.request().body() instanceof UnrepeatableRequestBody) {
                    return null;
                }
                if (userResponse.priorResponse() != null && userResponse.priorResponse().code() == 408) {
                    return null;
                }
                return userResponse.request();
            }
        }
        return null;
    }

    private boolean sameConnection(Response response, HttpUrl followUp) {
        HttpUrl httpUrl = response.request().url();
        return httpUrl.host().equals(followUp.host()) && httpUrl.port() == followUp.port() && httpUrl.scheme().equals(followUp.scheme());
    }
}

